/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.scoreboard;

import com.google.common.collect.ImmutableSet;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final ScoreboardTeam team;

    CraftTeam(CraftScoreboard scoreboard, ScoreboardTeam team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.b();
    }

    public Component displayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.team.c());
    }

    public void displayName(Component displayName) throws IllegalStateException, IllegalArgumentException {
        if (displayName == null) {
            displayName = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(PaperAdventure.asVanilla(displayName));
    }

    public Component prefix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.team.e());
    }

    public void prefix(Component prefix) throws IllegalStateException, IllegalArgumentException {
        if (prefix == null) {
            prefix = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.b(PaperAdventure.asVanilla(prefix));
    }

    public Component suffix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.team.f());
    }

    public void suffix(Component suffix) throws IllegalStateException, IllegalArgumentException {
        if (suffix == null) {
            suffix = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.c(PaperAdventure.asVanilla(suffix));
    }

    public TextColor color() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        if (this.team.n().e() == null) {
            throw new IllegalStateException("Team colors must have hex values");
        }
        TextColor color = TextColor.color((int)this.team.n().e());
        if (!(color instanceof NamedTextColor)) {
            throw new IllegalStateException("Team doesn't have a NamedTextColor");
        }
        return (NamedTextColor)color;
    }

    public void color(NamedTextColor color) {
        if (color == null) {
            color = NamedTextColor.WHITE;
        }
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(PaperAdventure.asVanilla((TextColor)color));
    }

    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.c());
    }

    public void setDisplayName(String displayName) throws IllegalStateException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((ChatColor.stripColor((String)displayName).length() <= 128 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 128 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.e());
    }

    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)prefix, (String)"Prefix cannot be null");
        Validate.isTrue((ChatColor.stripColor((String)prefix).length() <= 64 ? 1 : 0) != 0, (String)("Prefix '" + prefix + "' is longer than the limit of 64 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.b(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.f());
    }

    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)suffix, (String)"Suffix cannot be null");
        Validate.isTrue((ChatColor.stripColor((String)suffix).length() <= 64 ? 1 : 0) != 0, (String)("Suffix '" + suffix + "' is longer than the limit of 64 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.team.c(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.getColor(this.team.n());
    }

    public void setColor(ChatColor color) {
        Validate.notNull((Object)color, (String)"Color cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.h();
    }

    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(enabled);
    }

    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.i();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.b(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftTeam.notchToBukkit(this.team.j());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.a(CraftTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.g()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.g()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.g().size();
    }

    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.a(entry, this.team);
    }

    public void addEntities(Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        this.addEntries(entities.stream().map(entity -> ((CraftEntity)entity).getHandle().co()).toList());
    }

    public void addEntries(Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(entries, (String)"Entries cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        ((ScoreboardServer)scoreboard.board).addPlayersToTeam(entries, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.g().contains(entry)) {
            return false;
        }
        scoreboard.board.b(entry, this.team);
        return true;
    }

    public boolean removeEntities(Collection<Entity> entities) throws IllegalStateException, IllegalArgumentException {
        return this.removeEntries(entities.stream().map(entity -> ((CraftEntity)entity).getHandle().co()).toList());
    }

    public boolean removeEntries(Collection<String> entries) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull(entries, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        for (String entry : entries) {
            if (!this.team.g().contains(entry)) continue;
            ((ScoreboardServer)scoreboard.board).removePlayersFromTeam(entries, this.team);
            return true;
        }
        return false;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        return this.team.g().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.d(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.j().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.k().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.l().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + option);
    }

    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.a(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.b(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.a(ScoreboardTeamBase.EnumTeamPush.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + option);
            }
        }
    }

    public void addEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        this.addEntry(((CraftEntity)entity).getHandle().co());
    }

    public boolean removeEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        return this.removeEntry(((CraftEntity)entity).getHandle().co());
    }

    public boolean hasEntity(Entity entity) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        return this.hasEntry(((CraftEntity)entity).getHandle().co());
    }

    public static ScoreboardTeamBase.EnumNameTagVisibility bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.a;
            }
            case NEVER: {
                return ScoreboardTeamBase.EnumNameTagVisibility.b;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.c;
            }
            case HIDE_FOR_OWN_TEAM: {
                return ScoreboardTeamBase.EnumNameTagVisibility.d;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    public static NameTagVisibility notchToBukkit(ScoreboardTeamBase.EnumNameTagVisibility visibility) {
        switch (visibility) {
            case a: {
                return NameTagVisibility.ALWAYS;
            }
            case b: {
                return NameTagVisibility.NEVER;
            }
            case c: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case d: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (this.getScoreboard().board.f(this.team.b()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

