/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.scoreboard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftTeam;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements org.bukkit.scoreboard.Scoreboard {
    final Scoreboard board;
    boolean registeredGlobally = false;

    CraftScoreboard(Scoreboard board) {
        this.board = board;
    }

    public CraftObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name);
    }

    public CraftObjective registerNewObjective(String name, String criteria, Component displayName) {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, String criteria, Component displayName, RenderType renderType) {
        if (displayName == null) {
            displayName = Component.empty();
        }
        Validate.notNull((Object)name, (String)"Objective name cannot be null");
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null");
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.notNull((Object)renderType, (String)"RenderType cannot be null");
        Validate.isTrue((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("The name '" + name + "' is longer than the limit of 32767 characters"));
        Validate.isTrue((this.board.d(name) == null ? 1 : 0) != 0, (String)("An objective of name '" + name + "' already exists"));
        CraftCriteria craftCriteria = CraftCriteria.getFromBukkit(criteria);
        if (craftCriteria.criteria != IScoreboardCriteria.a && !this.registeredGlobally) {
            MinecraftServer.getServer().server.getScoreboardManager().registerScoreboardForVanilla(this);
            this.registeredGlobally = true;
        }
        ScoreboardObjective objective = this.board.a(name, craftCriteria.criteria, PaperAdventure.asVanilla(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType));
        return new CraftObjective(this, objective);
    }

    public CraftObjective registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    public CraftObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, (Component)PaperAdventure.LEGACY_SECTION_UXRC.deserialize(displayName), renderType);
    }

    public Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        ScoreboardObjective nms = this.board.d(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (ScoreboardObjective netObjective : this.board.c()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.board.c(), (Function)new Function<ScoreboardObjective, Objective>(){

            public Objective apply(ScoreboardObjective input) {
                return new CraftObjective(CraftScoreboard.this, input);
            }
        }));
    }

    public Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)slot, (String)"Display slot cannot be null");
        ScoreboardObjective objective = this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        return this.getScores(player.getName());
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (ScoreboardObjective objective : this.board.c()) {
            scores.add((Object)new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        this.resetScores(player.getName());
    }

    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        for (ScoreboardObjective objective : this.board.c()) {
            this.board.d(entry, objective);
        }
    }

    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        ScoreboardTeam team = this.board.i(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        ScoreboardTeam team = this.board.i(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull((Object)teamName, (String)"Team name cannot be null");
        ScoreboardTeam team = this.board.f(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.board.g(), (Function)new Function<ScoreboardTeam, Team>(){

            public Team apply(ScoreboardTeam input) {
                return new CraftTeam(CraftScoreboard.this, input);
            }
        }));
    }

    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Team name cannot be null");
        Validate.isTrue((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("Team name '" + name + "' is longer than the limit of 32767 characters"));
        Validate.isTrue((this.board.f(name) == null ? 1 : 0) != 0, (String)("Team name '" + name + "' is already in use"));
        return new CraftTeam(this, this.board.g(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.board.e()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName.toString()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String entry : this.board.e()) {
            entries.add((Object)entry.toString());
        }
        return entries.build();
    }

    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)slot, (String)"Slot cannot be null");
        this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public Scoreboard getHandle() {
        return this.board;
    }

    public ImmutableSet<Score> getScoresFor(Entity entity) throws IllegalArgumentException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        return this.getScores(((CraftEntity)entity).getHandle().co());
    }

    public void resetScoresFor(Entity entity) throws IllegalArgumentException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        this.resetScores(((CraftEntity)entity).getHandle().co());
    }

    public Team getEntityTeam(Entity entity) throws IllegalArgumentException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        return this.getEntryTeam(((CraftEntity)entity).getHandle().co());
    }
}

