/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.Recipes;
import org.bukkit.Keyed;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.Recipe;

public class RecipeIterator
implements Iterator<Recipe> {
    private final Iterator<Map.Entry<Recipes<?>, Object2ObjectLinkedOpenHashMap<MinecraftKey, IRecipe<?>>>> recipes;
    private Iterator<IRecipe<?>> current;
    private Recipe currentRecipe;

    public RecipeIterator() {
        this.recipes = MinecraftServer.getServer().aC().c.entrySet().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.current != null && this.current.hasNext()) {
            return true;
        }
        if (this.recipes.hasNext()) {
            this.current = this.recipes.next().getValue().values().iterator();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public Recipe next() {
        if (this.current == null || !this.current.hasNext()) {
            this.current = this.recipes.next().getValue().values().iterator();
            this.currentRecipe = this.next();
            return this.currentRecipe;
        }
        this.currentRecipe = this.current.next().toBukkitRecipe();
        return this.currentRecipe;
    }

    @Override
    public void remove() {
        if (this.current == null) {
            throw new IllegalStateException("next() not yet called");
        }
        Recipe recipe = this.currentRecipe;
        if (recipe instanceof Keyed) {
            Keyed keyed = (Keyed)recipe;
            MinecraftServer.getServer().aC().d.remove(CraftNamespacedKey.toMinecraft(keyed.getKey()));
        }
        this.current.remove();
    }
}

