/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.inventory.PaperInventoryCustomHolderContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.core.NonNullList;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang.Validate;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class CraftInventoryCustom
extends CraftInventory {
    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, IInventory delegate) {
        super(new PaperInventoryCustomHolderContainer(owner, delegate, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type) {
        super(new MinecraftInventory(owner, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, Component title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, String title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size) {
        super(new MinecraftInventory(owner, size));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, Component title) {
        super(new MinecraftInventory(owner, size, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, String title) {
        super(new MinecraftInventory(owner, size, title));
    }

    public String getTitle() {
        IInventory iInventory = this.inventory;
        if (iInventory instanceof MinecraftInventory) {
            MinecraftInventory minecraftInventory = (MinecraftInventory)iInventory;
            return minecraftInventory.getTitle();
        }
        iInventory = this.inventory;
        if (iInventory instanceof PaperInventoryCustomHolderContainer) {
            PaperInventoryCustomHolderContainer customHolderContainer = (PaperInventoryCustomHolderContainer)iInventory;
            return customHolderContainer.getTitle();
        }
        throw new UnsupportedOperationException(this.inventory.getClass() + " isn't a recognized Container type here");
    }

    public Component title() {
        IInventory iInventory = this.inventory;
        if (iInventory instanceof MinecraftInventory) {
            MinecraftInventory minecraftInventory = (MinecraftInventory)iInventory;
            return minecraftInventory.title();
        }
        iInventory = this.inventory;
        if (iInventory instanceof PaperInventoryCustomHolderContainer) {
            PaperInventoryCustomHolderContainer customHolderContainer = (PaperInventoryCustomHolderContainer)iInventory;
            return customHolderContainer.title();
        }
        throw new UnsupportedOperationException(this.inventory.getClass() + " isn't a recognized Container type here");
    }

    static class MinecraftInventory
    implements IInventory {
        private final NonNullList<ItemStack> items;
        private int maxStack = 64;
        private final List<HumanEntity> viewers;
        private final String title;
        private final Component adventure$title;
        private InventoryType type;
        private final InventoryHolder owner;

        public MinecraftInventory(InventoryHolder owner, InventoryType type, Component title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type) {
            this(owner, type.getDefaultSize(), type.getDefaultTitle());
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type, String title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, int size) {
            this(owner, size, "Chest");
        }

        public MinecraftInventory(InventoryHolder owner, int size, String title) {
            Validate.notNull((Object)title, (String)"Title cannot be null");
            this.items = NonNullList.a(size, ItemStack.b);
            this.title = title;
            this.adventure$title = PaperAdventure.LEGACY_SECTION_UXRC.deserialize(title);
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        public MinecraftInventory(InventoryHolder owner, int size, Component title) {
            Validate.notNull((Object)title, (String)"Title cannot be null");
            this.items = NonNullList.a(size, ItemStack.b);
            this.title = PaperAdventure.LEGACY_SECTION_UXRC.serialize(title);
            this.adventure$title = title;
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        @Override
        public int b() {
            return this.items.size();
        }

        @Override
        public ItemStack a(int slot) {
            return this.items.get(slot);
        }

        @Override
        public ItemStack a(int slot, int amount) {
            ItemStack result;
            ItemStack stack = this.a(slot);
            if (stack == ItemStack.b) {
                return stack;
            }
            if (stack.J() <= amount) {
                this.a(slot, ItemStack.b);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, amount);
                stack.g(amount);
            }
            this.e();
            return result;
        }

        @Override
        public ItemStack b(int slot) {
            ItemStack result;
            ItemStack stack = this.a(slot);
            if (stack == ItemStack.b) {
                return stack;
            }
            if (stack.J() <= 1) {
                this.a(slot, null);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, 1);
                stack.g(1);
            }
            return result;
        }

        @Override
        public void a(int slot, ItemStack stack) {
            this.items.set(slot, stack);
            if (stack != ItemStack.b && this.N_() > 0 && stack.J() > this.N_()) {
                stack.e(this.N_());
            }
        }

        @Override
        public int N_() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public void e() {
        }

        @Override
        public boolean a(EntityHuman player) {
            return true;
        }

        @Override
        public List<ItemStack> getContents() {
            return this.items;
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.viewers.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.viewers.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        public InventoryType getType() {
            return this.type;
        }

        @Override
        public InventoryHolder getOwner() {
            return this.owner;
        }

        @Override
        public boolean b(int slot, ItemStack stack) {
            return true;
        }

        @Override
        public void b_(EntityHuman player) {
        }

        @Override
        public void c_(EntityHuman player) {
        }

        @Override
        public void a() {
            this.items.clear();
        }

        @Override
        public Location getLocation() {
            return null;
        }

        public Component title() {
            return this.adventure$title;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public boolean c() {
            ItemStack itemstack;
            Iterator iterator = this.items.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((itemstack = (ItemStack)iterator.next()).b());
            return false;
        }
    }
}

