/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.world.item.CreativeModeTab;
import org.bukkit.inventory.CreativeCategory;

public final class CraftCreativeCategory {
    private static final Map<CreativeModeTab, CreativeCategory> NMS_TO_BUKKIT = ImmutableMap.builder().put((Object)CreativeModeTab.b, (Object)CreativeCategory.BUILDING_BLOCKS).put((Object)CreativeModeTab.c, (Object)CreativeCategory.DECORATIONS).put((Object)CreativeModeTab.d, (Object)CreativeCategory.REDSTONE).put((Object)CreativeModeTab.e, (Object)CreativeCategory.TRANSPORTATION).put((Object)CreativeModeTab.f, (Object)CreativeCategory.MISC).put((Object)CreativeModeTab.h, (Object)CreativeCategory.FOOD).put((Object)CreativeModeTab.i, (Object)CreativeCategory.TOOLS).put((Object)CreativeModeTab.j, (Object)CreativeCategory.COMBAT).put((Object)CreativeModeTab.k, (Object)CreativeCategory.BREWING).build();

    public static CreativeCategory fromNMS(CreativeModeTab tab) {
        if (tab == null) {
            return null;
        }
        CreativeCategory bukkit = NMS_TO_BUKKIT.get(tab);
        if (bukkit == null) {
            throw new UnsupportedOperationException("Item is not present in any known CreativeModeTab. This is a bug.");
        }
        return bukkit;
    }
}

