/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, EntityZombieVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityZombieVillager getHandle() {
        return (EntityZombieVillager)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVillagerZombie";
    }

    @Override
    public EntityType getType() {
        return EntityType.ZOMBIE_VILLAGER;
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return Villager.Profession.valueOf((String)IRegistry.an.b(this.getHandle().fK().b()).a().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().a(this.getHandle().fK().a(IRegistry.an.a(new MinecraftKey(profession.name().toLowerCase(Locale.ROOT)))));
    }

    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf((String)IRegistry.am.b(this.getHandle().fK().a()).a().toUpperCase(Locale.ROOT));
    }

    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().a(this.getHandle().fK().a(IRegistry.am.a(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().fJ();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().cc;
    }

    @Override
    public void setConversionTime(int time) {
        if (time < 0) {
            this.getHandle().cc = -1;
            this.getHandle().ai().b(EntityZombieVillager.c, false);
            this.getHandle().setPersistenceRequired(false);
            this.getHandle().cd = null;
            this.getHandle().removeEffect(MobEffects.e, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().a((UUID)null, time);
        }
    }

    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().cd == null ? null : Bukkit.getOfflinePlayer((UUID)this.getHandle().cd);
    }

    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().cd = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

