/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.EntityPig;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAnimals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Pig;

public class CraftPig
extends CraftAnimals
implements Pig {
    public CraftPig(CraftServer server, EntityPig entity) {
        super(server, entity);
    }

    public boolean hasSaddle() {
        return this.getHandle().d();
    }

    public void setSaddle(boolean saddled) {
        this.getHandle().bZ.a(saddled);
    }

    public int getBoostTicks() {
        return this.getHandle().bZ.a ? this.getHandle().bZ.c : 0;
    }

    public void setBoostTicks(int ticks) {
        Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"ticks must be >= 0");
        this.getHandle().bZ.setBoostTicks(ticks);
    }

    public int getCurrentBoostTicks() {
        return this.getHandle().bZ.a ? this.getHandle().bZ.b : 0;
    }

    public void setCurrentBoostTicks(int ticks) {
        if (!this.getHandle().bZ.a) {
            return;
        }
        int max = this.getHandle().bZ.c;
        Preconditions.checkArgument((ticks >= 0 && ticks <= max ? 1 : 0) != 0, (String)"boost ticks must not exceed 0 or %d (inclusive)", (int)max);
        this.getHandle().bZ.b = ticks;
    }

    public Material getSteerMaterial() {
        return Material.CARROT_ON_A_STICK;
    }

    @Override
    public EntityPig getHandle() {
        return (EntityPig)this.entity;
    }

    @Override
    public String toString() {
        return "CraftPig";
    }

    @Override
    public EntityType getType() {
        return EntityType.PIG;
    }
}

