/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventoryLlama;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;

public class CraftLlama
extends CraftChestedHorse
implements Llama,
CraftRangedEntity<EntityLlama> {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, entity);
    }

    @Override
    public EntityLlama getHandle() {
        return (EntityLlama)super.getHandle();
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().gk()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().v(color.ordinal());
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().cg);
    }

    public int getStrength() {
        return this.getHandle().gi();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrengthPublic(strength);
        this.getHandle().fQ();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    public String toString() {
        return "CraftLlama";
    }

    @Override
    public EntityType getType() {
        return EntityType.LLAMA;
    }
}

