/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import java.util.Random;
import java.util.UUID;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.projectile.EntityFireworks;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftProjectile;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class CraftFirework
extends CraftProjectile
implements Firework {
    private final Random random = new Random();

    public CraftFirework(CraftServer server, EntityFireworks entity) {
        super(server, entity);
    }

    @Override
    public EntityFireworks getHandle() {
        return (EntityFireworks)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFirework";
    }

    public EntityType getType() {
        return EntityType.FIREWORK;
    }

    public FireworkMeta getFireworkMeta() {
        return (FireworkMeta)CraftItemStack.getItemMeta(this.getHandle().ai().a(EntityFireworks.b), Material.FIREWORK_ROCKET);
    }

    public void setFireworkMeta(FireworkMeta meta) {
        this.applyFireworkEffect(meta);
        this.getHandle().f = 10 * (1 + meta.getPower()) + this.random.nextInt(6) + this.random.nextInt(7);
        this.getHandle().ai().markDirty(EntityFireworks.b);
    }

    public void detonate() {
        this.getHandle().f = 0;
    }

    public boolean isShotAtAngle() {
        return this.getHandle().i();
    }

    public void setShotAtAngle(boolean shotAtAngle) {
        this.getHandle().ai().b(EntityFireworks.d, shotAtAngle);
    }

    public UUID getSpawningEntity() {
        return this.getHandle().spawningEntity;
    }

    public LivingEntity getBoostedEntity() {
        EntityLiving boostedEntity = this.getHandle().ao;
        return boostedEntity != null ? (LivingEntity)boostedEntity.getBukkitEntity() : null;
    }

    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().h());
    }

    public void setItem(ItemStack itemStack) {
        FireworkMeta meta = this.getFireworkMeta();
        net.minecraft.world.item.ItemStack nmsItem = itemStack == null ? net.minecraft.world.item.ItemStack.b : CraftItemStack.asNMSCopy(itemStack);
        this.getHandle().ai().b(EntityFireworks.b, nmsItem);
        this.applyFireworkEffect(meta);
    }

    public int getTicksFlown() {
        return this.getHandle().e;
    }

    public void setTicksFlown(int ticks) {
        this.getHandle().e = ticks;
    }

    public int getTicksToDetonate() {
        return this.getHandle().f;
    }

    public void setTicksToDetonate(int ticks) {
        this.getHandle().f = ticks;
    }

    void applyFireworkEffect(FireworkMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().h();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().ai().b(EntityFireworks.b, item);
    }
}

