/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityCod;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.animal.EntityDolphin;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.EntityPanda;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityPufferFish;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.entity.animal.EntitySquid;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.horse.EntityHorseZombie;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.EntityLlamaTrader;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCaveSpider;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityDrowned;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityEvoker;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.EntityIllagerWizard;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySkeleton;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.EntitySkeletonStray;
import net.minecraft.world.entity.monster.EntitySkeletonWither;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntitySpider;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.monster.EntityZombieHusk;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.EntityVillagerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityEvokerFangs;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.entity.vehicle.EntityMinecartCommandBlock;
import net.minecraft.world.entity.vehicle.EntityMinecartFurnace;
import net.minecraft.world.entity.vehicle.EntityMinecartHopper;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.entity.vehicle.EntityMinecartRideable;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAbstractVillager;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAmbient;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAreaEffectCloud;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftArmorStand;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftArrow;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAxolotl;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftBat;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftBee;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftBlaze;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCat;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCaveSpider;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCod;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftComplexPart;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCow;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftCreeper;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftDolphin;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftDonkey;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftDragonFireball;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftDrowned;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEgg;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftElderGuardian;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderCrystal;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderDragonPart;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderPearl;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEndermite;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEvoker;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEvokerFangs;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFireball;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFirework;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFish;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFlying;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFox;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGhast;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGiant;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGlowItemFrame;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGlowSquid;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGoat;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftGuardian;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHanging;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHoglin;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHorse;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHusk;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftIllager;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftIllusioner;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftIronGolem;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftItemFrame;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLargeFireball;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLeash;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLlama;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLlamaSpit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMagmaCube;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMarker;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartChest;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartCommand;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartFurnace;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartHopper;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartMobSpawner;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartRideable;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMinecartTNT;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMonster;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMule;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMushroomCow;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftOcelot;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPainting;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPanda;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftParrot;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPhantom;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPig;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPigZombie;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPiglin;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPiglinAbstract;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPiglinBrute;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPillager;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPolarBear;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPufferFish;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftRabbit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftRavager;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSalmon;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSheep;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftShulker;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftShulkerBullet;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSilverfish;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSkeleton;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSkeletonHorse;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSlime;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSmallFireball;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSnowball;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSnowman;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSpectralArrow;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSpider;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftSquid;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftStray;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftStrider;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftThrownExpBottle;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftThrownPotion;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTippedArrow;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTraderLlama;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTrident;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTropicalFish;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTurtle;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVex;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVillagerZombie;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVindicator;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWanderingTrader;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWaterMob;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWitch;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWither;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWitherSkeleton;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftZoglin;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftZombieHorse;
import org.bukkit.craftbukkit.v1_18_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_18_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.PermissibleBase;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

public abstract class CraftEntity
implements Entity {
    private static PermissibleBase perm;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    protected final CraftServer server;
    protected net.minecraft.world.entity.Entity entity;
    private EntityDamageEvent lastDamageEvent;
    private final CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    protected Pointers adventure$pointers;
    private final Entity.Spigot spigot = new Entity.Spigot(){

        public void sendMessage(BaseComponent component) {
        }

        public void sendMessage(BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
        }

        public void sendMessage(UUID sender, BaseComponent component) {
        }
    };

    public CraftEntity(CraftServer server, net.minecraft.world.entity.Entity entity) {
        this.server = server;
        this.entity = entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CraftEntity getEntity(CraftServer server, net.minecraft.world.entity.Entity entity) {
        if (entity instanceof EntityLiving) {
            if (entity instanceof EntityHuman) {
                if (!(entity instanceof EntityPlayer)) return new CraftHumanEntity(server, (EntityHuman)entity);
                return new CraftPlayer(server, (EntityPlayer)entity);
            }
            if (entity instanceof EntityWaterAnimal) {
                if (entity instanceof EntitySquid) {
                    if (!(entity instanceof GlowSquid)) return new CraftSquid(server, (EntitySquid)entity);
                    return new CraftGlowSquid(server, (GlowSquid)entity);
                }
                if (entity instanceof EntityFish) {
                    if (entity instanceof EntityCod) {
                        return new CraftCod(server, (EntityCod)entity);
                    }
                    if (entity instanceof EntityPufferFish) {
                        return new CraftPufferFish(server, (EntityPufferFish)entity);
                    }
                    if (entity instanceof EntitySalmon) {
                        return new CraftSalmon(server, (EntitySalmon)entity);
                    }
                    if (!(entity instanceof EntityTropicalFish)) return new CraftFish(server, (EntityFish)entity);
                    return new CraftTropicalFish(server, (EntityTropicalFish)entity);
                }
                if (!(entity instanceof EntityDolphin)) return new CraftWaterMob(server, (EntityWaterAnimal)entity);
                return new CraftDolphin(server, (EntityDolphin)entity);
            }
            if (entity instanceof EntityCreature) {
                if (entity instanceof EntityAnimal) {
                    if (entity instanceof EntityChicken) {
                        return new CraftChicken(server, (EntityChicken)entity);
                    }
                    if (entity instanceof EntityCow) {
                        if (!(entity instanceof EntityMushroomCow)) return new CraftCow(server, (EntityCow)entity);
                        return new CraftMushroomCow(server, (EntityMushroomCow)entity);
                    }
                    if (entity instanceof EntityPig) {
                        return new CraftPig(server, (EntityPig)entity);
                    }
                    if (entity instanceof EntityTameableAnimal) {
                        if (entity instanceof EntityWolf) {
                            return new CraftWolf(server, (EntityWolf)entity);
                        }
                        if (entity instanceof EntityCat) {
                            return new CraftCat(server, (EntityCat)entity);
                        }
                        if (!(entity instanceof EntityParrot)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                        return new CraftParrot(server, (EntityParrot)entity);
                    }
                    if (entity instanceof EntitySheep) {
                        return new CraftSheep(server, (EntitySheep)entity);
                    }
                    if (entity instanceof EntityHorseAbstract) {
                        if (entity instanceof EntityHorseChestedAbstract) {
                            if (entity instanceof EntityHorseDonkey) {
                                return new CraftDonkey(server, (EntityHorseDonkey)entity);
                            }
                            if (entity instanceof EntityHorseMule) {
                                return new CraftMule(server, (EntityHorseMule)entity);
                            }
                            if (entity instanceof EntityLlamaTrader) {
                                return new CraftTraderLlama(server, (EntityLlamaTrader)entity);
                            }
                            if (!(entity instanceof EntityLlama)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                            return new CraftLlama(server, (EntityLlama)entity);
                        }
                        if (entity instanceof EntityHorse) {
                            return new CraftHorse(server, (EntityHorse)entity);
                        }
                        if (entity instanceof EntityHorseSkeleton) {
                            return new CraftSkeletonHorse(server, (EntityHorseSkeleton)entity);
                        }
                        if (!(entity instanceof EntityHorseZombie)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                        return new CraftZombieHorse(server, (EntityHorseZombie)entity);
                    }
                    if (entity instanceof EntityRabbit) {
                        return new CraftRabbit(server, (EntityRabbit)entity);
                    }
                    if (entity instanceof EntityPolarBear) {
                        return new CraftPolarBear(server, (EntityPolarBear)entity);
                    }
                    if (entity instanceof EntityTurtle) {
                        return new CraftTurtle(server, (EntityTurtle)entity);
                    }
                    if (entity instanceof EntityOcelot) {
                        return new CraftOcelot(server, (EntityOcelot)entity);
                    }
                    if (entity instanceof EntityPanda) {
                        return new CraftPanda(server, (EntityPanda)entity);
                    }
                    if (entity instanceof EntityFox) {
                        return new CraftFox(server, (EntityFox)entity);
                    }
                    if (entity instanceof EntityBee) {
                        return new CraftBee(server, (EntityBee)entity);
                    }
                    if (entity instanceof EntityHoglin) {
                        return new CraftHoglin(server, (EntityHoglin)entity);
                    }
                    if (entity instanceof EntityStrider) {
                        return new CraftStrider(server, (EntityStrider)entity);
                    }
                    if (entity instanceof Axolotl) {
                        return new CraftAxolotl(server, (Axolotl)entity);
                    }
                    if (!(entity instanceof Goat)) return new CraftAnimals(server, (EntityAnimal)entity);
                    return new CraftGoat(server, (Goat)entity);
                }
                if (entity instanceof EntityMonster) {
                    if (entity instanceof EntityZombie) {
                        if (entity instanceof EntityPigZombie) {
                            return new CraftPigZombie(server, (EntityPigZombie)entity);
                        }
                        if (entity instanceof EntityZombieHusk) {
                            return new CraftHusk(server, (EntityZombieHusk)entity);
                        }
                        if (entity instanceof EntityZombieVillager) {
                            return new CraftVillagerZombie(server, (EntityZombieVillager)entity);
                        }
                        if (!(entity instanceof EntityDrowned)) return new CraftZombie(server, (EntityZombie)entity);
                        return new CraftDrowned(server, (EntityDrowned)entity);
                    }
                    if (entity instanceof EntityCreeper) {
                        return new CraftCreeper(server, (EntityCreeper)entity);
                    }
                    if (entity instanceof EntityEnderman) {
                        return new CraftEnderman(server, (EntityEnderman)entity);
                    }
                    if (entity instanceof EntitySilverfish) {
                        return new CraftSilverfish(server, (EntitySilverfish)entity);
                    }
                    if (entity instanceof EntityGiantZombie) {
                        return new CraftGiant(server, (EntityGiantZombie)entity);
                    }
                    if (entity instanceof EntitySkeletonAbstract) {
                        if (entity instanceof EntitySkeletonStray) {
                            return new CraftStray(server, (EntitySkeletonStray)entity);
                        }
                        if (entity instanceof EntitySkeletonWither) {
                            return new CraftWitherSkeleton(server, (EntitySkeletonWither)entity);
                        }
                        if (!(entity instanceof EntitySkeleton)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                        return new CraftSkeleton(server, (EntitySkeleton)entity);
                    }
                    if (entity instanceof EntityBlaze) {
                        return new CraftBlaze(server, (EntityBlaze)entity);
                    }
                    if (entity instanceof EntityWitch) {
                        return new CraftWitch(server, (EntityWitch)entity);
                    }
                    if (entity instanceof EntityWither) {
                        return new CraftWither(server, (EntityWither)entity);
                    }
                    if (entity instanceof EntitySpider) {
                        if (!(entity instanceof EntityCaveSpider)) return new CraftSpider(server, (EntitySpider)entity);
                        return new CraftCaveSpider(server, (EntityCaveSpider)entity);
                    }
                    if (entity instanceof EntityEndermite) {
                        return new CraftEndermite(server, (EntityEndermite)entity);
                    }
                    if (entity instanceof EntityGuardian) {
                        if (!(entity instanceof EntityGuardianElder)) return new CraftGuardian(server, (EntityGuardian)entity);
                        return new CraftElderGuardian(server, (EntityGuardianElder)entity);
                    }
                    if (entity instanceof EntityVex) {
                        return new CraftVex(server, (EntityVex)entity);
                    }
                    if (entity instanceof EntityIllagerAbstract) {
                        if (entity instanceof EntityIllagerWizard) {
                            if (entity instanceof EntityEvoker) {
                                return new CraftEvoker(server, (EntityEvoker)entity);
                            }
                            if (!(entity instanceof EntityIllagerIllusioner)) return new CraftSpellcaster(server, (EntityIllagerWizard)entity);
                            return new CraftIllusioner(server, (EntityIllagerIllusioner)entity);
                        }
                        if (entity instanceof EntityVindicator) {
                            return new CraftVindicator(server, (EntityVindicator)entity);
                        }
                        if (!(entity instanceof EntityPillager)) return new CraftIllager(server, (EntityIllagerAbstract)entity);
                        return new CraftPillager(server, (EntityPillager)entity);
                    }
                    if (entity instanceof EntityRavager) {
                        return new CraftRavager(server, (EntityRavager)entity);
                    }
                    if (entity instanceof EntityPiglinAbstract) {
                        if (entity instanceof EntityPiglin) {
                            return new CraftPiglin(server, (EntityPiglin)entity);
                        }
                        if (!(entity instanceof EntityPiglinBrute)) return new CraftPiglinAbstract(server, (EntityPiglinAbstract)entity);
                        return new CraftPiglinBrute(server, (EntityPiglinBrute)entity);
                    }
                    if (!(entity instanceof EntityZoglin)) return new CraftMonster(server, (EntityMonster)entity);
                    return new CraftZoglin(server, (EntityZoglin)entity);
                }
                if (entity instanceof EntityGolem) {
                    if (entity instanceof EntitySnowman) {
                        return new CraftSnowman(server, (EntitySnowman)entity);
                    }
                    if (entity instanceof EntityIronGolem) {
                        return new CraftIronGolem(server, (EntityIronGolem)entity);
                    }
                    if (!(entity instanceof EntityShulker)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
                    return new CraftShulker(server, (EntityShulker)entity);
                }
                if (!(entity instanceof EntityVillagerAbstract)) return new CraftCreature(server, (EntityCreature)entity);
                if (entity instanceof EntityVillager) {
                    return new CraftVillager(server, (EntityVillager)entity);
                }
                if (!(entity instanceof EntityVillagerTrader)) return new CraftAbstractVillager(server, (EntityVillagerAbstract)entity);
                return new CraftWanderingTrader(server, (EntityVillagerTrader)entity);
            }
            if (entity instanceof EntitySlime) {
                if (!(entity instanceof EntityMagmaCube)) return new CraftSlime(server, (EntitySlime)entity);
                return new CraftMagmaCube(server, (EntityMagmaCube)entity);
            }
            if (entity instanceof EntityFlying) {
                if (entity instanceof EntityGhast) {
                    return new CraftGhast(server, (EntityGhast)entity);
                }
                if (!(entity instanceof EntityPhantom)) return new CraftFlying(server, (EntityFlying)entity);
                return new CraftPhantom(server, (EntityPhantom)entity);
            }
            if (entity instanceof EntityEnderDragon) {
                return new CraftEnderDragon(server, (EntityEnderDragon)entity);
            }
            if (entity instanceof EntityAmbient) {
                if (!(entity instanceof EntityBat)) return new CraftAmbient(server, (EntityAmbient)entity);
                return new CraftBat(server, (EntityBat)entity);
            }
            if (!(entity instanceof EntityArmorStand)) return new CraftLivingEntity(server, (EntityLiving)entity);
            return new CraftArmorStand(server, (EntityArmorStand)entity);
        }
        if (entity instanceof EntityComplexPart) {
            EntityComplexPart part = (EntityComplexPart)entity;
            if (!(part.b instanceof EntityEnderDragon)) return new CraftComplexPart(server, (EntityComplexPart)entity);
            return new CraftEnderDragonPart(server, (EntityComplexPart)entity);
        }
        if (entity instanceof EntityExperienceOrb) {
            return new CraftExperienceOrb(server, (EntityExperienceOrb)entity);
        }
        if (entity instanceof EntityTippedArrow) {
            return new CraftTippedArrow(server, (EntityTippedArrow)entity);
        }
        if (entity instanceof EntitySpectralArrow) {
            return new CraftSpectralArrow(server, (EntitySpectralArrow)entity);
        }
        if (entity instanceof EntityArrow) {
            if (!(entity instanceof EntityThrownTrident)) return new CraftArrow(server, (EntityArrow)entity);
            return new CraftTrident(server, (EntityThrownTrident)entity);
        }
        if (entity instanceof EntityBoat) {
            return new CraftBoat(server, (EntityBoat)entity);
        }
        if (entity instanceof EntityProjectile) {
            if (entity instanceof EntityEgg) {
                return new CraftEgg(server, (EntityEgg)entity);
            }
            if (entity instanceof EntitySnowball) {
                return new CraftSnowball(server, (EntitySnowball)entity);
            }
            if (entity instanceof EntityPotion) {
                return new CraftThrownPotion(server, (EntityPotion)entity);
            }
            if (entity instanceof EntityEnderPearl) {
                return new CraftEnderPearl(server, (EntityEnderPearl)entity);
            }
            if (!(entity instanceof EntityThrownExpBottle)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
            return new CraftThrownExpBottle(server, (EntityThrownExpBottle)entity);
        }
        if (entity instanceof EntityFallingBlock) {
            return new CraftFallingBlock(server, (EntityFallingBlock)entity);
        }
        if (entity instanceof EntityFireball) {
            if (entity instanceof EntitySmallFireball) {
                return new CraftSmallFireball(server, (EntitySmallFireball)entity);
            }
            if (entity instanceof EntityLargeFireball) {
                return new CraftLargeFireball(server, (EntityLargeFireball)entity);
            }
            if (entity instanceof EntityWitherSkull) {
                return new CraftWitherSkull(server, (EntityWitherSkull)entity);
            }
            if (!(entity instanceof EntityDragonFireball)) return new CraftFireball(server, (EntityFireball)entity);
            return new CraftDragonFireball(server, (EntityDragonFireball)entity);
        }
        if (entity instanceof EntityEnderSignal) {
            return new CraftEnderSignal(server, (EntityEnderSignal)entity);
        }
        if (entity instanceof EntityEnderCrystal) {
            return new CraftEnderCrystal(server, (EntityEnderCrystal)entity);
        }
        if (entity instanceof EntityFishingHook) {
            return new CraftFishHook(server, (EntityFishingHook)entity);
        }
        if (entity instanceof EntityItem) {
            return new CraftItem(server, (EntityItem)entity);
        }
        if (entity instanceof EntityLightning) {
            return new CraftLightningStrike(server, (EntityLightning)entity);
        }
        if (entity instanceof EntityMinecartAbstract) {
            if (entity instanceof EntityMinecartFurnace) {
                return new CraftMinecartFurnace(server, (EntityMinecartFurnace)entity);
            }
            if (entity instanceof EntityMinecartChest) {
                return new CraftMinecartChest(server, (EntityMinecartChest)entity);
            }
            if (entity instanceof EntityMinecartTNT) {
                return new CraftMinecartTNT(server, (EntityMinecartTNT)entity);
            }
            if (entity instanceof EntityMinecartHopper) {
                return new CraftMinecartHopper(server, (EntityMinecartHopper)entity);
            }
            if (entity instanceof EntityMinecartMobSpawner) {
                return new CraftMinecartMobSpawner(server, (EntityMinecartMobSpawner)entity);
            }
            if (entity instanceof EntityMinecartRideable) {
                return new CraftMinecartRideable(server, (EntityMinecartRideable)entity);
            }
            if (!(entity instanceof EntityMinecartCommandBlock)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
            return new CraftMinecartCommand(server, (EntityMinecartCommandBlock)entity);
        }
        if (entity instanceof EntityHanging) {
            if (entity instanceof EntityPainting) {
                return new CraftPainting(server, (EntityPainting)entity);
            }
            if (entity instanceof EntityItemFrame) {
                if (!(entity instanceof GlowItemFrame)) return new CraftItemFrame(server, (EntityItemFrame)entity);
                return new CraftGlowItemFrame(server, (GlowItemFrame)entity);
            }
            if (!(entity instanceof EntityLeash)) return new CraftHanging(server, (EntityHanging)entity);
            return new CraftLeash(server, (EntityLeash)entity);
        }
        if (entity instanceof EntityTNTPrimed) {
            return new CraftTNTPrimed(server, (EntityTNTPrimed)entity);
        }
        if (entity instanceof EntityFireworks) {
            return new CraftFirework(server, (EntityFireworks)entity);
        }
        if (entity instanceof EntityShulkerBullet) {
            return new CraftShulkerBullet(server, (EntityShulkerBullet)entity);
        }
        if (entity instanceof EntityAreaEffectCloud) {
            return new CraftAreaEffectCloud(server, (EntityAreaEffectCloud)entity);
        }
        if (entity instanceof EntityEvokerFangs) {
            return new CraftEvokerFangs(server, (EntityEvokerFangs)entity);
        }
        if (entity instanceof EntityLlamaSpit) {
            return new CraftLlamaSpit(server, (EntityLlamaSpit)entity);
        }
        if (!(entity instanceof Marker)) throw new AssertionError((Object)("Unknown entity " + (entity == null ? null : entity.getClass())));
        return new CraftMarker(server, (Marker)entity);
    }

    public Location getLocation() {
        return new Location(this.getWorld(), this.entity.dc(), this.entity.de(), this.entity.di(), this.entity.getBukkitYaw(), this.entity.do());
    }

    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.entity.dc());
            loc.setY(this.entity.de());
            loc.setZ(this.entity.di());
            loc.setYaw(this.entity.getBukkitYaw());
            loc.setPitch(this.entity.do());
        }
        return loc;
    }

    public Vector getVelocity() {
        return CraftVector.toBukkit(this.entity.da());
    }

    public void setVelocity(Vector velocity) {
        Preconditions.checkArgument((velocity != null ? 1 : 0) != 0, (Object)"velocity");
        velocity.checkFinite();
        if (!(this instanceof Projectile) && !(this instanceof Minecart) && CraftEntity.isUnsafeVelocity(velocity)) {
            CraftServer.excessiveVelEx = new Exception("Excessive velocity set detected: tried to set velocity of entity " + this.entity.co() + " id #" + this.getEntityId() + " to (" + velocity.getX() + "," + velocity.getY() + "," + velocity.getZ() + ").");
        }
        this.entity.g(CraftVector.toNMS(velocity));
        this.entity.D = true;
    }

    private static boolean isUnsafeVelocity(Vector vel) {
        double x2 = vel.getX();
        double y2 = vel.getY();
        double z2 = vel.getZ();
        return x2 > 4.0 || x2 < -4.0 || y2 > 4.0 || y2 < -4.0 || z2 > 4.0 || z2 < -4.0;
    }

    public double getHeight() {
        return this.getHandle().cU();
    }

    public double getWidth() {
        return this.getHandle().cT();
    }

    public BoundingBox getBoundingBox() {
        AxisAlignedBB bb = this.getHandle().cw();
        return new BoundingBox(bb.a, bb.b, bb.c, bb.d, bb.e, bb.f);
    }

    public boolean isOnGround() {
        if (this.entity instanceof EntityArrow) {
            return ((EntityArrow)this.entity).b;
        }
        return this.entity.aw();
    }

    public boolean isInWater() {
        return this.entity.aQ();
    }

    public World getWorld() {
        return this.entity.s.getWorld();
    }

    public void setRotation(float yaw, float pitch) {
        NumberConversions.checkFinite((float)pitch, (String)"pitch not finite");
        NumberConversions.checkFinite((float)yaw, (String)"yaw not finite");
        yaw = Location.normalizeYaw((float)yaw);
        pitch = Location.normalizePitch((float)pitch);
        this.entity.o(yaw);
        this.entity.p(pitch);
        this.entity.w = yaw;
        this.entity.x = pitch;
        this.entity.l(yaw);
    }

    public CompletableFuture<Boolean> teleportAsync(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        location.checkFinite();
        Location locationClone = location.clone();
        WorldServer world = ((CraftWorld)locationClone.getWorld()).getHandle();
        CompletableFuture<Boolean> ret = new CompletableFuture<Boolean>();
        world.loadChunksForMoveAsync(this.getHandle().getBoundingBoxAt(locationClone.getX(), locationClone.getY(), locationClone.getZ()), location.getX(), location.getZ(), list -> {
            ChunkProviderServer chunkProviderServer = world.k();
            for (IChunkAccess chunk : list) {
                chunkProviderServer.addTicketAtLevel(TicketType.g, chunk.f(), 33, this.getEntityId());
            }
            MinecraftServer.getServer().scheduleOnMain(() -> {
                try {
                    ret.complete(this.teleport(locationClone, cause) ? Boolean.TRUE : Boolean.FALSE);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    ret.completeExceptionally(throwable);
                }
            });
        });
        return ret;
    }

    public boolean teleport(Location location) {
        return this.teleport(location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        location.checkFinite();
        if (this.entity.bG() || this.entity.dp()) {
            return false;
        }
        this.entity.p();
        if (!location.getWorld().equals(this.getWorld())) {
            Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot teleport entity to an other world during world generation");
            this.entity.teleportTo(((CraftWorld)location.getWorld()).getHandle(), new BlockPosition(location.getX(), location.getY(), location.getZ()));
            return true;
        }
        this.entity.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.entity.l(location.getYaw());
        return true;
    }

    public boolean teleport(Entity destination) {
        return this.teleport(destination.getLocation());
    }

    public boolean teleport(Entity destination, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(destination.getLocation(), cause);
    }

    public List<Entity> getNearbyEntities(double x2, double y2, double z2) {
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot get nearby entities during world generation");
        AsyncCatcher.catchOp("getNearbyEntities");
        List<net.minecraft.world.entity.Entity> notchEntityList = this.entity.s.a(this.entity, this.entity.cw().c(x2, y2, z2), (Predicate<? super net.minecraft.world.entity.Entity>)Predicates.alwaysTrue());
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(notchEntityList.size());
        for (net.minecraft.world.entity.Entity e2 : notchEntityList) {
            bukkitEntityList.add(e2.getBukkitEntity());
        }
        return bukkitEntityList;
    }

    public int getEntityId() {
        return this.entity.ae();
    }

    public int getFireTicks() {
        return this.entity.aF;
    }

    public int getMaxFireTicks() {
        return this.entity.cP();
    }

    public void setFireTicks(int ticks) {
        this.entity.aF = ticks;
    }

    public void setVisualFire(boolean fire) {
        this.getHandle().bd = fire;
    }

    public boolean isVisualFire() {
        return this.getHandle().bd;
    }

    public int getFreezeTicks() {
        return this.getHandle().bZ();
    }

    public int getMaxFreezeTicks() {
        return this.getHandle().cc();
    }

    public void setFreezeTicks(int ticks) {
        Preconditions.checkArgument((0 <= ticks ? 1 : 0) != 0, (Object)"Ticks cannot be less than 0");
        this.getHandle().j(ticks);
    }

    public boolean isFrozen() {
        return this.getHandle().cb();
    }

    public boolean isFreezeTickingLocked() {
        return this.entity.freezeLocked;
    }

    public void lockFreezeTicks(boolean locked) {
        this.entity.freezeLocked = locked;
    }

    public void remove() {
        this.entity.ah();
    }

    public boolean isDead() {
        return !this.entity.bl();
    }

    public boolean isValid() {
        return this.entity.bl() && this.entity.valid && this.entity.isChunkLoaded();
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isPersistent() {
        return this.entity.persist;
    }

    public void setPersistent(boolean persistent) {
        this.entity.persist = persistent;
    }

    public Vector getMomentum() {
        return this.getVelocity();
    }

    public void setMomentum(Vector value) {
        this.setVelocity(value);
    }

    public Entity getPassenger() {
        return this.isEmpty() ? null : ((net.minecraft.world.entity.Entity)this.getHandle().au.get(0)).getBukkitEntity();
    }

    public boolean setPassenger(Entity passenger) {
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        if (passenger instanceof CraftEntity) {
            this.eject();
            return ((CraftEntity)passenger).getHandle().k(this.getHandle());
        }
        return false;
    }

    public List<Entity> getPassengers() {
        return Lists.newArrayList((Iterable)Lists.transform(this.getHandle().au, (Function)new Function<net.minecraft.world.entity.Entity, Entity>(){

            public Entity apply(net.minecraft.world.entity.Entity input) {
                return input.getBukkitEntity();
            }
        }));
    }

    public boolean addPassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"passenger == null");
        Preconditions.checkArgument((!this.equals(passenger) ? 1 : 0) != 0, (Object)"Entity cannot ride itself.");
        return ((CraftEntity)passenger).getHandle().a(this.getHandle(), true);
    }

    public boolean removePassenger(Entity passenger) {
        Preconditions.checkArgument((passenger != null ? 1 : 0) != 0, (Object)"passenger == null");
        ((CraftEntity)passenger).getHandle().p();
        return true;
    }

    public boolean isEmpty() {
        return !this.getHandle().bG();
    }

    public boolean eject() {
        if (this.isEmpty()) {
            return false;
        }
        this.getHandle().bs();
        return true;
    }

    public float getFallDistance() {
        return this.getHandle().L;
    }

    public void setFallDistance(float distance) {
        this.getHandle().L = distance;
    }

    public void setLastDamageCause(EntityDamageEvent event) {
        this.lastDamageEvent = event;
    }

    public EntityDamageEvent getLastDamageCause() {
        return this.lastDamageEvent;
    }

    public UUID getUniqueId() {
        return this.getHandle().cm();
    }

    public int getTicksLived() {
        return this.getHandle().S;
    }

    public void setTicksLived(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("Age must be at least 1 tick");
        }
        this.getHandle().S = value;
    }

    public net.minecraft.world.entity.Entity getHandle() {
        return this.entity;
    }

    public void playEffect(EntityEffect type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type");
        Preconditions.checkState((!this.entity.generation ? 1 : 0) != 0, (Object)"Cannot play effect during world generation");
        if (type.getApplicable().isInstance(this)) {
            this.getHandle().s.a(this.getHandle(), type.getData());
        }
    }

    public void setHandle(net.minecraft.world.entity.Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        return "CraftEntity{id=" + this.getEntityId() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftEntity other = (CraftEntity)obj;
        return this.getHandle() == other.getHandle();
    }

    public int hashCode() {
        return this.getUniqueId().hashCode();
    }

    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getEntityMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getEntityMetadata().getMetadata(this, metadataKey);
    }

    public boolean hasMetadata(String metadataKey) {
        return this.server.getEntityMetadata().hasMetadata(this, metadataKey);
    }

    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getEntityMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    public boolean isInsideVehicle() {
        return this.getHandle().bF();
    }

    public boolean leaveVehicle() {
        if (!this.isInsideVehicle()) {
            return false;
        }
        this.getHandle().p();
        return true;
    }

    public Entity getVehicle() {
        if (!this.isInsideVehicle()) {
            return null;
        }
        return this.getHandle().cN().getBukkitEntity();
    }

    public Component customName() {
        IChatBaseComponent name = this.getHandle().Z();
        return name != null ? PaperAdventure.asAdventure(name) : null;
    }

    public void customName(Component customName) {
        this.getHandle().a(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.DISPLAY_NAME, this::name).withDynamic(Identity.UUID, this::getUniqueId).withStatic(PermissionChecker.POINTER, arg_0 -> ((CraftEntity)this).permissionValue(arg_0)).build();
        }
        return this.adventure$pointers;
    }

    public void setCustomName(String name) {
        if (name != null && name.length() > 256) {
            name = name.substring(0, 256);
        }
        this.getHandle().a(CraftChatMessage.fromStringOrNull(name));
    }

    public String getCustomName() {
        IChatBaseComponent name = this.getHandle().Z();
        if (name == null) {
            return null;
        }
        return CraftChatMessage.fromComponent(name);
    }

    public void setCustomNameVisible(boolean flag) {
        this.getHandle().n(flag);
    }

    public boolean isCustomNameVisible() {
        return this.getHandle().cr();
    }

    public void sendMessage(String message) {
    }

    public void sendMessage(String ... messages) {
    }

    public void sendMessage(UUID sender, String message) {
        this.sendMessage(message);
    }

    public void sendMessage(UUID sender, String ... messages) {
        this.sendMessage(messages);
    }

    public String getName() {
        return CraftChatMessage.fromComponent(this.getHandle().X());
    }

    public @NotNull Component name() {
        return PaperAdventure.asAdventure(this.getHandle().X());
    }

    public @NotNull Component teamDisplayName() {
        return PaperAdventure.asAdventure(this.getHandle().C_());
    }

    public boolean isPermissionSet(String name) {
        return CraftEntity.getPermissibleBase().isPermissionSet(name);
    }

    public boolean isPermissionSet(Permission perm) {
        return CraftEntity.getPermissibleBase().isPermissionSet(perm);
    }

    public boolean hasPermission(String name) {
        return CraftEntity.getPermissibleBase().hasPermission(name);
    }

    public boolean hasPermission(Permission perm) {
        return CraftEntity.getPermissibleBase().hasPermission(perm);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value);
    }

    public PermissionAttachment addAttachment(Plugin plugin) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin);
    }

    public PermissionAttachment addAttachment(Plugin plugin, String name, boolean value, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, name, value, ticks);
    }

    public PermissionAttachment addAttachment(Plugin plugin, int ticks) {
        return CraftEntity.getPermissibleBase().addAttachment(plugin, ticks);
    }

    public void removeAttachment(PermissionAttachment attachment) {
        CraftEntity.getPermissibleBase().removeAttachment(attachment);
    }

    public void recalculatePermissions() {
        CraftEntity.getPermissibleBase().recalculatePermissions();
    }

    public Set<PermissionAttachmentInfo> getEffectivePermissions() {
        return CraftEntity.getPermissibleBase().getEffectivePermissions();
    }

    public boolean isOp() {
        return CraftEntity.getPermissibleBase().isOp();
    }

    public void setOp(boolean value) {
        CraftEntity.getPermissibleBase().setOp(value);
    }

    public void setGlowing(boolean flag) {
        this.getHandle().i(flag);
    }

    public boolean isGlowing() {
        return this.getHandle().bT();
    }

    public void setInvulnerable(boolean flag) {
        this.getHandle().m(flag);
    }

    public boolean isInvulnerable() {
        return this.getHandle().b(DamageSource.n);
    }

    public boolean isSilent() {
        return this.getHandle().aL();
    }

    public void setSilent(boolean flag) {
        this.getHandle().d(flag);
    }

    public boolean hasGravity() {
        return !this.getHandle().aM();
    }

    public void setGravity(boolean gravity) {
        this.getHandle().e(!gravity);
    }

    public int getPortalCooldown() {
        return this.getHandle().aT;
    }

    public void setPortalCooldown(int cooldown) {
        this.getHandle().aT = cooldown;
    }

    public Set<String> getScoreboardTags() {
        return this.getHandle().af();
    }

    public boolean addScoreboardTag(String tag) {
        return this.getHandle().a(tag);
    }

    public boolean removeScoreboardTag(String tag) {
        return this.getHandle().b(tag);
    }

    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById((int)this.getHandle().c_().ordinal());
    }

    public BlockFace getFacing() {
        return CraftBlock.notchToBlockFace(this.getHandle().cu());
    }

    public CraftPersistentDataContainer getPersistentDataContainer() {
        return this.persistentDataContainer;
    }

    public Pose getPose() {
        return Pose.values()[this.getHandle().ak().ordinal()];
    }

    public SpawnCategory getSpawnCategory() {
        return CraftSpawnCategory.toBukkit(this.getHandle().ad().f());
    }

    public void storeBukkitValues(NBTTagCompound c2) {
        if (!this.persistentDataContainer.isEmpty()) {
            c2.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
    }

    public void readBukkitValues(NBTTagCompound c2) {
        NBTBase base = c2.c("BukkitValues");
        if (base instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)base);
        }
    }

    protected NBTTagCompound save() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("id", this.getHandle().bk());
        this.getHandle().f(nbttagcompound);
        return nbttagcompound;
    }

    protected void update() {
        if (!this.getHandle().bl()) {
            return;
        }
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)world.k().a.J.get(this.getEntityId());
        if (entityTracker == null) {
            return;
        }
        entityTracker.a(this.getHandle().S());
    }

    private static PermissibleBase getPermissibleBase() {
        if (perm == null) {
            perm = new PermissibleBase(new ServerOperator(){

                public boolean isOp() {
                    return false;
                }

                public void setOp(boolean value) {
                }
            });
        }
        return perm;
    }

    public Entity.Spigot spigot() {
        return this.spigot;
    }

    public Location getOrigin() {
        Vector originVector = this.getHandle().getOriginVector();
        if (originVector == null) {
            return null;
        }
        World world = this.getWorld();
        if (this.getHandle().getOriginWorld() != null) {
            world = Bukkit.getWorld((UUID)this.getHandle().getOriginWorld());
        }
        return originVector.toLocation(world);
    }

    public boolean fromMobSpawner() {
        return this.getHandle().spawnedViaMobSpawner;
    }

    public CreatureSpawnEvent.SpawnReason getEntitySpawnReason() {
        return this.getHandle().spawnReason;
    }

    public boolean isInRain() {
        return this.getHandle().i();
    }

    public boolean isInBubbleColumn() {
        return this.getHandle().j();
    }

    public boolean isInWaterOrRain() {
        return this.getHandle().aR();
    }

    public boolean isInWaterOrBubbleColumn() {
        return this.getHandle().aT();
    }

    public boolean isInWaterOrRainOrBubbleColumn() {
        return this.getHandle().aS();
    }

    public boolean isInLava() {
        return this.getHandle().bc();
    }

    public boolean isTicking() {
        return this.getHandle().isTicking();
    }

    public Set<Player> getTrackedPlayers() {
        if (this.entity.tracker == null) {
            return Collections.emptySet();
        }
        HashSet<Player> set = new HashSet<Player>(this.entity.tracker.f.size());
        for (ServerPlayerConnection connection : this.entity.tracker.f) {
            set.add(connection.e().getBukkitEntity().getPlayer());
        }
        return set;
    }

    public boolean spawnAt(Location location, CreatureSpawnEvent.SpawnReason reason) {
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        Preconditions.checkNotNull((Object)reason, (Object)"reason cannot be null");
        this.entity.s = ((CraftWorld)location.getWorld()).getHandle();
        this.entity.e(location.getX(), location.getY(), location.getZ());
        this.entity.a(location.getYaw(), location.getPitch());
        return !this.entity.valid && this.entity.s.addFreshEntity(this.entity, reason);
    }

    public boolean isInPowderedSnow() {
        return this.getHandle().al || this.getHandle().am;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    }
}

