/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMob;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;

public class CraftEnderDragon
extends CraftMob
implements EnderDragon {
    public CraftEnderDragon(CraftServer server, EntityEnderDragon entity) {
        super(server, entity);
    }

    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EntityComplexPart part : this.getHandle().ch) {
            builder.add((Object)((ComplexEntityPart)part.getBukkitEntity()));
        }
        return builder.build();
    }

    @Override
    public EntityEnderDragon getHandle() {
        return (EntityEnderDragon)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderDragon";
    }

    @Override
    public EntityType getType() {
        return EntityType.ENDER_DRAGON;
    }

    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[this.getHandle().ai().a(EntityEnderDragon.b)];
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().fx().a(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(DragonControllerPhase phase) {
        return EnderDragon.Phase.values()[phase.b()];
    }

    public static DragonControllerPhase getMinecraftPhase(EnderDragon.Phase phase) {
        return DragonControllerPhase.a(phase.ordinal());
    }

    public BossBar getBossBar() {
        DragonBattle battle = this.getDragonBattle();
        return battle != null ? battle.getBossBar() : null;
    }

    public DragonBattle getDragonBattle() {
        return this.getHandle().fy() != null ? new CraftDragonBattle(this.getHandle().fy()) : null;
    }

    public int getDeathAnimationTicks() {
        return this.getHandle().bX;
    }
}

