/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import net.minecraft.world.entity.vehicle.EntityBoat;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftVehicle;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Boat;
import org.bukkit.entity.EntityType;

public class CraftBoat
extends CraftVehicle
implements Boat {
    public CraftBoat(CraftServer server, EntityBoat entity) {
        super(server, entity);
    }

    public TreeSpecies getWoodType() {
        return CraftBoat.getTreeSpecies(this.getHandle().r());
    }

    public void setWoodType(TreeSpecies species) {
        this.getHandle().a(CraftBoat.getBoatType(species));
    }

    public double getMaxSpeed() {
        return this.getHandle().maxSpeed;
    }

    public void setMaxSpeed(double speed) {
        if (speed >= 0.0) {
            this.getHandle().maxSpeed = speed;
        }
    }

    public double getOccupiedDeceleration() {
        return this.getHandle().occupiedDeceleration;
    }

    public void setOccupiedDeceleration(double speed) {
        if (speed >= 0.0) {
            this.getHandle().occupiedDeceleration = speed;
        }
    }

    public double getUnoccupiedDeceleration() {
        return this.getHandle().unoccupiedDeceleration;
    }

    public void setUnoccupiedDeceleration(double speed) {
        this.getHandle().unoccupiedDeceleration = speed;
    }

    public boolean getWorkOnLand() {
        return this.getHandle().landBoats;
    }

    public void setWorkOnLand(boolean workOnLand) {
        this.getHandle().landBoats = workOnLand;
    }

    public Material getBoatMaterial() {
        return CraftMagicNumbers.getMaterial(this.getHandle().h());
    }

    @Override
    public EntityBoat getHandle() {
        return (EntityBoat)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBoat";
    }

    public EntityType getType() {
        return EntityType.BOAT;
    }

    public static TreeSpecies getTreeSpecies(EntityBoat.EnumBoatType boatType) {
        switch (boatType) {
            case b: {
                return TreeSpecies.REDWOOD;
            }
            case c: {
                return TreeSpecies.BIRCH;
            }
            case d: {
                return TreeSpecies.JUNGLE;
            }
            case e: {
                return TreeSpecies.ACACIA;
            }
            case f: {
                return TreeSpecies.DARK_OAK;
            }
        }
        return TreeSpecies.GENERIC;
    }

    public static EntityBoat.EnumBoatType getBoatType(TreeSpecies species) {
        switch (species) {
            case REDWOOD: {
                return EntityBoat.EnumBoatType.b;
            }
            case BIRCH: {
                return EntityBoat.EnumBoatType.c;
            }
            case JUNGLE: {
                return EntityBoat.EnumBoatType.d;
            }
            case ACACIA: {
                return EntityBoat.EnumBoatType.e;
            }
            case DARK_OAK: {
                return EntityBoat.EnumBoatType.f;
            }
        }
        return EntityBoat.EnumBoatType.a;
    }
}

