/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.base.Preconditions;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.animal.EntityBee;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAnimals;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;

public class CraftBee
extends CraftAnimals
implements Bee {
    public CraftBee(CraftServer server, EntityBee entity) {
        super(server, entity);
    }

    @Override
    public EntityBee getHandle() {
        return (EntityBee)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBee";
    }

    @Override
    public EntityType getType() {
        return EntityType.BEE;
    }

    public Location getHive() {
        BlockPosition hive = this.getHandle().fI();
        return hive == null ? null : new Location(this.getWorld(), (double)hive.u(), (double)hive.v(), (double)hive.w());
    }

    public void setHive(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.getHandle().cI = location == null ? null : new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public Location getFlower() {
        BlockPosition flower = this.getHandle().q();
        return flower == null ? null : new Location(this.getWorld(), (double)flower.u(), (double)flower.v(), (double)flower.w());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.getHandle().g(location == null ? null : new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()));
    }

    public boolean hasNectar() {
        return this.getHandle().fK();
    }

    public void setHasNectar(boolean nectar) {
        this.getHandle().v(nectar);
    }

    public boolean hasStung() {
        return this.getHandle().fL();
    }

    public void setHasStung(boolean stung) {
        this.getHandle().w(stung);
    }

    public int getAnger() {
        return this.getHandle().a();
    }

    public void setAnger(int anger) {
        this.getHandle().a(anger);
    }

    public int getCannotEnterHiveTicks() {
        return this.getHandle().cB;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.getHandle().s(ticks);
    }

    public void setRollingOverride(TriState rolling) {
        this.getHandle().rollingOverride = rolling;
        this.getHandle().x(this.getHandle().fX());
    }

    public boolean isRolling() {
        return this.getRollingOverride().toBooleanOrElse(this.getHandle().fX());
    }

    public TriState getRollingOverride() {
        return this.getHandle().rollingOverride;
    }
}

