/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import org.apache.commons.lang.Validate;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_18_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionUtil;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAreaEffectCloud
extends CraftEntity
implements AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, EntityAreaEffectCloud entity) {
        super(server, entity);
    }

    @Override
    public EntityAreaEffectCloud getHandle() {
        return (EntityAreaEffectCloud)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    public EntityType getType() {
        return EntityType.AREA_EFFECT_CLOUD;
    }

    public int getDuration() {
        return this.getHandle().n();
    }

    public void setDuration(int duration) {
        this.getHandle().b(duration);
    }

    public int getWaitTime() {
        return this.getHandle().au;
    }

    public void setWaitTime(int waitTime) {
        this.getHandle().d(waitTime);
    }

    public int getReapplicationDelay() {
        return this.getHandle().av;
    }

    public void setReapplicationDelay(int delay) {
        this.getHandle().av = delay;
    }

    public int getDurationOnUse() {
        return this.getHandle().ax;
    }

    public void setDurationOnUse(int duration) {
        this.getHandle().ax = duration;
    }

    public float getRadius() {
        return this.getHandle().h();
    }

    public void setRadius(float radius) {
        this.getHandle().a(radius);
    }

    public float getRadiusOnUse() {
        return this.getHandle().ay;
    }

    public void setRadiusOnUse(float radius) {
        this.getHandle().b(radius);
    }

    public float getRadiusPerTick() {
        return this.getHandle().az;
    }

    public void setRadiusPerTick(float radius) {
        this.getHandle().c(radius);
    }

    public Particle getParticle() {
        return CraftParticle.toBukkit(this.getHandle().j());
    }

    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    public <T> void setParticle(Particle particle, T data) {
        this.getHandle().a(CraftParticle.toNMS(particle, data));
    }

    public Color getColor() {
        return Color.fromRGB((int)this.getHandle().i());
    }

    public void setColor(Color color) {
        this.getHandle().a(color.asRGB());
    }

    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        int effectId = effect.getType().getId();
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().ar) {
            if (MobEffectList.a(mobEffect.a()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().ar.remove(existing);
        }
        this.getHandle().a(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().refreshEffects();
        return true;
    }

    public void clearCustomEffects() {
        this.getHandle().ar.clear();
        this.getHandle().refreshEffects();
    }

    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : this.getHandle().ar) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    public boolean hasCustomEffect(PotionEffectType type) {
        for (MobEffect effect : this.getHandle().ar) {
            if (!CraftPotionUtil.equals(effect.a(), type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEffects() {
        return !this.getHandle().ar.isEmpty();
    }

    public boolean removeCustomEffect(PotionEffectType effect) {
        int effectId = effect.getId();
        MobEffect existing = null;
        for (MobEffect mobEffect : this.getHandle().ar) {
            if (MobEffectList.a(mobEffect.a()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().ar.remove(existing);
        this.getHandle().refreshEffects();
        return true;
    }

    public void setBasePotionData(PotionData data) {
        Validate.notNull((Object)data, (String)"PotionData cannot be null");
        this.getHandle().setPotionType(CraftPotionUtil.fromBukkit(data));
    }

    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getHandle().getPotionType());
    }

    public ProjectileSource getSource() {
        EntityLiving source = this.getHandle().t();
        return source == null ? null : (LivingEntity)source.getBukkitEntity();
    }

    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            this.getHandle().a(((CraftLivingEntity)shooter).getHandle());
        } else {
            this.getHandle().a((EntityLiving)null);
        }
    }
}

