/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.entity;

import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftSaddledInventory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, EntityHorseAbstract entity) {
        super(server, entity);
    }

    @Override
    public EntityHorseAbstract getHandle() {
        return (EntityHorseAbstract)this.entity;
    }

    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public int getDomestication() {
        return this.getHandle().fP();
    }

    public void setDomestication(int value) {
        Validate.isTrue((value >= 0 ? 1 : 0) != 0, (String)"Domestication cannot be less than zero");
        Validate.isTrue((value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication cannot be greater than the max domestication");
        this.getHandle().t(value);
    }

    public int getMaxDomestication() {
        return this.getHandle().fW();
    }

    public void setMaxDomestication(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Max domestication cannot be zero or less");
        this.getHandle().maxDomestication = value;
    }

    public double getJumpStrength() {
        return this.getHandle().fS();
    }

    public void setJumpStrength(double strength) {
        Validate.isTrue((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength cannot be less than zero");
        this.getHandle().a(GenericAttributes.m).a(strength);
    }

    public boolean isTamed() {
        return this.getHandle().fJ();
    }

    public void setTamed(boolean tamed) {
        this.getHandle().w(tamed);
    }

    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setTarget(null, null, false);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUniqueId() {
        return this.getOwnerUUID();
    }

    public UUID getOwnerUUID() {
        return this.getHandle().fK();
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().b(uuid);
    }

    public boolean isEatingHaystack() {
        return this.getHandle().fM();
    }

    public void setEatingHaystack(boolean eatingHaystack) {
        this.getHandle().z(eatingHaystack);
    }

    public AbstractHorseInventory getInventory() {
        return new CraftSaddledInventory(this.getHandle().cg);
    }

    public boolean isEatingGrass() {
        return this.getHandle().fM();
    }

    public void setEatingGrass(boolean eating) {
        this.getHandle().z(eating);
    }

    public boolean isRearing() {
        return this.getHandle().fN();
    }

    public void setRearing(boolean rearing) {
        this.getHandle().setForceStanding(rearing);
    }

    public boolean isEating() {
        return this.getHandle().isMouthOpen();
    }

    public void setEating(boolean eating) {
        this.getHandle().setMouthOpen(eating);
    }
}

