/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.command;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.command.ServerCommandSender;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;

public class CraftBlockCommandSender
extends ServerCommandSender
implements BlockCommandSender {
    private final CommandListenerWrapper block;
    private final TileEntity tile;

    public CraftBlockCommandSender(CommandListenerWrapper commandBlockListenerAbstract, TileEntity tile) {
        this.block = commandBlockListenerAbstract;
        this.tile = tile;
    }

    public Block getBlock() {
        return CraftBlock.at(this.tile.k(), this.tile.p());
    }

    public void sendMessage(String message) {
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.block.c.a(component, SystemUtils.c);
        }
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public String getName() {
        return this.block.c();
    }

    public Component name() {
        return PaperAdventure.asAdventure(this.block.b());
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of a block");
    }

    public CommandListenerWrapper getWrapper() {
        return this.block;
    }
}

