/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;

public final class CraftChorusFruit
extends CraftBlockData
implements MultipleFacing {
    private static final BlockStateBoolean[] FACES = new BlockStateBoolean[]{CraftChorusFruit.getBoolean(BlockChorusFruit.class, "north", true), CraftChorusFruit.getBoolean(BlockChorusFruit.class, "east", true), CraftChorusFruit.getBoolean(BlockChorusFruit.class, "south", true), CraftChorusFruit.getBoolean(BlockChorusFruit.class, "west", true), CraftChorusFruit.getBoolean(BlockChorusFruit.class, "up", true), CraftChorusFruit.getBoolean(BlockChorusFruit.class, "down", true)};

    public CraftChorusFruit() {
    }

    public CraftChorusFruit(IBlockData state) {
        super(state);
    }

    public boolean hasFace(BlockFace face) {
        BlockStateBoolean state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        return this.get(state);
    }

    public void setFace(BlockFace face, boolean has) {
        BlockStateBoolean state = FACES[face.ordinal()];
        if (state == null) {
            throw new IllegalArgumentException("Non-allowed face " + face + ". Check MultipleFacing.getAllowedFaces.");
        }
        this.set(state, has);
    }

    public Set<BlockFace> getFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null || !this.get(FACES[i2]).booleanValue()) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }

    public Set<BlockFace> getAllowedFaces() {
        ImmutableSet.Builder faces = ImmutableSet.builder();
        for (int i2 = 0; i2 < FACES.length; ++i2) {
            if (FACES[i2] == null) continue;
            faces.add((Object)BlockFace.values()[i2]);
        }
        return faces.build();
    }
}

