/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.ArgumentBlock;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockBamboo;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerWall;
import net.minecraft.world.level.block.BlockBarrel;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockBeetroot;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.BlockBlastFurnace;
import net.minecraft.world.level.block.BlockBrewingStand;
import net.minecraft.world.level.block.BlockBubbleColumn;
import net.minecraft.world.level.block.BlockCactus;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockCarrots;
import net.minecraft.world.level.block.BlockChain;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.BlockChestTrapped;
import net.minecraft.world.level.block.BlockChorusFlower;
import net.minecraft.world.level.block.BlockChorusFruit;
import net.minecraft.world.level.block.BlockCobbleWall;
import net.minecraft.world.level.block.BlockCocoa;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockConduit;
import net.minecraft.world.level.block.BlockCoralDead;
import net.minecraft.world.level.block.BlockCoralFan;
import net.minecraft.world.level.block.BlockCoralFanAbstract;
import net.minecraft.world.level.block.BlockCoralFanWall;
import net.minecraft.world.level.block.BlockCoralFanWallAbstract;
import net.minecraft.world.level.block.BlockCoralPlant;
import net.minecraft.world.level.block.BlockCrops;
import net.minecraft.world.level.block.BlockDaylightDetector;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockDropper;
import net.minecraft.world.level.block.BlockEndRod;
import net.minecraft.world.level.block.BlockEnderChest;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockFire;
import net.minecraft.world.level.block.BlockFloorSign;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockFurnaceFurace;
import net.minecraft.world.level.block.BlockGlazedTerracotta;
import net.minecraft.world.level.block.BlockGrass;
import net.minecraft.world.level.block.BlockGrindstone;
import net.minecraft.world.level.block.BlockHay;
import net.minecraft.world.level.block.BlockHopper;
import net.minecraft.world.level.block.BlockHugeMushroom;
import net.minecraft.world.level.block.BlockIceFrost;
import net.minecraft.world.level.block.BlockIronBars;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.BlockKelp;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockLantern;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.BlockLoom;
import net.minecraft.world.level.block.BlockMinecartDetector;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockMycel;
import net.minecraft.world.level.block.BlockNetherWart;
import net.minecraft.world.level.block.BlockNote;
import net.minecraft.world.level.block.BlockObserver;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.BlockPotatoes;
import net.minecraft.world.level.block.BlockPoweredRail;
import net.minecraft.world.level.block.BlockPressurePlateBinary;
import net.minecraft.world.level.block.BlockPressurePlateWeighted;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRedstoneComparator;
import net.minecraft.world.level.block.BlockRedstoneLamp;
import net.minecraft.world.level.block.BlockRedstoneOre;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.BlockRedstoneTorchWall;
import net.minecraft.world.level.block.BlockRedstoneWire;
import net.minecraft.world.level.block.BlockReed;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockRotatable;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockScaffolding;
import net.minecraft.world.level.block.BlockSeaPickle;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockSkullPlayer;
import net.minecraft.world.level.block.BlockSkullPlayerWall;
import net.minecraft.world.level.block.BlockSkullWall;
import net.minecraft.world.level.block.BlockSmoker;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.BlockSoil;
import net.minecraft.world.level.block.BlockStainedGlassPane;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStem;
import net.minecraft.world.level.block.BlockStemAttached;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockStoneButton;
import net.minecraft.world.level.block.BlockStonecutter;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockTallPlant;
import net.minecraft.world.level.block.BlockTallPlantFlower;
import net.minecraft.world.level.block.BlockTarget;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.BlockTrapdoor;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.BlockTripwireHook;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.BlockTwistingVines;
import net.minecraft.world.level.block.BlockVine;
import net.minecraft.world.level.block.BlockWallSign;
import net.minecraft.world.level.block.BlockWeepingVines;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.BlockWitherSkullWall;
import net.minecraft.world.level.block.BlockWoodButton;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CaveVinesPlantBlock;
import net.minecraft.world.level.block.GlowLichenBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.InfestedRotatedPillarBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.PowderSnowCauldronBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.WeatheringCopperSlabBlock;
import net.minecraft.world.level.block.WeatheringCopperStairBlock;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.bukkit.Material;
import org.bukkit.SoundGroup;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftSoundGroup;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftAmethystCluster;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftAnvil;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBamboo;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBanner;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBannerWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBarrel;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBed;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBeehive;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBeetroot;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBell;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBigDripleaf;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBigDripleafStem;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBlastFurnace;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftBubbleColumn;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCactus;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCake;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCampfire;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCandle;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCandleCake;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCarrots;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCaveVines;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCaveVinesPlant;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftChain;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftChest;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftChestTrapped;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftChorusFlower;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftChorusFruit;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCobbleWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCocoa;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCommand;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftComposter;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftConduit;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCoralDead;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCoralFan;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCoralFanAbstract;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCoralFanWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCoralFanWallAbstract;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCoralPlant;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftCrops;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftDaylightDetector;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftDirtSnow;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftDispenser;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftDoor;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftDropper;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftEndRod;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftEnderChest;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftEnderPortalFrame;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftFence;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftFenceGate;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftFire;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftFloorSign;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftFluids;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftFurnaceFurace;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftGlazedTerracotta;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftGlowLichen;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftGrass;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftGrindstone;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftHangingRoots;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftHay;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftHopper;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftHugeMushroom;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftIceFrost;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftInfestedRotatedPillar;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftIronBars;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftJigsaw;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftJukeBox;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftKelp;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLadder;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLantern;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLayeredCauldron;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLeaves;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLectern;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLever;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLight;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLightningRod;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftLoom;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftMinecartDetector;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftMinecartTrack;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftMycel;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftNetherWart;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftNote;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftObserver;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPiston;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPistonExtension;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPistonMoving;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPointedDripstone;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPortal;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPotatoes;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPowderSnowCauldron;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPoweredRail;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPressurePlateBinary;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPressurePlateWeighted;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftPumpkinCarved;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRedstoneComparator;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRedstoneLamp;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRedstoneOre;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRedstoneTorch;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRedstoneTorchWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRedstoneWire;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftReed;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRepeater;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRespawnAnchor;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftRotatable;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSapling;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftScaffolding;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSculkSensor;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSeaPickle;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftShulkerBox;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSkull;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSkullPlayer;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSkullPlayerWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSkullWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSmallDripleaf;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSmoker;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSnow;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSoil;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStainedGlassPane;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStairs;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStem;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStemAttached;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStepAbstract;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStoneButton;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStonecutter;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftStructure;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftSweetBerryBush;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTNT;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTallPlant;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTallPlantFlower;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTallSeagrass;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTarget;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTorchWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTrapdoor;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTripwire;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTripwireHook;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTurtleEgg;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftTwistingVines;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftVine;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWallSign;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWeatheringCopperSlab;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWeatheringCopperStair;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWeepingVines;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWitherSkull;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWitherSkullWall;
import org.bukkit.craftbukkit.v1_18_R2.block.impl.CraftWoodButton;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;

public class CraftBlockData
implements BlockData {
    private IBlockData state;
    private Map<IBlockState<?>, Comparable<?>> parsedStates;
    private static final Map<Class<? extends Enum<?>>, Enum<?>[]> ENUM_VALUES = new HashMap();
    private static final Map<Class<? extends Block>, Function<IBlockData, CraftBlockData>> MAP = new HashMap<Class<? extends Block>, Function<IBlockData, CraftBlockData>>();
    private static Map<String, CraftBlockData> stringDataCache;

    protected CraftBlockData() {
        throw new AssertionError((Object)"Template Constructor");
    }

    protected CraftBlockData(IBlockData state) {
        this.state = state;
    }

    public Material getMaterial() {
        return this.state.getBukkitMaterial();
    }

    public IBlockData getState() {
        return this.state;
    }

    protected <B extends Enum<B>> B get(BlockStateEnum<?> nms, Class<B> bukkit) {
        return CraftBlockData.toBukkit((Enum)this.state.c(nms), bukkit);
    }

    protected <B extends Enum<B>> Set<B> getValues(BlockStateEnum<?> nms, Class<B> bukkit) {
        ImmutableSet.Builder values = ImmutableSet.builder();
        for (Enum e2 : nms.a()) {
            values.add(CraftBlockData.toBukkit(e2, bukkit));
        }
        return values.build();
    }

    protected <B extends Enum<B>, N extends Enum<N>> void set(BlockStateEnum<N> nms, Enum<B> bukkit) {
        this.parsedStates = null;
        this.state = (IBlockData)this.state.a(nms, CraftBlockData.toNMS(bukkit, nms.g()));
    }

    public BlockData merge(BlockData data) {
        CraftBlockData craft = (CraftBlockData)data;
        Preconditions.checkArgument((craft.parsedStates != null ? 1 : 0) != 0, (Object)"Data not created via string parsing");
        Preconditions.checkArgument((this.state.b() == craft.state.b() ? 1 : 0) != 0, (String)"States have different types (got %s, expected %s)", (Object)data, (Object)this);
        CraftBlockData clone = (CraftBlockData)this.clone();
        clone.parsedStates = null;
        for (IBlockState<?> parsed : craft.parsedStates.keySet()) {
            clone.state = (IBlockData)clone.state.a(parsed, craft.state.c(parsed));
        }
        return clone;
    }

    public boolean matches(BlockData data) {
        if (data == null) {
            return false;
        }
        if (!(data instanceof CraftBlockData)) {
            return false;
        }
        CraftBlockData craft = (CraftBlockData)data;
        if (this.state.b() != craft.state.b()) {
            return false;
        }
        boolean exactMatch = this.equals(data);
        if (!exactMatch && craft.parsedStates != null) {
            return this.merge(data).equals(this);
        }
        return exactMatch;
    }

    private static <B extends Enum<B>> B toBukkit(Enum<?> nms, Class<B> bukkit) {
        if (nms instanceof EnumDirection) {
            return (B)CraftBlock.notchToBlockFace((EnumDirection)nms);
        }
        return (B)ENUM_VALUES.computeIfAbsent(bukkit, Class::getEnumConstants)[nms.ordinal()];
    }

    public static <N extends Enum<N>> N toNMS(Enum<?> bukkit, Class<N> nms) {
        if (bukkit instanceof BlockFace) {
            return (N)CraftBlock.blockFaceToNotch((BlockFace)bukkit);
        }
        return (N)ENUM_VALUES.computeIfAbsent(nms, Class::getEnumConstants)[bukkit.ordinal()];
    }

    protected <T extends Comparable<T>> T get(IBlockState<T> ibs) {
        return this.state.c(ibs);
    }

    public <T extends Comparable<T>, V extends T> void set(IBlockState<T> ibs, V v2) {
        this.parsedStates = null;
        this.state = (IBlockData)this.state.a(ibs, v2);
    }

    public String getAsString() {
        return this.toString((Map<IBlockState<?>, Comparable<?>>)this.state.u());
    }

    public String getAsString(boolean hideUnspecified) {
        return hideUnspecified && this.parsedStates != null ? this.toString(this.parsedStates) : this.getAsString();
    }

    public BlockData clone() {
        try {
            return (BlockData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    public String toString() {
        return "CraftBlockData{" + this.getAsString() + "}";
    }

    public String toString(Map<IBlockState<?>, Comparable<?>> states) {
        StringBuilder stateString = new StringBuilder(IRegistry.U.b(this.state.b()).toString());
        if (!states.isEmpty()) {
            stateString.append('[');
            stateString.append(states.entrySet().stream().map(IBlockDataHolder.a).collect(Collectors.joining(",")));
            stateString.append(']');
        }
        return stateString.toString();
    }

    public NBTTagCompound toStates() {
        NBTTagCompound compound = new NBTTagCompound();
        for (Map.Entry entry : this.state.u().entrySet()) {
            IBlockState iblockstate = (IBlockState)entry.getKey();
            compound.a(iblockstate.f(), iblockstate.a((Comparable)entry.getValue()));
        }
        return compound;
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftBlockData && this.state.equals(((CraftBlockData)obj).state);
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    protected static BlockStateBoolean getBoolean(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateBoolean getBoolean(String name, boolean optional) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateEnum<?> getEnum(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateInteger getInteger(String name) {
        throw new AssertionError((Object)"Template Method");
    }

    protected static BlockStateBoolean getBoolean(Class<? extends Block> block, String name) {
        return (BlockStateBoolean)CraftBlockData.getState(block, name, false);
    }

    protected static BlockStateBoolean getBoolean(Class<? extends Block> block, String name, boolean optional) {
        return (BlockStateBoolean)CraftBlockData.getState(block, name, optional);
    }

    protected static BlockStateEnum<?> getEnum(Class<? extends Block> block, String name) {
        return (BlockStateEnum)CraftBlockData.getState(block, name, false);
    }

    protected static BlockStateInteger getInteger(Class<? extends Block> block, String name) {
        return (BlockStateInteger)CraftBlockData.getState(block, name, false);
    }

    private static IBlockState<?> getState(Class<? extends Block> block, String name, boolean optional) {
        IBlockState<?> state = null;
        for (Block instance : IRegistry.U) {
            if (instance.getClass() != block) continue;
            if (state == null) {
                state = instance.m().a(name);
                continue;
            }
            IBlockState<?> newState = instance.m().a(name);
            Preconditions.checkState((state == newState ? 1 : 0) != 0, (String)"State mistmatch %s,%s", state, newState);
        }
        Preconditions.checkState((optional || state != null ? 1 : 0) != 0, (String)"Null state for %s,%s", block, (Object)name);
        return state;
    }

    protected static int getMin(BlockStateInteger state) {
        return state.min;
    }

    protected static int getMax(BlockStateInteger state) {
        return state.max;
    }

    private static void register(Class<? extends Block> nms, Function<IBlockData, CraftBlockData> bukkit) {
        Preconditions.checkState((MAP.put(nms, bukkit) == null ? 1 : 0) != 0, (String)"Duplicate mapping %s->%s", nms, bukkit);
    }

    public static void reloadCache() {
        stringDataCache.clear();
        Block.o.forEach(blockData -> stringDataCache.put(blockData.toString(), blockData.createCraftBlockData()));
    }

    public static CraftBlockData newData(Material material, String data) {
        Block block;
        Preconditions.checkArgument((material == null || material.isBlock() ? 1 : 0) != 0, (String)"Cannot get data for not block %s", (Object)material);
        if (material != null && (block = CraftMagicNumbers.getBlock(material)) != null) {
            MinecraftKey key = IRegistry.U.b(block);
            data = data == null ? key.toString() : key + (String)data;
        }
        CraftBlockData cached = stringDataCache.computeIfAbsent((String)data, s2 -> CraftBlockData.createNewData(null, s2));
        return (CraftBlockData)cached.clone();
    }

    private static CraftBlockData createNewData(Material material, String data) {
        IBlockData blockData;
        Block block = CraftMagicNumbers.getBlock(material);
        Map<IBlockState<?>, Comparable<?>> parsed = null;
        if (data != null) {
            try {
                if (block != null) {
                    data = IRegistry.U.b(block) + (String)data;
                }
                StringReader reader = new StringReader((String)data);
                ArgumentBlock arg = new ArgumentBlock(reader, false).a(false);
                Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (Object)("Spurious trailing data: " + (String)data));
                blockData = arg.b();
                parsed = arg.a();
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException("Could not parse data: " + (String)data, ex);
            }
        } else {
            blockData = block.n();
        }
        CraftBlockData craft = CraftBlockData.fromData(blockData);
        craft.parsedStates = parsed;
        return craft;
    }

    public static CraftBlockData fromData(IBlockData data) {
        return data.createCraftBlockData();
    }

    public static CraftBlockData createData(IBlockData data) {
        return (CraftBlockData)MAP.getOrDefault(data.b().getClass(), (Function<IBlockData, CraftBlockData>)((Function)CraftBlockData::new)).apply((Object)data);
    }

    public SoundGroup getSoundGroup() {
        return CraftSoundGroup.getSoundGroup(this.state.q());
    }

    static {
        CraftBlockData.register(AmethystClusterBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftAmethystCluster::new));
        CraftBlockData.register(BigDripleafBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBigDripleaf::new));
        CraftBlockData.register(BigDripleafStemBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBigDripleafStem::new));
        CraftBlockData.register(BlockAnvil.class, (Function<IBlockData, CraftBlockData>)((Function)CraftAnvil::new));
        CraftBlockData.register(BlockBamboo.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBamboo::new));
        CraftBlockData.register(BlockBanner.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBanner::new));
        CraftBlockData.register(BlockBannerWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBannerWall::new));
        CraftBlockData.register(BlockBarrel.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBarrel::new));
        CraftBlockData.register(BlockBed.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBed::new));
        CraftBlockData.register(BlockBeehive.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBeehive::new));
        CraftBlockData.register(BlockBeetroot.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBeetroot::new));
        CraftBlockData.register(BlockBell.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBell::new));
        CraftBlockData.register(BlockBlastFurnace.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBlastFurnace::new));
        CraftBlockData.register(BlockBrewingStand.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBrewingStand::new));
        CraftBlockData.register(BlockBubbleColumn.class, (Function<IBlockData, CraftBlockData>)((Function)CraftBubbleColumn::new));
        CraftBlockData.register(BlockCactus.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCactus::new));
        CraftBlockData.register(BlockCake.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCake::new));
        CraftBlockData.register(BlockCampfire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCampfire::new));
        CraftBlockData.register(BlockCarrots.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCarrots::new));
        CraftBlockData.register(BlockChain.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChain::new));
        CraftBlockData.register(BlockChest.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChest::new));
        CraftBlockData.register(BlockChestTrapped.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChestTrapped::new));
        CraftBlockData.register(BlockChorusFlower.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChorusFlower::new));
        CraftBlockData.register(BlockChorusFruit.class, (Function<IBlockData, CraftBlockData>)((Function)CraftChorusFruit::new));
        CraftBlockData.register(BlockCobbleWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCobbleWall::new));
        CraftBlockData.register(BlockCocoa.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCocoa::new));
        CraftBlockData.register(BlockCommand.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCommand::new));
        CraftBlockData.register(BlockComposter.class, (Function<IBlockData, CraftBlockData>)((Function)CraftComposter::new));
        CraftBlockData.register(BlockConduit.class, (Function<IBlockData, CraftBlockData>)((Function)CraftConduit::new));
        CraftBlockData.register(BlockCoralDead.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralDead::new));
        CraftBlockData.register(BlockCoralFan.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFan::new));
        CraftBlockData.register(BlockCoralFanAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFanAbstract::new));
        CraftBlockData.register(BlockCoralFanWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFanWall::new));
        CraftBlockData.register(BlockCoralFanWallAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralFanWallAbstract::new));
        CraftBlockData.register(BlockCoralPlant.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCoralPlant::new));
        CraftBlockData.register(BlockCrops.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCrops::new));
        CraftBlockData.register(BlockDaylightDetector.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDaylightDetector::new));
        CraftBlockData.register(BlockDirtSnow.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDirtSnow::new));
        CraftBlockData.register(BlockDispenser.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDispenser::new));
        CraftBlockData.register(BlockDoor.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDoor::new));
        CraftBlockData.register(BlockDropper.class, (Function<IBlockData, CraftBlockData>)((Function)CraftDropper::new));
        CraftBlockData.register(BlockEndRod.class, (Function<IBlockData, CraftBlockData>)((Function)CraftEndRod::new));
        CraftBlockData.register(BlockEnderChest.class, (Function<IBlockData, CraftBlockData>)((Function)CraftEnderChest::new));
        CraftBlockData.register(BlockEnderPortalFrame.class, (Function<IBlockData, CraftBlockData>)((Function)CraftEnderPortalFrame::new));
        CraftBlockData.register(BlockFence.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFence::new));
        CraftBlockData.register(BlockFenceGate.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFenceGate::new));
        CraftBlockData.register(BlockFire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFire::new));
        CraftBlockData.register(BlockFloorSign.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFloorSign::new));
        CraftBlockData.register(BlockFluids.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFluids::new));
        CraftBlockData.register(BlockFurnaceFurace.class, (Function<IBlockData, CraftBlockData>)((Function)CraftFurnaceFurace::new));
        CraftBlockData.register(BlockGlazedTerracotta.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGlazedTerracotta::new));
        CraftBlockData.register(BlockGrass.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGrass::new));
        CraftBlockData.register(BlockGrindstone.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGrindstone::new));
        CraftBlockData.register(BlockHay.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHay::new));
        CraftBlockData.register(BlockHopper.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHopper::new));
        CraftBlockData.register(BlockHugeMushroom.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHugeMushroom::new));
        CraftBlockData.register(BlockIceFrost.class, (Function<IBlockData, CraftBlockData>)((Function)CraftIceFrost::new));
        CraftBlockData.register(BlockIronBars.class, (Function<IBlockData, CraftBlockData>)((Function)CraftIronBars::new));
        CraftBlockData.register(BlockJigsaw.class, (Function<IBlockData, CraftBlockData>)((Function)CraftJigsaw::new));
        CraftBlockData.register(BlockJukeBox.class, (Function<IBlockData, CraftBlockData>)((Function)CraftJukeBox::new));
        CraftBlockData.register(BlockKelp.class, (Function<IBlockData, CraftBlockData>)((Function)CraftKelp::new));
        CraftBlockData.register(BlockLadder.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLadder::new));
        CraftBlockData.register(BlockLantern.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLantern::new));
        CraftBlockData.register(BlockLeaves.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLeaves::new));
        CraftBlockData.register(BlockLectern.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLectern::new));
        CraftBlockData.register(BlockLever.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLever::new));
        CraftBlockData.register(BlockLoom.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLoom::new));
        CraftBlockData.register(BlockMinecartDetector.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMinecartDetector::new));
        CraftBlockData.register(BlockMinecartTrack.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMinecartTrack::new));
        CraftBlockData.register(BlockMycel.class, (Function<IBlockData, CraftBlockData>)((Function)CraftMycel::new));
        CraftBlockData.register(BlockNetherWart.class, (Function<IBlockData, CraftBlockData>)((Function)CraftNetherWart::new));
        CraftBlockData.register(BlockNote.class, (Function<IBlockData, CraftBlockData>)((Function)CraftNote::new));
        CraftBlockData.register(BlockObserver.class, (Function<IBlockData, CraftBlockData>)((Function)CraftObserver::new));
        CraftBlockData.register(BlockPortal.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPortal::new));
        CraftBlockData.register(BlockPotatoes.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPotatoes::new));
        CraftBlockData.register(BlockPoweredRail.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPoweredRail::new));
        CraftBlockData.register(BlockPressurePlateBinary.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPressurePlateBinary::new));
        CraftBlockData.register(BlockPressurePlateWeighted.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPressurePlateWeighted::new));
        CraftBlockData.register(BlockPumpkinCarved.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPumpkinCarved::new));
        CraftBlockData.register(BlockRedstoneComparator.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneComparator::new));
        CraftBlockData.register(BlockRedstoneLamp.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneLamp::new));
        CraftBlockData.register(BlockRedstoneOre.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneOre::new));
        CraftBlockData.register(BlockRedstoneTorch.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneTorch::new));
        CraftBlockData.register(BlockRedstoneTorchWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneTorchWall::new));
        CraftBlockData.register(BlockRedstoneWire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRedstoneWire::new));
        CraftBlockData.register(BlockReed.class, (Function<IBlockData, CraftBlockData>)((Function)CraftReed::new));
        CraftBlockData.register(BlockRepeater.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRepeater::new));
        CraftBlockData.register(BlockRespawnAnchor.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRespawnAnchor::new));
        CraftBlockData.register(BlockRotatable.class, (Function<IBlockData, CraftBlockData>)((Function)CraftRotatable::new));
        CraftBlockData.register(BlockSapling.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSapling::new));
        CraftBlockData.register(BlockScaffolding.class, (Function<IBlockData, CraftBlockData>)((Function)CraftScaffolding::new));
        CraftBlockData.register(BlockSeaPickle.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSeaPickle::new));
        CraftBlockData.register(BlockShulkerBox.class, (Function<IBlockData, CraftBlockData>)((Function)CraftShulkerBox::new));
        CraftBlockData.register(BlockSkull.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkull::new));
        CraftBlockData.register(BlockSkullPlayer.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkullPlayer::new));
        CraftBlockData.register(BlockSkullPlayerWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkullPlayerWall::new));
        CraftBlockData.register(BlockSkullWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSkullWall::new));
        CraftBlockData.register(BlockSmoker.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSmoker::new));
        CraftBlockData.register(BlockSnow.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSnow::new));
        CraftBlockData.register(BlockSoil.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSoil::new));
        CraftBlockData.register(BlockStainedGlassPane.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStainedGlassPane::new));
        CraftBlockData.register(BlockStairs.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStairs::new));
        CraftBlockData.register(BlockStem.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStem::new));
        CraftBlockData.register(BlockStemAttached.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStemAttached::new));
        CraftBlockData.register(BlockStepAbstract.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStepAbstract::new));
        CraftBlockData.register(BlockStoneButton.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStoneButton::new));
        CraftBlockData.register(BlockStonecutter.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStonecutter::new));
        CraftBlockData.register(BlockStructure.class, (Function<IBlockData, CraftBlockData>)((Function)CraftStructure::new));
        CraftBlockData.register(BlockSweetBerryBush.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSweetBerryBush::new));
        CraftBlockData.register(BlockTNT.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTNT::new));
        CraftBlockData.register(BlockTallPlant.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTallPlant::new));
        CraftBlockData.register(BlockTallPlantFlower.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTallPlantFlower::new));
        CraftBlockData.register(BlockTarget.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTarget::new));
        CraftBlockData.register(BlockTorchWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTorchWall::new));
        CraftBlockData.register(BlockTrapdoor.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTrapdoor::new));
        CraftBlockData.register(BlockTripwire.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTripwire::new));
        CraftBlockData.register(BlockTripwireHook.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTripwireHook::new));
        CraftBlockData.register(BlockTurtleEgg.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTurtleEgg::new));
        CraftBlockData.register(BlockTwistingVines.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTwistingVines::new));
        CraftBlockData.register(BlockVine.class, (Function<IBlockData, CraftBlockData>)((Function)CraftVine::new));
        CraftBlockData.register(BlockWallSign.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWallSign::new));
        CraftBlockData.register(BlockWeepingVines.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeepingVines::new));
        CraftBlockData.register(BlockWitherSkull.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWitherSkull::new));
        CraftBlockData.register(BlockWitherSkullWall.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWitherSkullWall::new));
        CraftBlockData.register(BlockWoodButton.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWoodButton::new));
        CraftBlockData.register(CandleBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCandle::new));
        CraftBlockData.register(CandleCakeBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCandleCake::new));
        CraftBlockData.register(CaveVinesBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCaveVines::new));
        CraftBlockData.register(CaveVinesPlantBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftCaveVinesPlant::new));
        CraftBlockData.register(GlowLichenBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftGlowLichen::new));
        CraftBlockData.register(HangingRootsBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftHangingRoots::new));
        CraftBlockData.register(InfestedRotatedPillarBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftInfestedRotatedPillar::new));
        CraftBlockData.register(LayeredCauldronBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLayeredCauldron::new));
        CraftBlockData.register(LightBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLight::new));
        CraftBlockData.register(LightningRodBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftLightningRod::new));
        CraftBlockData.register(PointedDripstoneBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPointedDripstone::new));
        CraftBlockData.register(PowderSnowCauldronBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPowderSnowCauldron::new));
        CraftBlockData.register(SculkSensorBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSculkSensor::new));
        CraftBlockData.register(SmallDripleafBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftSmallDripleaf::new));
        CraftBlockData.register(TallSeagrassBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftTallSeagrass::new));
        CraftBlockData.register(WeatheringCopperSlabBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperSlab::new));
        CraftBlockData.register(WeatheringCopperStairBlock.class, (Function<IBlockData, CraftBlockData>)((Function)CraftWeatheringCopperStair::new));
        CraftBlockData.register(BlockPiston.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPiston::new));
        CraftBlockData.register(BlockPistonExtension.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPistonExtension::new));
        CraftBlockData.register(BlockPistonMoving.class, (Function<IBlockData, CraftBlockData>)((Function)CraftPistonMoving::new));
        stringDataCache = new ConcurrentHashMap<String, CraftBlockData>();
        CraftBlockData.reloadCache();
        Block.o.iterator().forEachRemaining(BlockBase.BlockData::createCraftBlockData);
    }
}

