/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block;

import net.minecraft.world.level.block.BlockJukeBox;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Jukebox;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;

public class CraftJukebox
extends CraftBlockEntityState<TileEntityJukeBox>
implements Jukebox {
    public CraftJukebox(World world, TileEntityJukeBox tileEntity) {
        super(world, tileEntity);
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.getType() == Material.JUKEBOX) {
            CraftWorld world = (CraftWorld)this.getWorld();
            Material record = this.getPlaying();
            if (record == Material.AIR) {
                this.getWorldHandle().a(this.getPosition(), (IBlockData)Blocks.cQ.n().a(BlockJukeBox.a, false), 3);
            } else {
                this.getWorldHandle().a(this.getPosition(), (IBlockData)Blocks.cQ.n().a(BlockJukeBox.a, true), 3);
            }
            world.playEffect(this.getLocation(), Effect.RECORD_PLAY, record);
        }
        return result;
    }

    public Material getPlaying() {
        return this.getRecord().getType();
    }

    public void setPlaying(Material record) {
        if (record == null || CraftMagicNumbers.getItem(record) == null) {
            record = Material.AIR;
        }
        this.setRecord(new ItemStack(record));
    }

    public ItemStack getRecord() {
        net.minecraft.world.item.ItemStack record = ((TileEntityJukeBox)this.getSnapshot()).c();
        return CraftItemStack.asBukkitCopy(record);
    }

    public void setRecord(ItemStack record) {
        net.minecraft.world.item.ItemStack nms = CraftItemStack.asNMSCopy(record);
        ((TileEntityJukeBox)this.getSnapshot()).a(nms);
        this.data = nms.b() ? (IBlockData)this.data.a(BlockJukeBox.a, false) : (IBlockData)this.data.a(BlockJukeBox.a, true);
    }

    public boolean isPlaying() {
        return this.getHandle().c(BlockJukeBox.a);
    }

    public void stopPlaying() {
        this.getWorld().playEffect(this.getLocation(), Effect.RECORD_PLAY, (Object)Material.AIR);
    }

    public boolean eject() {
        this.ensureNoWorldGeneration();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (!(tileEntity instanceof TileEntityJukeBox)) {
            return false;
        }
        TileEntityJukeBox jukebox = (TileEntityJukeBox)tileEntity;
        boolean result = !jukebox.c().b();
        CraftWorld world = (CraftWorld)this.getWorld();
        ((BlockJukeBox)Blocks.cQ).a((net.minecraft.world.level.World)world.getHandle(), this.getPosition());
        return result;
    }
}

