/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.block;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.world.ChestLock;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeacon;
import org.bukkit.World;
import org.bukkit.block.Beacon;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CraftBeacon
extends CraftBlockEntityState<TileEntityBeacon>
implements Beacon {
    public CraftBeacon(World world, TileEntityBeacon tileEntity) {
        super(world, tileEntity);
    }

    public Collection<LivingEntity> getEntitiesInRange() {
        this.ensureNoWorldGeneration();
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (tileEntity instanceof TileEntityBeacon) {
            TileEntityBeacon beacon = (TileEntityBeacon)tileEntity;
            List nms = TileEntityBeacon.getHumansInRange(beacon.k(), beacon.p(), beacon.k, beacon);
            ArrayList<LivingEntity> bukkit = new ArrayList<LivingEntity>(nms.size());
            for (EntityHuman human : nms) {
                bukkit.add(human.getBukkitEntity());
            }
            return bukkit;
        }
        return new ArrayList<LivingEntity>();
    }

    public int getTier() {
        return ((TileEntityBeacon)this.getSnapshot()).k;
    }

    public PotionEffect getPrimaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getPrimaryEffect();
    }

    public void setPrimaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).m = effect != null ? MobEffectList.a(effect.getId()) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return ((TileEntityBeacon)this.getSnapshot()).getSecondaryEffect();
    }

    public void setSecondaryEffect(PotionEffectType effect) {
        ((TileEntityBeacon)this.getSnapshot()).q = effect != null ? MobEffectList.a(effect.getId()) : null;
    }

    public Component customName() {
        TileEntityBeacon be = (TileEntityBeacon)this.getSnapshot();
        return be.r != null ? PaperAdventure.asAdventure(be.r) : null;
    }

    public void customName(Component customName) {
        ((TileEntityBeacon)this.getSnapshot()).a(customName != null ? PaperAdventure.asVanilla(customName) : null);
    }

    public String getCustomName() {
        TileEntityBeacon beacon = (TileEntityBeacon)this.getSnapshot();
        return beacon.r != null ? CraftChatMessage.fromComponent(beacon.r) : null;
    }

    public void setCustomName(String name) {
        ((TileEntityBeacon)this.getSnapshot()).a(CraftChatMessage.fromStringOrNull(name));
    }

    public boolean isLocked() {
        return !((TileEntityBeacon)this.getSnapshot()).s.c.isEmpty();
    }

    public String getLock() {
        return ((TileEntityBeacon)this.getSnapshot()).s.c;
    }

    public void setLock(String key) {
        ((TileEntityBeacon)this.getSnapshot()).s = key == null ? ChestLock.a : new ChestLock(key);
    }

    public double getEffectRange() {
        return ((TileEntityBeacon)this.getSnapshot()).getEffectRange();
    }

    public void setEffectRange(double range) {
        ((TileEntityBeacon)this.getSnapshot()).setEffectRange(range);
    }

    public void resetEffectRange() {
        ((TileEntityBeacon)this.getSnapshot()).resetEffectRange();
    }
}

