/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.attribute;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.IRegistry;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import org.bukkit.Registry;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.craftbukkit.v1_18_R2.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;

public class CraftAttributeMap
implements Attributable {
    private final AttributeMapBase handle;
    private static final ImmutableMap<String, String> legacyNMS = ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"generic.max_health").put((Object)"Max Health", (Object)"generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"horse.jump_strength").put((Object)"Jump Strength", (Object)"horse.jump_strength").put((Object)"generic.followRange", (Object)"generic.follow_range").put((Object)"Follow Range", (Object)"generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"generic.movement_speed").put((Object)"Movement Speed", (Object)"generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"generic.flying_speed").put((Object)"Flying Speed", (Object)"generic.flying_speed").put((Object)"generic.attackDamage", (Object)"generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"generic.attack_speed").put((Object)"generic.armorToughness", (Object)"generic.armor_toughness").build();

    public static String convertIfNeeded(String nms) {
        if (nms == null) {
            return null;
        }
        if (!(nms = (String)legacyNMS.getOrDefault((Object)nms, (Object)nms)).toLowerCase().equals(nms) || nms.indexOf(32) != -1) {
            return null;
        }
        return nms;
    }

    public CraftAttributeMap(AttributeMapBase handle) {
        this.handle = handle;
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"attribute");
        AttributeModifiable nms = this.handle.a(CraftAttributeMap.toMinecraft(attribute));
        return nms == null ? null : new CraftAttributeInstance(nms, attribute);
    }

    public void registerAttribute(Attribute attribute) {
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"attribute");
        this.handle.registerAttribute(CraftAttributeMap.toMinecraft(attribute));
    }

    public static AttributeBase toMinecraft(Attribute attribute) {
        return IRegistry.aj.a(CraftNamespacedKey.toMinecraft(attribute.getKey()));
    }

    public static Attribute fromMinecraft(String nms) {
        return (Attribute)Registry.ATTRIBUTE.get(CraftNamespacedKey.fromString(nms));
    }
}

