/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;

public class CraftWorldBorder
implements WorldBorder {
    private final World world;
    private final net.minecraft.world.level.border.WorldBorder handle;

    public CraftWorldBorder(CraftWorld world) {
        this.world = world;
        this.handle = world.getHandle().p_();
    }

    public void reset() {
        this.setSize(6.0E7);
        this.setDamageAmount(0.2);
        this.setDamageBuffer(5.0);
        this.setWarningDistance(5);
        this.setWarningTime(15);
        this.setCenter(0.0, 0.0);
    }

    public double getSize() {
        return this.handle.i();
    }

    public void setSize(double newSize) {
        this.setSize(newSize, 0L);
    }

    public void setSize(double newSize, long time) {
        newSize = Math.min(6.0E7, Math.max(1.0, newSize));
        if ((time = Math.min(9223372036854775L, Math.max(0L, time))) > 0L) {
            this.handle.a(this.handle.i(), newSize, time * 1000L);
        } else {
            this.handle.a(newSize);
        }
    }

    public Location getCenter() {
        double x2 = this.handle.a();
        double z2 = this.handle.b();
        return new Location(this.world, x2, 0.0, z2);
    }

    public void setCenter(double x2, double z2) {
        x2 = Math.min(3.0E7, Math.max(-3.0E7, x2));
        z2 = Math.min(3.0E7, Math.max(-3.0E7, z2));
        this.handle.c(x2, z2);
    }

    public void setCenter(Location location) {
        this.setCenter(location.getX(), location.getZ());
    }

    public double getDamageBuffer() {
        return this.handle.n();
    }

    public void setDamageBuffer(double blocks) {
        this.handle.b(blocks);
    }

    public double getDamageAmount() {
        return this.handle.o();
    }

    public void setDamageAmount(double damage) {
        this.handle.c(damage);
    }

    public int getWarningTime() {
        return this.handle.q();
    }

    public void setWarningTime(int time) {
        this.handle.b(time);
    }

    public int getWarningDistance() {
        return this.handle.r();
    }

    public void setWarningDistance(int distance) {
        this.handle.c(distance);
    }

    public boolean isInside(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        return location.getWorld().equals(this.world) && this.handle.a(new BlockPosition(location.getX(), location.getY(), location.getZ()));
    }
}

