/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.JsonListEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.CraftProfileBanEntry;

public class CraftProfileBanList
implements BanList {
    private final GameProfileBanList list;

    public CraftProfileBanList(GameProfileBanList list) {
        this.list = list;
    }

    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        GameProfileBanEntry entry = (GameProfileBanEntry)this.list.b(profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        GameProfileBanEntry entry = new GameProfileBanEntry(profile, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.a(entry);
        try {
            this.list.e();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-players.json, {0}", ex.getMessage());
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonListEntry entry : this.list.getValues()) {
            GameProfile profile = (GameProfile)entry.g();
            builder.add((Object)new CraftProfileBanEntry(profile, (GameProfileBanEntry)entry, this.list));
        }
        return builder.build();
    }

    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return false;
        }
        return this.list.a(profile);
    }

    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        this.list.c(profile);
    }

    private GameProfile getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return (uuid != null ? MinecraftServer.getServer().ao().a(uuid) : MinecraftServer.getServer().ao().a(target)).orElse(null);
    }
}

