/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;

public class CraftLootTable
implements LootTable {
    private final net.minecraft.world.level.storage.loot.LootTable handle;
    private final NamespacedKey key;

    public CraftLootTable(NamespacedKey key, net.minecraft.world.level.storage.loot.LootTable handle) {
        this.handle = handle;
        this.key = key;
    }

    public net.minecraft.world.level.storage.loot.LootTable getHandle() {
        return this.handle;
    }

    public Collection<ItemStack> populateLoot(Random random, LootContext context) {
        LootTableInfo nmsContext = this.convertContext(context, random);
        List<net.minecraft.world.item.ItemStack> nmsItems = this.handle.a(nmsContext);
        ArrayList<ItemStack> bukkit = new ArrayList<ItemStack>(nmsItems.size());
        for (net.minecraft.world.item.ItemStack item : nmsItems) {
            if (item.b()) continue;
            bukkit.add(CraftItemStack.asBukkitCopy(item));
        }
        return bukkit;
    }

    public void fillInventory(Inventory inventory, Random random, LootContext context) {
        LootTableInfo nmsContext = this.convertContext(context, random);
        CraftInventory craftInventory = (CraftInventory)inventory;
        IInventory handle = craftInventory.getInventory();
        this.getHandle().a(handle, nmsContext);
    }

    public NamespacedKey getKey() {
        return this.key;
    }

    private LootTableInfo convertContext(LootContext context, Random random) {
        Location loc = context.getLocation();
        WorldServer handle = ((CraftWorld)loc.getWorld()).getHandle();
        LootTableInfo.Builder builder = new LootTableInfo.Builder(handle);
        if (random != null) {
            builder = builder.a(random);
        }
        this.setMaybe(builder, LootContextParameters.f, new Vec3D(loc.getX(), loc.getY(), loc.getZ()));
        if (this.getHandle() != net.minecraft.world.level.storage.loot.LootTable.a) {
            if (context.getLootedEntity() != null) {
                net.minecraft.world.entity.Entity nmsLootedEntity = ((CraftEntity)context.getLootedEntity()).getHandle();
                this.setMaybe(builder, LootContextParameters.a, nmsLootedEntity);
                this.setMaybe(builder, LootContextParameters.c, DamageSource.n);
                this.setMaybe(builder, LootContextParameters.f, nmsLootedEntity.cV());
            }
            if (context.getKiller() != null) {
                EntityHuman nmsKiller = ((CraftHumanEntity)context.getKiller()).getHandle();
                this.setMaybe(builder, LootContextParameters.d, nmsKiller);
                this.setMaybe(builder, LootContextParameters.c, DamageSource.a(nmsKiller));
                this.setMaybe(builder, LootContextParameters.b, nmsKiller);
                this.setMaybe(builder, LootContextParameters.i, nmsKiller.eO());
            }
            if (context.getLootingModifier() != -1) {
                this.setMaybe(builder, LootContextParameters.LOOTING_MOD, context.getLootingModifier());
            }
        }
        LootContextParameterSet.Builder nmsBuilder = new LootContextParameterSet.Builder();
        for (LootContextParameter<?> param : this.getHandle().a().a()) {
            nmsBuilder.a(param);
        }
        for (LootContextParameter<?> param : this.getHandle().a().b()) {
            if (this.getHandle().a().a().contains(param)) continue;
            nmsBuilder.b(param);
        }
        nmsBuilder.b(LootContextParameters.LOOTING_MOD);
        return builder.a(nmsBuilder.a());
    }

    private <T> void setMaybe(LootTableInfo.Builder builder, LootContextParameter<T> param, T value) {
        if (this.getHandle().a().a().contains(param) || this.getHandle().a().b().contains(param)) {
            builder.a(param, value);
        }
    }

    public static LootContext convertContext(LootTableInfo info) {
        CraftEntity killer;
        Vec3D position = info.c(LootContextParameters.f);
        if (position == null) {
            position = info.c(LootContextParameters.a).cV();
        }
        Location location = new Location((World)info.c().getWorld(), position.a(), position.b(), position.c());
        LootContext.Builder contextBuilder = new LootContext.Builder(location);
        if (info.a(LootContextParameters.d) && (killer = info.c(LootContextParameters.d).getBukkitEntity()) instanceof CraftHumanEntity) {
            contextBuilder.killer((HumanEntity)((CraftHumanEntity)killer));
        }
        if (info.a(LootContextParameters.a)) {
            contextBuilder.lootedEntity((Entity)info.c(LootContextParameters.a).getBukkitEntity());
        }
        if (info.a(LootContextParameters.LOOTING_MOD)) {
            contextBuilder.lootingModifier(info.c(LootContextParameters.LOOTING_MOD).intValue());
        }
        contextBuilder.luck(info.b());
        return contextBuilder.build();
    }

    public String toString() {
        return this.getKey().toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LootTable)) {
            return false;
        }
        LootTable table = (LootTable)obj;
        return table.getKey().equals((Object)this.getKey());
    }
}

