/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private WeakReference<net.minecraft.world.level.chunk.Chunk> weakChunk;
    private final WorldServer worldServer;
    private final int x;
    private final int z;
    private static final DataPaletteBlock<IBlockData> emptyBlockIDs = new DataPaletteBlock<IBlockData>(Block.o, Blocks.a.n(), DataPaletteBlock.e.d, null);
    private static final byte[] emptyLight = new byte[2048];

    public CraftChunk(net.minecraft.world.level.chunk.Chunk chunk) {
        this.weakChunk = new WeakReference<net.minecraft.world.level.chunk.Chunk>(chunk);
        this.worldServer = this.getHandle().q;
        this.x = this.getHandle().f().c;
        this.z = this.getHandle().f().d;
    }

    public CraftChunk(WorldServer worldServer, int x2, int z2) {
        this.weakChunk = new WeakReference<Object>(null);
        this.worldServer = worldServer;
        this.x = x2;
        this.z = z2;
    }

    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public net.minecraft.world.level.chunk.Chunk getHandle() {
        net.minecraft.world.level.chunk.Chunk c2 = (net.minecraft.world.level.chunk.Chunk)this.weakChunk.get();
        if (c2 == null) {
            c2 = this.worldServer.d(this.x, this.z);
            this.weakChunk = new WeakReference<net.minecraft.world.level.chunk.Chunk>(c2);
        }
        return c2;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    public org.bukkit.block.Block getBlock(int x2, int y2, int z2) {
        CraftChunk.validateChunkCoordinates(this.getHandle().u_(), this.getHandle().ag(), x2, y2, z2);
        return new CraftBlock(this.worldServer, new BlockPosition(this.x << 4 | x2, y2, this.z << 4 | z2));
    }

    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().O.a(ChunkCoordIntPair.a(this.x, this.z));
    }

    public Entity[] getEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        return this.getCraftWorld().getHandle().getChunkEntities(this.x, this.z);
    }

    public BlockState[] getTileEntities() {
        return this.getTileEntities(true);
    }

    public BlockState[] getTileEntities(boolean useSnapshot) {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        net.minecraft.world.level.chunk.Chunk chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.i.size()];
        for (Object obj : chunk.i.keySet().toArray()) {
            if (!(obj instanceof BlockPosition)) continue;
            BlockPosition position = (BlockPosition)obj;
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.u(), position.v(), position.w()).getState(useSnapshot);
        }
        return entities;
    }

    public Collection<BlockState> getTileEntities(Predicate<org.bukkit.block.Block> blockPredicate, boolean useSnapshot) {
        Preconditions.checkNotNull(blockPredicate, (Object)"blockPredicate");
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        net.minecraft.world.level.chunk.Chunk chunk = this.getHandle();
        ArrayList<BlockState> entities = new ArrayList<BlockState>();
        for (BlockPosition position : chunk.i.keySet()) {
            org.bukkit.block.Block block = this.worldServer.getWorld().getBlockAt(position.u(), position.v(), position.w());
            if (!blockPredicate.test(block)) continue;
            entities.add(block.getState(useSnapshot));
        }
        return entities;
    }

    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded((Chunk)this);
    }

    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    public boolean isSlimeChunk() {
        return this.worldServer.paperConfig.allChunksAreSlimeChunks || SeededRandom.a(this.getX(), this.getZ(), this.getWorld().getSeed(), this.worldServer.spigotConfig.slimeSeed).nextInt(10) == 0;
    }

    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    public long getInhabitedTime() {
        return this.getHandle().u();
    }

    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle().b(ticks);
    }

    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (ChunkSection section : this.getHandle().d()) {
            if (section == null || !section.i().a((Predicate<IBlockData>)nms)) continue;
            return true;
        }
        return false;
    }

    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        net.minecraft.world.level.chunk.Chunk chunk = this.getHandle();
        ChunkSection[] cs = chunk.d();
        DataPaletteBlock[] sectionBlockIDs = new DataPaletteBlock[cs.length];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        DataPaletteBlock[] biome = includeBiome || includeBiomeTempRain ? new DataPaletteBlock[cs.length] : null;
        IRegistry<BiomeBase> iregistry = this.worldServer.s().d(IRegistry.aP);
        for (int i2 = 0; i2 < cs.length; ++i2) {
            sectionEmpty[i2] = cs[i2].c();
            sectionBlockIDs[i2] = !sectionEmpty[i2] ? cs[i2].i().d() : emptyBlockIDs;
            LightEngine lightengine = chunk.q.l_();
            NibbleArray skyLightArray = lightengine.a(EnumSkyBlock.a).a(SectionPosition.a(this.x, i2, this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i2] = emptyLight;
            } else {
                sectionSkyLights[i2] = new byte[2048];
                System.arraycopy(skyLightArray.a(), 0, sectionSkyLights[i2], 0, 2048);
            }
            NibbleArray emitLightArray = lightengine.a(EnumSkyBlock.b).a(SectionPosition.a(this.x, i2, this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i2] = emptyLight;
            } else {
                sectionEmitLights[i2] = new byte[2048];
                System.arraycopy(emitLightArray.a(), 0, sectionEmitLights[i2], 0, 2048);
            }
            if (biome == null) continue;
            biome[i2] = cs[i2].j().d();
        }
        HeightMap hmap = null;
        if (includeMaxBlockY) {
            hmap = new HeightMap(chunk, HeightMap.Type.e);
            hmap.a(chunk, HeightMap.Type.e, chunk.g.get(HeightMap.Type.e).a());
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), chunk.u_(), chunk.ag(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, iregistry, biome);
    }

    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().persistentDataContainer;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x2, int z2, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        IChunkAccess actual = world.getHandle().a(x2, z2, ChunkStatus.c);
        int hSection = actual.ah();
        DataPaletteBlock[] blockIDs = new DataPaletteBlock[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        IRegistry<BiomeBase> iregistry = world.getHandle().s().d(IRegistry.aP);
        DataPaletteBlock[] biome = includeBiome || includeBiomeTempRain ? new DataPaletteBlock[hSection] : null;
        for (int i2 = 0; i2 < hSection; ++i2) {
            blockIDs[i2] = emptyBlockIDs;
            skyLight[i2] = emptyLight;
            emitLight[i2] = emptyLight;
            empty[i2] = true;
            if (biome == null) continue;
            biome[i2] = new DataPaletteBlock<Holder<BiomeBase>>(iregistry.r(), iregistry.g(Biomes.b), DataPaletteBlock.e.e, null);
        }
        return new CraftChunkSnapshot(x2, z2, world.getMinHeight(), world.getMaxHeight(), world.getName(), world.getFullTime(), blockIDs, skyLight, emitLight, empty, new HeightMap(actual, HeightMap.Type.e), iregistry, biome);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x2, int y2, int z2) {
        Preconditions.checkArgument((0 <= x2 && x2 <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x2);
        Preconditions.checkArgument((minY <= y2 && y2 <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y2);
        Preconditions.checkArgument((0 <= z2 && z2 <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z2);
    }

    static {
        Arrays.fill(emptyLight, (byte)-1);
    }
}

