/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import it.unimi.dsi.fastutil.Hash;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.TickListPriority;

public final class TickListChunk<T>
extends Record {
    private final T b;
    private final BlockPosition c;
    private final int d;
    private final TickListPriority e;
    private static final String f = "i";
    private static final String g = "x";
    private static final String h = "y";
    private static final String i = "z";
    private static final String j = "t";
    private static final String k = "p";
    public static final Hash.Strategy<TickListChunk<?>> a = new Hash.Strategy<TickListChunk<?>>(){

        @Override
        public int a(TickListChunk<?> savedTick) {
            return 31 * savedTick.b().hashCode() + savedTick.a().hashCode();
        }

        @Override
        public boolean a(@Nullable TickListChunk<?> savedTick, @Nullable TickListChunk<?> savedTick2) {
            if (savedTick == savedTick2) {
                return true;
            }
            if (savedTick == null || savedTick2 == null) {
                return false;
            }
            return savedTick.a() == savedTick2.a() && savedTick.b().equals(savedTick2.b());
        }

        public /* synthetic */ boolean equals(@Nullable Object object, @Nullable Object object2) {
            return this.a((TickListChunk)object, (TickListChunk)object2);
        }

        public /* synthetic */ int hashCode(Object object) {
            return this.a((TickListChunk)object);
        }
    };

    public TickListChunk(T object, BlockPosition blockPos, int i2, TickListPriority tickPriority) {
        this.b = object;
        this.c = blockPos;
        this.d = i2;
        this.e = tickPriority;
    }

    public static <T> void a(NBTTagList tickList, Function<String, Optional<T>> nameToTypeFunction, ChunkCoordIntPair pos, Consumer<TickListChunk<T>> tickConsumer) {
        long l2 = pos.a();
        for (int i2 = 0; i2 < tickList.size(); ++i2) {
            NBTTagCompound compoundTag = tickList.a(i2);
            TickListChunk.a(compoundTag, nameToTypeFunction).ifPresent(tick -> {
                if (ChunkCoordIntPair.a(tick.b()) == l2) {
                    tickConsumer.accept((TickListChunk)tick);
                }
            });
        }
    }

    public static <T> Optional<TickListChunk<T>> a(NBTTagCompound nbt, Function<String, Optional<T>> nameToType) {
        return nameToType.apply(nbt.l(f)).map(type -> {
            BlockPosition blockPos = new BlockPosition(nbt.h(g), nbt.h(h), nbt.h(i));
            return new TickListChunk<Object>(type, blockPos, nbt.h(j), TickListPriority.a(nbt.h(k)));
        });
    }

    private static NBTTagCompound a(String type, BlockPosition pos, int delay, TickListPriority priority) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a(f, type);
        compoundTag.a(g, pos.u());
        compoundTag.a(h, pos.v());
        compoundTag.a(i, pos.w());
        compoundTag.a(j, delay);
        compoundTag.a(k, priority.a());
        return compoundTag;
    }

    public static <T> NBTTagCompound a(NextTickListEntry<T> orderedTick, Function<T, String> typeToNameFunction, long delay) {
        return TickListChunk.a(typeToNameFunction.apply(orderedTick.a()), orderedTick.b(), (int)(orderedTick.c() - delay), orderedTick.d());
    }

    public NBTTagCompound a(Function<T, String> typeToNameFunction) {
        return TickListChunk.a(typeToNameFunction.apply(this.b), this.c, this.d, this.e);
    }

    public NextTickListEntry<T> a(long time, long subTickOrder) {
        return new NextTickListEntry<T>(this.b, this.c, time + (long)this.d, this.e, subTickOrder);
    }

    public static <T> TickListChunk<T> a(T type, BlockPosition pos) {
        return new TickListChunk<T>(type, pos, 0, TickListPriority.d);
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TickListChunk.class, "type;pos;delay;priority", "b", "c", "d", "e"}, this, object);
    }

    public T a() {
        return this.b;
    }

    public BlockPosition b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public TickListPriority d() {
        return this.e;
    }
}

