/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.ticks;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.ticks.NextTickListEntry;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraft.world.ticks.TickListChunk;

public class LevelChunkTicks<T>
implements SerializableTickContainer<T>,
TickContainerAccess<T> {
    private final Queue<NextTickListEntry<T>> a = new PriorityQueue(NextTickListEntry.a);
    @Nullable
    private List<TickListChunk<T>> b;
    private final Set<NextTickListEntry<?>> c = new ObjectOpenCustomHashSet(NextTickListEntry.c);
    @Nullable
    private BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> d;

    public LevelChunkTicks() {
    }

    public LevelChunkTicks(List<TickListChunk<T>> ticks) {
        this.b = ticks;
        for (TickListChunk<T> savedTick : ticks) {
            this.c.add(NextTickListEntry.a(savedTick.a(), savedTick.b()));
        }
    }

    public void a(@Nullable BiConsumer<LevelChunkTicks<T>, NextTickListEntry<T>> tickConsumer) {
        this.d = tickConsumer;
    }

    @Nullable
    public NextTickListEntry<T> b() {
        return this.a.peek();
    }

    @Nullable
    public NextTickListEntry<T> c() {
        NextTickListEntry<T> scheduledTick = this.a.poll();
        if (scheduledTick != null) {
            this.c.remove(scheduledTick);
        }
        return scheduledTick;
    }

    @Override
    @Override
    public void a(NextTickListEntry<T> orderedTick) {
        if (this.c.add(orderedTick)) {
            this.b(orderedTick);
        }
    }

    private void b(NextTickListEntry<T> orderedTick) {
        this.a.add(orderedTick);
        if (this.d != null) {
            this.d.accept(this, orderedTick);
        }
    }

    @Override
    @Override
    public boolean a(BlockPosition pos, T type) {
        return this.c.contains(NextTickListEntry.a(type, pos));
    }

    @Override
    public void a(Predicate<NextTickListEntry<T>> predicate) {
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            NextTickListEntry scheduledTick = (NextTickListEntry)iterator.next();
            if (!predicate.test(scheduledTick)) continue;
            iterator.remove();
            this.c.remove(scheduledTick);
        }
    }

    public Stream<NextTickListEntry<T>> d() {
        return this.a.stream();
    }

    @Override
    @Override
    public int a() {
        return this.a.size() + (this.b != null ? this.b.size() : 0);
    }

    @Override
    public NBTTagList a(long l2, Function<T, String> function) {
        NBTTagList listTag = new NBTTagList();
        if (this.b != null) {
            for (TickListChunk<Object> tickListChunk : this.b) {
                listTag.add(tickListChunk.a(function));
            }
        }
        for (NextTickListEntry nextTickListEntry : this.a) {
            listTag.add(TickListChunk.a(nextTickListEntry, function, l2));
        }
        return listTag;
    }

    public void a(long time) {
        if (this.b != null) {
            int i2 = -this.b.size();
            for (TickListChunk<T> savedTick : this.b) {
                this.b(savedTick.a(time, i2++));
            }
        }
        this.b = null;
    }

    public static <T> LevelChunkTicks<T> a(NBTTagList tickQueue, Function<String, Optional<T>> nameToTypeFunction, ChunkCoordIntPair pos) {
        ImmutableList.Builder builder = ImmutableList.builder();
        TickListChunk.a(tickQueue, nameToTypeFunction, pos, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new LevelChunkTicks<T>(builder.build());
    }

    @Override
    public /* synthetic */ NBTBase b(long time, Function typeToNameFunction) {
        return this.a(time, typeToNameFunction);
    }
}

