/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class Scoreboard {
    private static final Logger g = LogUtils.getLogger();
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    public static final int d = 3;
    public static final int e = 18;
    public static final int f = 19;
    private final Map<String, ScoreboardObjective> h = Maps.newHashMap();
    private final Map<IScoreboardCriteria, List<ScoreboardObjective>> i = Maps.newHashMap();
    private final Map<String, Map<ScoreboardObjective, ScoreboardScore>> j = Maps.newHashMap();
    private final ScoreboardObjective[] k = new ScoreboardObjective[19];
    private final Map<String, ScoreboardTeam> l = Maps.newHashMap();
    private final Map<String, ScoreboardTeam> m = Maps.newHashMap();
    @Nullable
    private static String[] n;

    public boolean b(String name) {
        return this.h.containsKey(name);
    }

    public ScoreboardObjective c(String name) {
        return this.h.get(name);
    }

    @Nullable
    public ScoreboardObjective d(@Nullable String name) {
        return this.h.get(name);
    }

    public ScoreboardObjective a(String name, IScoreboardCriteria criterion2, IChatBaseComponent displayName, IScoreboardCriteria.EnumScoreboardHealthDisplay renderType) {
        if (this.h.containsKey(name)) {
            throw new IllegalArgumentException("An objective with the name '" + name + "' already exists!");
        }
        ScoreboardObjective objective = new ScoreboardObjective(this, name, criterion2, displayName, renderType);
        this.i.computeIfAbsent(criterion2, criterion -> Lists.newArrayList()).add(objective);
        this.h.put(name, objective);
        this.a(objective);
        return objective;
    }

    public final void a(IScoreboardCriteria criterion, String player, Consumer<ScoreboardScore> action) {
        this.i.getOrDefault(criterion, Collections.emptyList()).forEach(objective -> action.accept(this.c(player, (ScoreboardObjective)objective)));
    }

    public boolean b(String playerName, ScoreboardObjective objective) {
        Map<ScoreboardObjective, ScoreboardScore> map = this.j.get(playerName);
        if (map == null) {
            return false;
        }
        ScoreboardScore score = map.get(objective);
        return score != null;
    }

    public ScoreboardScore c(String playerName, ScoreboardObjective objective2) {
        Map map = this.j.computeIfAbsent(playerName, string -> Maps.newHashMap());
        return map.computeIfAbsent(objective2, objective -> {
            ScoreboardScore score = new ScoreboardScore(this, (ScoreboardObjective)objective, playerName);
            score.b(0);
            return score;
        });
    }

    public Collection<ScoreboardScore> i(ScoreboardObjective objective) {
        ArrayList list = Lists.newArrayList();
        for (Map<ScoreboardObjective, ScoreboardScore> map : this.j.values()) {
            ScoreboardScore score = map.get(objective);
            if (score == null) continue;
            list.add(score);
        }
        list.sort(ScoreboardScore.a);
        return list;
    }

    public Collection<ScoreboardObjective> c() {
        return this.h.values();
    }

    public Collection<String> d() {
        return this.h.keySet();
    }

    public Collection<String> e() {
        return Lists.newArrayList(this.j.keySet());
    }

    public void d(String playerName, @Nullable ScoreboardObjective objective) {
        if (objective == null) {
            Map<ScoreboardObjective, ScoreboardScore> map = this.j.remove(playerName);
            if (map != null) {
                this.a(playerName);
            }
        } else {
            Map<ScoreboardObjective, ScoreboardScore> map2 = this.j.get(playerName);
            if (map2 != null) {
                ScoreboardScore score = map2.remove(objective);
                if (map2.size() < 1) {
                    Map<ScoreboardObjective, ScoreboardScore> map3 = this.j.remove(playerName);
                    if (map3 != null) {
                        this.a(playerName);
                    }
                } else if (score != null) {
                    this.a(playerName, objective);
                }
            }
        }
    }

    public Map<ScoreboardObjective, ScoreboardScore> e(String playerName) {
        HashMap map = this.j.get(playerName);
        if (map == null) {
            map = Maps.newHashMap();
        }
        return map;
    }

    public void j(ScoreboardObjective objective) {
        this.h.remove(objective.b());
        for (int i2 = 0; i2 < 19; ++i2) {
            if (this.a(i2) != objective) continue;
            this.a(i2, null);
        }
        List<ScoreboardObjective> list = this.i.get(objective.c());
        if (list != null) {
            list.remove(objective);
        }
        for (Map<ScoreboardObjective, ScoreboardScore> map : this.j.values()) {
            map.remove(objective);
        }
        this.c(objective);
    }

    public void a(int slot, @Nullable ScoreboardObjective objective) {
        this.k[slot] = objective;
    }

    @Nullable
    public ScoreboardObjective a(int slot) {
        return this.k[slot];
    }

    @Nullable
    public ScoreboardTeam f(String name) {
        return this.l.get(name);
    }

    public ScoreboardTeam g(String name) {
        ScoreboardTeam playerTeam = this.f(name);
        if (playerTeam != null) {
            g.warn("Requested creation of existing team '{}'", (Object)name);
            return playerTeam;
        }
        playerTeam = new ScoreboardTeam(this, name);
        this.l.put(name, playerTeam);
        this.a(playerTeam);
        return playerTeam;
    }

    public void d(ScoreboardTeam team) {
        this.l.remove(team.b());
        for (String string : team.g()) {
            this.m.remove(string);
        }
        this.c(team);
    }

    public boolean a(String playerName, ScoreboardTeam team) {
        if (this.i(playerName) != null) {
            this.h(playerName);
        }
        this.m.put(playerName, team);
        return team.g().add(playerName);
    }

    public boolean h(String playerName) {
        ScoreboardTeam playerTeam = this.i(playerName);
        if (playerTeam != null) {
            this.b(playerName, playerTeam);
            return true;
        }
        return false;
    }

    public void b(String playerName, ScoreboardTeam team) {
        if (this.i(playerName) != team) {
            throw new IllegalStateException("Player is either on another team or not on any team. Cannot remove from team '" + team.b() + "'.");
        }
        this.m.remove(playerName);
        team.g().remove(playerName);
    }

    public Collection<String> f() {
        return this.l.keySet();
    }

    public Collection<ScoreboardTeam> g() {
        return this.l.values();
    }

    @Nullable
    public ScoreboardTeam i(String playerName) {
        return this.m.get(playerName);
    }

    public void a(ScoreboardObjective objective) {
    }

    public void b(ScoreboardObjective objective) {
    }

    public void c(ScoreboardObjective objective) {
    }

    public void a(ScoreboardScore score) {
    }

    public void a(String playerName) {
    }

    public void a(String playerName, ScoreboardObjective objective) {
    }

    public void a(ScoreboardTeam team) {
    }

    public void b(ScoreboardTeam team) {
    }

    public void c(ScoreboardTeam team) {
    }

    public static String b(int slotId) {
        EnumChatFormat chatFormatting;
        switch (slotId) {
            case 0: {
                return "list";
            }
            case 1: {
                return "sidebar";
            }
            case 2: {
                return "belowName";
            }
        }
        if (slotId >= 3 && slotId <= 18 && (chatFormatting = EnumChatFormat.a(slotId - 3)) != null && chatFormatting != EnumChatFormat.v) {
            return "sidebar.team." + chatFormatting.f();
        }
        return null;
    }

    public static int j(String slotName) {
        String string;
        EnumChatFormat chatFormatting;
        if ("list".equalsIgnoreCase(slotName)) {
            return 0;
        }
        if ("sidebar".equalsIgnoreCase(slotName)) {
            return 1;
        }
        if ("belowName".equalsIgnoreCase(slotName)) {
            return 2;
        }
        if (slotName.startsWith("sidebar.team.") && (chatFormatting = EnumChatFormat.b(string = slotName.substring("sidebar.team.".length()))) != null && chatFormatting.b() >= 0) {
            return chatFormatting.b() + 3;
        }
        return -1;
    }

    public static String[] h() {
        if (n == null) {
            n = new String[19];
            for (int i2 = 0; i2 < 19; ++i2) {
                Scoreboard.n[i2] = Scoreboard.b(i2);
            }
        }
        return n;
    }

    public void a(Entity entity) {
        if (entity == null || entity instanceof EntityHuman || entity.bl()) {
            return;
        }
        String string = entity.cn();
        this.d(string, null);
        this.h(string);
    }

    protected NBTTagList i() {
        NBTTagList listTag = new NBTTagList();
        this.j.values().stream().map(Map::values).forEach(scores -> scores.stream().filter(score -> score.d() != null).forEach(score -> {
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Name", score.e());
            compoundTag.a("Objective", score.d().b());
            compoundTag.a("Score", score.b());
            compoundTag.a("Locked", score.g());
            listTag.add(compoundTag);
        }));
        return listTag;
    }

    protected void a(NBTTagList list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            NBTTagCompound compoundTag = list.a(i2);
            ScoreboardObjective objective = this.c(compoundTag.l("Objective"));
            String string = compoundTag.l("Name");
            ScoreboardScore score = this.c(string, objective);
            score.b(compoundTag.h("Score"));
            if (!compoundTag.e("Locked")) continue;
            score.a(compoundTag.q("Locked"));
        }
    }
}

