/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionTableBonus
implements LootItemCondition {
    final Enchantment a;
    final float[] b;

    LootItemConditionTableBonus(Enchantment enchantment, float[] chances) {
        this.a = enchantment;
        this.b = chances;
    }

    @Override
    @Override
    public LootItemConditionType a() {
        return LootItemConditions.j;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return ImmutableSet.of(LootContextParameters.i);
    }

    @Override
    public boolean a(LootTableInfo lootContext) {
        ItemStack itemStack = lootContext.c(LootContextParameters.i);
        int i2 = itemStack != null ? EnchantmentManager.a(this.a, itemStack) : 0;
        float f2 = this.b[Math.min(i2, this.b.length - 1)];
        return lootContext.a().nextFloat() < f2;
    }

    public static LootItemCondition.a a(Enchantment enchantment, float ... chances) {
        return () -> new LootItemConditionTableBonus(enchantment, chances);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }

    public static class a
    implements LootSerializer<LootItemConditionTableBonus> {
        @Override
        @Override
        public void a(JsonObject json, LootItemConditionTableBonus object, JsonSerializationContext context) {
            json.addProperty("enchantment", IRegistry.V.b(object.a).toString());
            json.add("chances", context.serialize((Object)object.b));
        }

        @Override
        public LootItemConditionTableBonus b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.h(jsonObject, "enchantment"));
            Enchantment enchantment = IRegistry.V.b(resourceLocation).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + resourceLocation));
            float[] fs = ChatDeserializer.a(jsonObject, "chances", jsonDeserializationContext, float[].class);
            return new LootItemConditionTableBonus(enchantment, fs);
        }

        @Override
        public /* synthetic */ Object a(JsonObject json, JsonDeserializationContext context) {
            return this.b(json, context);
        }
    }
}

