/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootItemConditionBlockStateProperty
implements LootItemCondition {
    final Block a;
    final CriterionTriggerProperties b;

    LootItemConditionBlockStateProperty(Block block, CriterionTriggerProperties properties) {
        this.a = block;
        this.b = properties;
    }

    @Override
    @Override
    public LootItemConditionType a() {
        return LootItemConditions.h;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return ImmutableSet.of(LootContextParameters.g);
    }

    @Override
    public boolean a(LootTableInfo lootContext) {
        IBlockData blockState = lootContext.c(LootContextParameters.g);
        return blockState != null && blockState.a(this.a) && this.b.a(blockState);
    }

    public static a a(Block block) {
        return new a(block);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.a((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final Block a;
        private CriterionTriggerProperties b = CriterionTriggerProperties.a;

        public a(Block block) {
            this.a = block;
        }

        public a a(CriterionTriggerProperties.a builder) {
            this.b = builder.b();
            return this;
        }

        @Override
        @Override
        public LootItemCondition build() {
            return new LootItemConditionBlockStateProperty(this.a, this.b);
        }
    }

    public static class b
    implements LootSerializer<LootItemConditionBlockStateProperty> {
        @Override
        @Override
        public void a(JsonObject json, LootItemConditionBlockStateProperty object, JsonSerializationContext context) {
            json.addProperty("block", IRegistry.U.b(object.a).toString());
            json.add("properties", object.b.a());
        }

        @Override
        public LootItemConditionBlockStateProperty b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.h(jsonObject, "block"));
            Block block = IRegistry.U.b(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Can't find block " + resourceLocation));
            CriterionTriggerProperties statePropertiesPredicate = CriterionTriggerProperties.a(jsonObject.get("properties"));
            statePropertiesPredicate.a(block.m(), (String propertyName) -> {
                throw new JsonSyntaxException("Block " + block + " has no property " + propertyName);
            });
            return new LootItemConditionBlockStateProperty(block, statePropertiesPredicate);
        }

        @Override
        public /* synthetic */ Object a(JsonObject json, JsonDeserializationContext context) {
            return this.b(json, context);
        }
    }
}

