/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class LootItemFunctionExplorationMap
extends LootItemFunctionConditional {
    static final Logger h = LogUtils.getLogger();
    public static final TagKey<StructureFeature<?, ?>> a = ConfiguredStructureTags.e;
    public static final String b = "mansion";
    public static final MapIcon.Type c = MapIcon.Type.i;
    public static final byte d = 2;
    public static final int e = 50;
    public static final boolean f = true;
    final TagKey<StructureFeature<?, ?>> i;
    final MapIcon.Type j;
    final byte k;
    final int l;
    final boolean m;

    LootItemFunctionExplorationMap(LootItemCondition[] conditions, TagKey<StructureFeature<?, ?>> destination, MapIcon.Type decoration, byte zoom, int searchRadius, boolean skipExistingChunks) {
        super(conditions);
        this.i = destination;
        this.j = decoration;
        this.k = zoom;
        this.l = searchRadius;
        this.m = skipExistingChunks;
    }

    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.l;
    }

    @Override
    public Set<LootContextParameter<?>> b() {
        return ImmutableSet.of(LootContextParameters.f);
    }

    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (!stack.a(Items.rp)) {
            return stack;
        }
        Vec3D vec3 = context.c(LootContextParameters.f);
        if (vec3 != null) {
            WorldServer serverLevel = context.c();
            if (!serverLevel.paperConfig.enableTreasureMaps) {
                return stack;
            }
            BlockPosition blockPos = serverLevel.a(this.i, new BlockPosition(vec3), this.l, !serverLevel.paperConfig.treasureMapsAlreadyDiscovered && this.m);
            if (blockPos != null) {
                ItemStack itemStack = ItemWorldMap.a(serverLevel, blockPos.u(), blockPos.w(), this.k, true, true);
                ItemWorldMap.a(serverLevel, itemStack);
                WorldMap.a(itemStack, blockPos, "+", this.j);
                return itemStack;
            }
        }
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private TagKey<StructureFeature<?, ?>> a = a;
        private MapIcon.Type b = c;
        private byte c = (byte)2;
        private int d = 50;
        private boolean e = true;

        protected a a() {
            return this;
        }

        public a a(TagKey<StructureFeature<?, ?>> destination) {
            this.a = destination;
            return this;
        }

        public a a(MapIcon.Type decoration) {
            this.b = decoration;
            return this;
        }

        public a a(byte zoom) {
            this.c = zoom;
            return this;
        }

        public a a(int searchRadius) {
            this.d = searchRadius;
            return this;
        }

        public a a(boolean skipExistingChunks) {
            this.e = skipExistingChunks;
            return this;
        }

        @Override
        public LootItemFunction b() {
            return new LootItemFunctionExplorationMap(this.g(), this.a, this.b, this.c, this.d, this.e);
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionExplorationMap> {
        @Override
        public void a(JsonObject json, LootItemFunctionExplorationMap object, JsonSerializationContext context) {
            super.a(json, object, context);
            if (!object.i.equals(a)) {
                json.addProperty("destination", object.i.b().toString());
            }
            if (object.j != c) {
                json.add("decoration", context.serialize((Object)object.j.toString().toLowerCase(Locale.ROOT)));
            }
            if (object.k != 2) {
                json.addProperty("zoom", (Number)object.k);
            }
            if (object.l != 50) {
                json.addProperty("search_radius", (Number)object.l);
            }
            if (!object.m) {
                json.addProperty("skip_existing_chunks", Boolean.valueOf(object.m));
            }
        }

        public LootItemFunctionExplorationMap a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            TagKey<StructureFeature<?, ?>> tagKey = net.minecraft.world.level.storage.loot.functions.LootItemFunctionExplorationMap$b.a(jsonObject);
            String string = jsonObject.has("decoration") ? ChatDeserializer.h(jsonObject, "decoration") : LootItemFunctionExplorationMap.b;
            MapIcon.Type type = c;
            try {
                type = MapIcon.Type.valueOf(string.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException var10) {
                h.error("Error while parsing loot table decoration entry. Found {}. Defaulting to {}", (Object)string, (Object)c);
            }
            byte b2 = ChatDeserializer.a(jsonObject, "zoom", (byte)2);
            int i2 = ChatDeserializer.a(jsonObject, "search_radius", 50);
            boolean bl = ChatDeserializer.a(jsonObject, "skip_existing_chunks", true);
            return new LootItemFunctionExplorationMap(lootItemConditions, tagKey, type, b2, i2, bl);
        }

        private static TagKey<StructureFeature<?, ?>> a(JsonObject json) {
            if (json.has("destination")) {
                String string = ChatDeserializer.h(json, "destination");
                return TagKey.a(IRegistry.aL, new MinecraftKey(string));
            }
            return a;
        }
    }
}

