/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;

public class LootItemFunctionCopyNBT
extends LootItemFunctionConditional {
    final NbtProvider a;
    final List<b> b;

    LootItemFunctionCopyNBT(LootItemCondition[] conditions, NbtProvider source, List<b> operations) {
        super(conditions);
        this.a = source;
        this.b = ImmutableList.copyOf(operations);
    }

    @Override
    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.v;
    }

    static ArgumentNBTKey.g a(String nbtPath) {
        try {
            return new ArgumentNBTKey().a(new StringReader(nbtPath));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException("Failed to parse path " + nbtPath, commandSyntaxException);
        }
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return this.a.b();
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        NBTBase tag = this.a.a(context);
        if (tag != null) {
            this.b.forEach(operation -> operation.a(stack::u, tag));
        }
        return stack;
    }

    public static a a(NbtProvider source) {
        return new a(source);
    }

    public static a a(LootTableInfo.EntityTarget target) {
        return new a(ContextNbtProvider.a(target));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NbtProvider a;
        private final List<b> b = Lists.newArrayList();

        a(NbtProvider source) {
            this.a = source;
        }

        public a a(String source, String target, Action operator) {
            this.b.add(new b(source, target, operator));
            return this;
        }

        public a a(String source, String target) {
            return this.a(source, target, Action.a);
        }

        @Override
        protected a a() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionCopyNBT(this.g(), this.a, this.b);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a d() {
            return this.a();
        }
    }

    static class b {
        private final String a;
        private final ArgumentNBTKey.g b;
        private final String c;
        private final ArgumentNBTKey.g d;
        private final Action e;

        b(String sourcePath, String targetPath, Action operator) {
            this.a = sourcePath;
            this.b = LootItemFunctionCopyNBT.a(sourcePath);
            this.c = targetPath;
            this.d = LootItemFunctionCopyNBT.a(targetPath);
            this.e = operator;
        }

        public void a(Supplier<NBTBase> itemNbtGetter, NBTBase sourceEntityNbt) {
            try {
                List<NBTBase> list = this.b.a(sourceEntityNbt);
                if (!list.isEmpty()) {
                    this.e.a(itemNbtGetter.get(), this.d, list);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }

        public JsonObject a() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("source", this.a);
            jsonObject.addProperty("target", this.c);
            jsonObject.addProperty("op", this.e.d);
            return jsonObject;
        }

        public static b a(JsonObject json) {
            String string = ChatDeserializer.h(json, "source");
            String string2 = ChatDeserializer.h(json, "target");
            Action mergeStrategy = Action.a(ChatDeserializer.h(json, "op"));
            return new b(string, string2, mergeStrategy);
        }
    }

    public static class d
    extends LootItemFunctionConditional.c<LootItemFunctionCopyNBT> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionCopyNBT object, JsonSerializationContext context) {
            super.a(json, object, context);
            json.add("source", context.serialize((Object)object.a));
            JsonArray jsonArray = new JsonArray();
            object.b.stream().map(b::a).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
            json.add("ops", (JsonElement)jsonArray);
        }

        @Override
        public LootItemFunctionCopyNBT a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            NbtProvider nbtProvider = ChatDeserializer.a(jsonObject, "source", jsonDeserializationContext, NbtProvider.class);
            ArrayList list = Lists.newArrayList();
            JsonArray jsonArray = ChatDeserializer.u(jsonObject, "ops");
            for (JsonElement jsonElement : jsonArray) {
                JsonObject jsonObject2 = ChatDeserializer.m(jsonElement, "op");
                list.add(net.minecraft.world.level.storage.loot.functions.LootItemFunctionCopyNBT$b.a(jsonObject2));
            }
            return new LootItemFunctionCopyNBT(lootItemConditions, nbtProvider, list);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class Action
    extends Enum<Action> {
        public static final /* enum */ Action a = new Action("replace"){

            @Override
            @Override
            public void a(NBTBase itemNbt, ArgumentNBTKey.g targetPath, List<NBTBase> sourceNbts) throws CommandSyntaxException {
                targetPath.b(itemNbt, ((NBTBase)Iterables.getLast(sourceNbts))::c);
            }
        };
        public static final /* enum */ Action b = new Action("append"){

            @Override
            @Override
            public void a(NBTBase itemNbt, ArgumentNBTKey.g targetPath, List<NBTBase> sourceNbts) throws CommandSyntaxException {
                List<NBTBase> list = targetPath.a(itemNbt, NBTTagList::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof NBTTagList) {
                        sourceNbts.forEach(sourceNbt -> ((NBTTagList)foundNbt).add(sourceNbt.c()));
                    }
                });
            }
        };
        public static final /* enum */ Action c = new Action("merge"){

            @Override
            @Override
            public void a(NBTBase itemNbt, ArgumentNBTKey.g targetPath, List<NBTBase> sourceNbts) throws CommandSyntaxException {
                List<NBTBase> list = targetPath.a(itemNbt, NBTTagCompound::new);
                list.forEach(foundNbt -> {
                    if (foundNbt instanceof NBTTagCompound) {
                        sourceNbts.forEach(sourceNbt -> {
                            if (sourceNbt instanceof NBTTagCompound) {
                                ((NBTTagCompound)foundNbt).a((NBTTagCompound)sourceNbt);
                            }
                        });
                    }
                });
            }
        };
        final String d;
        private static final /* synthetic */ Action[] e;

        public static Action[] values() {
            return (Action[])e.clone();
        }

        public static Action valueOf(String string) {
            return Enum.valueOf(Action.class, string);
        }

        public abstract void a(NBTBase var1, ArgumentNBTKey.g var2, List<NBTBase> var3) throws CommandSyntaxException;

        Action(String name) {
            this.d = name;
        }

        public static Action a(String name) {
            for (Action mergeStrategy : Action.values()) {
                if (!mergeStrategy.d.equals(name)) continue;
                return mergeStrategy;
            }
            throw new IllegalArgumentException("Invalid merge strategy" + name);
        }

        private static /* synthetic */ Action[] a() {
            return new Action[]{a, b, c};
        }

        static {
            e = Action.a();
        }
    }
}

