/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionApplyBonus
extends LootItemFunctionConditional {
    static final Map<MinecraftKey, c> a = Maps.newHashMap();
    final Enchantment b;
    final b c;

    LootItemFunctionApplyBonus(LootItemCondition[] conditions, Enchantment enchantment, b formula) {
        super(conditions);
        this.b = enchantment;
        this.c = formula;
    }

    @Override
    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.q;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return ImmutableSet.of(LootContextParameters.i);
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        ItemStack itemStack = context.c(LootContextParameters.i);
        if (itemStack != null) {
            int i2 = EnchantmentManager.a(this.b, itemStack);
            int j2 = this.c.a(context.a(), stack.J(), i2);
            stack.e(j2);
        }
        return stack;
    }

    public static LootItemFunctionConditional.a<?> a(Enchantment enchantment, float probability, int extra) {
        return LootItemFunctionApplyBonus.a((LootItemCondition[] conditions) -> new LootItemFunctionApplyBonus((LootItemCondition[])conditions, enchantment, new a(extra, probability)));
    }

    public static LootItemFunctionConditional.a<?> a(Enchantment enchantment) {
        return LootItemFunctionApplyBonus.a((LootItemCondition[] conditions) -> new LootItemFunctionApplyBonus((LootItemCondition[])conditions, enchantment, new d()));
    }

    public static LootItemFunctionConditional.a<?> b(Enchantment enchantment) {
        return LootItemFunctionApplyBonus.a((LootItemCondition[] conditions) -> new LootItemFunctionApplyBonus((LootItemCondition[])conditions, enchantment, new f(1)));
    }

    public static LootItemFunctionConditional.a<?> a(Enchantment enchantment, int bonusMultiplier) {
        return LootItemFunctionApplyBonus.a((LootItemCondition[] conditions) -> new LootItemFunctionApplyBonus((LootItemCondition[])conditions, enchantment, new f(bonusMultiplier)));
    }

    static {
        a.put(net.minecraft.world.level.storage.loot.functions.LootItemFunctionApplyBonus$a.a, a::a);
        a.put(d.a, d::a);
        a.put(f.a, f::a);
    }

    static interface b {
        public int a(Random var1, int var2, int var3);

        public void a(JsonObject var1, JsonSerializationContext var2);

        public MinecraftKey a();
    }

    static final class f
    implements b {
        public static final MinecraftKey a = new MinecraftKey("uniform_bonus_count");
        private final int b;

        public f(int bonusMultiplier) {
            this.b = bonusMultiplier;
        }

        @Override
        @Override
        public int a(Random random, int initialCount, int enchantmentLevel) {
            return initialCount + random.nextInt(this.b * enchantmentLevel + 1);
        }

        @Override
        @Override
        public void a(JsonObject json, JsonSerializationContext context) {
            json.addProperty("bonusMultiplier", (Number)this.b);
        }

        public static b a(JsonObject json, JsonDeserializationContext context) {
            int i2 = ChatDeserializer.n(json, "bonusMultiplier");
            return new f(i2);
        }

        @Override
        @Override
        public MinecraftKey a() {
            return a;
        }
    }

    static final class d
    implements b {
        public static final MinecraftKey a = new MinecraftKey("ore_drops");

        d() {
        }

        @Override
        @Override
        public int a(Random random, int initialCount, int enchantmentLevel) {
            if (enchantmentLevel > 0) {
                int i2 = random.nextInt(enchantmentLevel + 2) - 1;
                if (i2 < 0) {
                    i2 = 0;
                }
                return initialCount * (i2 + 1);
            }
            return initialCount;
        }

        @Override
        @Override
        public void a(JsonObject json, JsonSerializationContext context) {
        }

        public static b a(JsonObject json, JsonDeserializationContext context) {
            return new d();
        }

        @Override
        @Override
        public MinecraftKey a() {
            return a;
        }
    }

    static final class a
    implements b {
        public static final MinecraftKey a = new MinecraftKey("binomial_with_bonus_count");
        private final int b;
        private final float c;

        public a(int extra, float probability) {
            this.b = extra;
            this.c = probability;
        }

        @Override
        @Override
        public int a(Random random, int initialCount, int enchantmentLevel) {
            for (int i2 = 0; i2 < enchantmentLevel + this.b; ++i2) {
                if (!(random.nextFloat() < this.c)) continue;
                ++initialCount;
            }
            return initialCount;
        }

        @Override
        @Override
        public void a(JsonObject json, JsonSerializationContext context) {
            json.addProperty("extra", (Number)this.b);
            json.addProperty("probability", (Number)Float.valueOf(this.c));
        }

        public static b a(JsonObject json, JsonDeserializationContext context) {
            int i2 = ChatDeserializer.n(json, "extra");
            float f2 = ChatDeserializer.l(json, "probability");
            return new a(i2, f2);
        }

        @Override
        @Override
        public MinecraftKey a() {
            return a;
        }
    }

    static interface c {
        public b deserialize(JsonObject var1, JsonDeserializationContext var2);
    }

    public static class e
    extends LootItemFunctionConditional.c<LootItemFunctionApplyBonus> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionApplyBonus object, JsonSerializationContext context) {
            super.a(json, object, context);
            json.addProperty("enchantment", IRegistry.V.b(object.b).toString());
            json.addProperty("formula", object.c.a().toString());
            JsonObject jsonObject = new JsonObject();
            object.c.a(jsonObject, context);
            if (jsonObject.size() > 0) {
                json.add("parameters", (JsonElement)jsonObject);
            }
        }

        @Override
        public LootItemFunctionApplyBonus a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            b formula2;
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.h(jsonObject, "enchantment"));
            Enchantment enchantment = IRegistry.V.b(resourceLocation).orElseThrow(() -> new JsonParseException("Invalid enchantment id: " + resourceLocation));
            MinecraftKey resourceLocation2 = new MinecraftKey(ChatDeserializer.h(jsonObject, "formula"));
            c formulaDeserializer = a.get(resourceLocation2);
            if (formulaDeserializer == null) {
                throw new JsonParseException("Invalid formula id: " + resourceLocation2);
            }
            if (jsonObject.has("parameters")) {
                b formula = formulaDeserializer.deserialize(ChatDeserializer.t(jsonObject, "parameters"), jsonDeserializationContext);
            } else {
                formula2 = formulaDeserializer.deserialize(new JsonObject(), jsonDeserializationContext);
            }
            return new LootItemFunctionApplyBonus(lootItemConditions, enchantment, formula2);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

