/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class LootTableRegistry
extends ResourceDataJson {
    private static final Logger a = LogUtils.getLogger();
    private static final Gson b = LootSerialization.c().create();
    private Map<MinecraftKey, LootTable> c = ImmutableMap.of();
    public Map<LootTable, MinecraftKey> lootTableToKey = ImmutableMap.of();
    private final LootPredicateManager d;

    public LootTableRegistry(LootPredicateManager conditionManager) {
        super(b, "loot_tables");
        this.d = conditionManager;
    }

    public LootTable a(MinecraftKey id) {
        return this.c.getOrDefault(id, LootTable.a);
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonElement jsonelement = prepared.remove(LootTables.a);
        if (jsonelement != null) {
            a.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.a);
        }
        prepared.forEach((minecraftkey, jsonelement1) -> {
            try {
                LootTable loottable = (LootTable)b.fromJson(jsonelement1, LootTable.class);
                builder.put(minecraftkey, (Object)loottable);
            }
            catch (Exception exception) {
                a.error("Couldn't parse loot table {}", minecraftkey, (Object)exception);
            }
        });
        builder.put((Object)LootTables.a, (Object)LootTable.a);
        ImmutableMap immutablemap = builder.build();
        LootContextParameterSet lootcontextparameterset = LootContextParameterSets.k;
        LootPredicateManager lootpredicatemanager = this.d;
        Objects.requireNonNull(this.d);
        Function<MinecraftKey, LootItemCondition> function = lootpredicatemanager::a;
        Objects.requireNonNull(immutablemap);
        LootCollector lootcollector = new LootCollector(lootcontextparameterset, function, arg_0 -> ((ImmutableMap)immutablemap).get(arg_0));
        immutablemap.forEach((minecraftkey, loottable) -> LootTableRegistry.a(lootcollector, minecraftkey, loottable));
        lootcollector.a().forEach((s2, s1) -> a.warn("Found validation problem in {}: {}", s2, s1));
        this.c = immutablemap;
        ImmutableMap.Builder lootTableToKeyBuilder = ImmutableMap.builder();
        this.c.forEach((lootTable, key) -> lootTableToKeyBuilder.put(key, lootTable));
        this.lootTableToKey = lootTableToKeyBuilder.build();
    }

    public static void a(LootCollector reporter, MinecraftKey id, LootTable table) {
        table.a(reporter.a(table.a()).a("{" + id + "}", id));
    }

    public static JsonElement a(LootTable table) {
        return b.toJsonTree((Object)table);
    }

    public Set<MinecraftKey> a() {
        return this.c.keySet();
    }
}

