/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootTableInfo {
    private final Random a;
    private final float b;
    private final WorldServer c;
    private final Function<MinecraftKey, LootTable> d;
    private final Set<LootTable> e = Sets.newLinkedHashSet();
    private final Function<MinecraftKey, LootItemCondition> f;
    private final Set<LootItemCondition> g = Sets.newLinkedHashSet();
    private final Map<LootContextParameter<?>, Object> h;
    private final Map<MinecraftKey, b> i;

    LootTableInfo(Random random, float luck, WorldServer world, Function<MinecraftKey, LootTable> tableGetter, Function<MinecraftKey, LootItemCondition> conditionGetter, Map<LootContextParameter<?>, Object> parameters, Map<MinecraftKey, b> drops) {
        this.a = random;
        this.b = luck;
        this.c = world;
        this.d = tableGetter;
        this.f = conditionGetter;
        this.h = ImmutableMap.copyOf(parameters);
        this.i = ImmutableMap.copyOf(drops);
    }

    public boolean a(LootContextParameter<?> parameter) {
        return this.h.containsKey(parameter);
    }

    public <T> T b(LootContextParameter<T> parameter) {
        Object object = this.h.get(parameter);
        if (object == null) {
            throw new NoSuchElementException(parameter.a().toString());
        }
        return (T)object;
    }

    public void a(MinecraftKey id, Consumer<ItemStack> lootConsumer) {
        b dynamicDrop = this.i.get(id);
        if (dynamicDrop != null) {
            dynamicDrop.add(this, lootConsumer);
        }
    }

    @Nullable
    public <T> T c(LootContextParameter<T> parameter) {
        return (T)this.h.get(parameter);
    }

    public boolean a(LootTable table) {
        return this.e.add(table);
    }

    public void b(LootTable table) {
        this.e.remove(table);
    }

    public boolean a(LootItemCondition condition) {
        return this.g.add(condition);
    }

    public void b(LootItemCondition condition) {
        this.g.remove(condition);
    }

    public LootTable a(MinecraftKey id) {
        return this.d.apply(id);
    }

    public LootItemCondition b(MinecraftKey id) {
        return this.f.apply(id);
    }

    public Random a() {
        return this.a;
    }

    public float b() {
        return this.b;
    }

    public WorldServer c() {
        return this.c;
    }

    @FunctionalInterface
    public static interface b {
        public void add(LootTableInfo var1, Consumer<ItemStack> var2);
    }

    public static final class EntityTarget
    extends Enum<EntityTarget> {
        public static final /* enum */ EntityTarget a = new EntityTarget("this", LootContextParameters.a);
        public static final /* enum */ EntityTarget b = new EntityTarget("killer", LootContextParameters.d);
        public static final /* enum */ EntityTarget c = new EntityTarget("direct_killer", LootContextParameters.e);
        public static final /* enum */ EntityTarget d = new EntityTarget("killer_player", LootContextParameters.b);
        final String e;
        private final LootContextParameter<? extends Entity> f;
        private static final /* synthetic */ EntityTarget[] g;

        public static EntityTarget[] values() {
            return (EntityTarget[])g.clone();
        }

        public static EntityTarget valueOf(String string) {
            return Enum.valueOf(EntityTarget.class, string);
        }

        private EntityTarget(String type, LootContextParameter<? extends Entity> parameter) {
            this.e = type;
            this.f = parameter;
        }

        public LootContextParameter<? extends Entity> a() {
            return this.f;
        }

        public static EntityTarget a(String type) {
            for (EntityTarget entityTarget : EntityTarget.values()) {
                if (!entityTarget.e.equals(type)) continue;
                return entityTarget;
            }
            throw new IllegalArgumentException("Invalid entity target " + type);
        }

        private static /* synthetic */ EntityTarget[] b() {
            return new EntityTarget[]{a, b, c, d};
        }

        static {
            g = EntityTarget.b();
        }

        public static class a
        extends TypeAdapter<EntityTarget> {
            @Override
            public void a(JsonWriter jsonWriter, EntityTarget entityTarget) throws IOException {
                jsonWriter.value(entityTarget.e);
            }

            @Override
            public EntityTarget a(JsonReader jsonReader) throws IOException {
                return EntityTarget.a(jsonReader.nextString());
            }

            public /* synthetic */ Object read(JsonReader jsonReader) throws IOException {
                return this.a(jsonReader);
            }

            public /* synthetic */ void write(JsonWriter jsonWriter, Object object) throws IOException {
                this.a(jsonWriter, (EntityTarget)((Object)object));
            }
        }
    }

    public static class Builder {
        private final WorldServer a;
        private final Map<LootContextParameter<?>, Object> b = Maps.newIdentityHashMap();
        private final Map<MinecraftKey, b> c = Maps.newHashMap();
        private Random d;
        private float e;

        public Builder(WorldServer world) {
            this.a = world;
        }

        public Builder a(Random random) {
            this.d = random;
            return this;
        }

        public Builder a(long seed) {
            if (seed != 0L) {
                this.d = new Random(seed);
            }
            return this;
        }

        public Builder a(long seed, Random random) {
            this.d = seed == 0L ? random : new Random(seed);
            return this;
        }

        public Builder a(float luck) {
            this.e = luck;
            return this;
        }

        public <T> Builder a(LootContextParameter<T> key, T value) {
            this.b.put(key, value);
            return this;
        }

        public <T> Builder b(LootContextParameter<T> key, @Nullable T value) {
            if (value == null) {
                this.b.remove(key);
            } else {
                this.b.put(key, value);
            }
            return this;
        }

        public Builder a(MinecraftKey id, b value) {
            b dynamicDrop = this.c.put(id, value);
            if (dynamicDrop != null) {
                throw new IllegalStateException("Duplicated dynamic drop '" + this.c + "'");
            }
            return this;
        }

        public WorldServer a() {
            return this.a;
        }

        public <T> T a(LootContextParameter<T> parameter) {
            Object object = this.b.get(parameter);
            if (object == null) {
                throw new IllegalArgumentException("No parameter " + parameter);
            }
            return (T)object;
        }

        @Nullable
        public <T> T b(LootContextParameter<T> parameter) {
            return (T)this.b.get(parameter);
        }

        public LootTableInfo a(LootContextParameterSet type) {
            Sets.SetView set = Sets.difference(this.b.keySet(), type.b());
            if (!set.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + (Set)set);
            }
            Sets.SetView set2 = Sets.difference(type.a(), this.b.keySet());
            if (!set2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + (Set)set2);
            }
            Random random = this.d;
            if (random == null) {
                random = new Random();
            }
            MinecraftServer minecraftServer = this.a.n();
            return new LootTableInfo(random, this.e, this.a, minecraftServer.aF()::a, minecraftServer.aG()::a, this.b, this.c);
        }
    }
}

