/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LootTable {
    static final Logger c = LogUtils.getLogger();
    public static final LootTable a = new LootTable(LootContextParameterSets.a, new LootSelector[0], new LootItemFunction[0]);
    public static final LootContextParameterSet b = LootContextParameterSets.k;
    final LootContextParameterSet d;
    final LootSelector[] e;
    final LootItemFunction[] f;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> g;

    LootTable(LootContextParameterSet type, LootSelector[] pools, LootItemFunction[] functions) {
        this.d = type;
        this.e = pools;
        this.f = functions;
        this.g = LootItemFunctions.a(functions);
    }

    @Deprecated
    public static Consumer<ItemStack> a(Consumer<ItemStack> lootConsumer) {
        return LootTable.createStackSplitter(lootConsumer, null);
    }

    public static Consumer<ItemStack> createStackSplitter(Consumer<ItemStack> lootConsumer, @Nullable WorldServer world) {
        boolean skipSplitter = world != null && !world.paperConfig.splitOverstackedLoot;
        return itemstack -> {
            if (skipSplitter || itemstack.J() < itemstack.e()) {
                lootConsumer.accept((ItemStack)itemstack);
            } else {
                ItemStack itemstack1;
                for (int i2 = itemstack.J(); i2 > 0; i2 -= itemstack1.J()) {
                    itemstack1 = itemstack.n();
                    itemstack1.e(Math.min(itemstack.e(), i2));
                    lootConsumer.accept(itemstack1);
                }
            }
        };
    }

    public void a(LootTableInfo context, Consumer<ItemStack> lootConsumer) {
        if (context.a(this)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.a(this.g, lootConsumer, context);
            for (LootSelector lootselector : this.e) {
                lootselector.a(consumer1, context);
            }
            context.b(this);
        } else {
            c.warn("Detected infinite loop in loot tables");
        }
    }

    public void b(LootTableInfo context, Consumer<ItemStack> lootConsumer) {
        this.a(context, LootTable.createStackSplitter(lootConsumer, context.c()));
    }

    public List<ItemStack> a(LootTableInfo context) {
        ArrayList list = Lists.newArrayList();
        Objects.requireNonNull(list);
        this.b(context, list::add);
        return list;
    }

    public LootContextParameterSet a() {
        return this.d;
    }

    public void a(LootCollector reporter) {
        int i2;
        for (i2 = 0; i2 < this.e.length; ++i2) {
            this.e[i2].a(reporter.b(".pools[" + i2 + "]"));
        }
        for (i2 = 0; i2 < this.f.length; ++i2) {
            this.f[i2].a(reporter.b(".functions[" + i2 + "]"));
        }
    }

    public void a(IInventory inventory, LootTableInfo context) {
        this.fillInventory(inventory, context, false);
    }

    public void fillInventory(IInventory iinventory, LootTableInfo loottableinfo, boolean plugin) {
        List<ItemStack> list = this.a(loottableinfo);
        Random random = loottableinfo.a();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, list, plugin);
        if (event.isCancelled()) {
            return;
        }
        list = event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(Collectors.toList());
        List<Integer> list1 = this.a(iinventory, random);
        this.a(list, list1.size(), random);
        for (ItemStack itemstack : list) {
            if (list1.isEmpty()) {
                c.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.b()) {
                iinventory.a((int)list1.remove(list1.size() - 1), ItemStack.b);
                continue;
            }
            iinventory.a((int)list1.remove(list1.size() - 1), itemstack);
        }
    }

    private void a(List<ItemStack> drops, int freeSlots, Random random) {
        ArrayList list1 = Lists.newArrayList();
        Iterator<ItemStack> iterator = drops.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = iterator.next();
            if (itemstack.b()) {
                iterator.remove();
                continue;
            }
            if (itemstack.J() <= 1) continue;
            list1.add(itemstack);
            iterator.remove();
        }
        while (freeSlots - drops.size() - list1.size() > 0 && !list1.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list1.remove(MathHelper.a(random, 0, list1.size() - 1));
            int j2 = MathHelper.a(random, 1, itemstack1.J() / 2);
            ItemStack itemstack2 = itemstack1.a(j2);
            if (itemstack1.J() > 1 && random.nextBoolean()) {
                list1.add(itemstack1);
            } else {
                drops.add(itemstack1);
            }
            if (itemstack2.J() > 1 && random.nextBoolean()) {
                list1.add(itemstack2);
                continue;
            }
            drops.add(itemstack2);
        }
        drops.addAll(list1);
        Collections.shuffle(drops, random);
    }

    private List<Integer> a(IInventory inventory, Random random) {
        ArrayList list = Lists.newArrayList();
        for (int i2 = 0; i2 < inventory.b(); ++i2) {
            if (!inventory.a(i2).b()) continue;
            list.add(i2);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static a b() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final List<LootSelector> a = Lists.newArrayList();
        private final List<LootItemFunction> b = Lists.newArrayList();
        private LootContextParameterSet c = b;

        public a a(LootSelector.a poolBuilder) {
            this.a.add(poolBuilder.b());
            return this;
        }

        public a a(LootContextParameterSet context) {
            this.c = context;
            return this;
        }

        public a a(LootItemFunction.a function) {
            this.b.add(function.b());
            return this;
        }

        public a a() {
            return this;
        }

        public LootTable b() {
            return new LootTable(this.c, this.a.toArray(new LootSelector[0]), this.b.toArray(new LootItemFunction[0]));
        }
    }

    public static class b
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable a(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            JsonObject jsonobject = ChatDeserializer.m(jsonelement, "loot table");
            LootSelector[] alootselector = ChatDeserializer.a(jsonobject, "pools", new LootSelector[0], jsondeserializationcontext, LootSelector[].class);
            LootContextParameterSet lootcontextparameterset = null;
            if (jsonobject.has("type")) {
                String s2 = ChatDeserializer.h(jsonobject, "type");
                lootcontextparameterset = LootContextParameterSets.a(new MinecraftKey(s2));
            }
            LootItemFunction[] alootitemfunction = ChatDeserializer.a(jsonobject, "functions", new LootItemFunction[0], jsondeserializationcontext, LootItemFunction[].class);
            return new LootTable(lootcontextparameterset != null ? lootcontextparameterset : LootContextParameterSets.k, alootselector, alootitemfunction);
        }

        public JsonElement a(LootTable loottable, Type type, JsonSerializationContext jsonserializationcontext) {
            JsonObject jsonobject = new JsonObject();
            if (loottable.d != b) {
                MinecraftKey minecraftkey = LootContextParameterSets.a(loottable.d);
                if (minecraftkey != null) {
                    jsonobject.addProperty("type", minecraftkey.toString());
                } else {
                    c.warn("Failed to find id for param set {}", (Object)loottable.d);
                }
            }
            if (loottable.e.length > 0) {
                jsonobject.add("pools", jsonserializationcontext.serialize((Object)loottable.e));
            }
            if (!ArrayUtils.isEmpty((Object[])loottable.f)) {
                jsonobject.add("functions", jsonserializationcontext.serialize((Object)loottable.f));
            }
            return jsonobject;
        }
    }
}

