/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import ca.spottedleaf.dataconverter.minecraft.MCDataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class WorldNBTStorage {
    private static final Logger b = LogUtils.getLogger();
    private final File c;
    protected final DataFixer a;

    public WorldNBTStorage(Convertable.ConversionSession session, DataFixer dataFixer) {
        this.a = dataFixer;
        this.c = session.a(SavedFile.c).toFile();
        this.c.mkdirs();
    }

    public void a(EntityHuman player) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try {
            NBTTagCompound nbttagcompound = player.f(new NBTTagCompound());
            File file = File.createTempFile(player.cn() + "-", ".dat", this.c);
            NBTCompressedStreamTools.a(nbttagcompound, file);
            File file1 = new File(this.c, player.cn() + ".dat");
            File file2 = new File(this.c, player.cn() + ".dat_old");
            SystemUtils.a(file1, file, file2);
        }
        catch (Exception exception) {
            b.warn("Failed to save player data for {}", (Object)player.co(), (Object)exception);
        }
    }

    @Nullable
    public NBTTagCompound b(EntityHuman player) {
        NBTTagCompound nbttagcompound = null;
        try {
            File file = new File(this.c, player.cn() + ".dat");
            boolean usingWrongFile = false;
            if (Bukkit.getOnlineMode() && !file.exists() && (file = new File(this.c, UUID.nameUUIDFromBytes(("OfflinePlayer:" + player.co()).getBytes("UTF-8")).toString() + ".dat")).exists()) {
                usingWrongFile = true;
                Bukkit.getServer().getLogger().warning("Using offline mode UUID file for player " + player.co() + " as it is the only copy we can find.");
            }
            if (file.exists() && file.isFile()) {
                nbttagcompound = NBTCompressedStreamTools.a(file);
            }
            if (usingWrongFile) {
                file.renameTo(new File(file.getPath() + ".offline-read"));
            }
        }
        catch (Exception exception) {
            b.warn("Failed to load player data for {}", (Object)player.X().getString());
        }
        if (nbttagcompound != null) {
            if (player instanceof EntityPlayer) {
                CraftPlayer player1 = (CraftPlayer)player.getBukkitEntity();
                long modified = new File(this.c, player.cm().toString() + ".dat").lastModified();
                if (modified < player1.getFirstPlayed()) {
                    player1.setFirstPlayed(modified);
                }
            }
            int i2 = nbttagcompound.b("DataVersion", 3) ? nbttagcompound.h("DataVersion") : -1;
            player.g(MCDataConverter.convertTag(MCTypeRegistry.PLAYER, nbttagcompound, i2, SharedConstants.b().getWorldVersion()));
        }
        return nbttagcompound;
    }

    public NBTTagCompound getPlayerData(String s2) {
        try {
            File file1 = new File(this.c, s2 + ".dat");
            if (file1.exists()) {
                return NBTCompressedStreamTools.a(new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            b.warn("Failed to load player data for " + s2);
        }
        return null;
    }

    public String[] a() {
        String[] astring = this.c.list();
        if (astring == null) {
            astring = new String[]{};
        }
        for (int i2 = 0; i2 < astring.length; ++i2) {
            if (!astring[i2].endsWith(".dat")) continue;
            astring[i2] = astring[i2].substring(0, astring[i2].length() - 4);
        }
        return astring;
    }

    public File getPlayerDir() {
        return this.c;
    }
}

