/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.MinecraftSerializableUUID;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger e = LogUtils.getLogger();
    protected static final String a = "Player";
    protected static final String b = "WorldGenSettings";
    public WorldSettings f;
    private final GeneratorSettings g;
    private final Lifecycle h;
    private int i;
    private int j;
    private int k;
    private float l;
    private long m;
    private long n;
    @Nullable
    private final DataFixer o;
    private final int p;
    private boolean q;
    @Nullable
    private NBTTagCompound r;
    private final int s;
    private int t;
    private boolean u;
    private int v;
    private boolean w;
    private int x;
    private boolean y;
    private boolean z;
    private WorldBorder.c A;
    private NBTTagCompound B;
    @Nullable
    private NBTTagCompound C;
    private int D;
    private int E;
    @Nullable
    private UUID F;
    private final Set<String> G;
    private boolean H;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> I;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable DataFixer dataFixer, int dataVersion, @Nullable NBTTagCompound playerData, boolean modded, int spawnX, int spawnY, int spawnZ, float spawnAngle, long time, long timeOfDay, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, WorldBorder.c worldBorder, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> serverBrands, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, NBTTagCompound dragonFight, WorldSettings levelInfo, GeneratorSettings generatorOptions, Lifecycle lifecycle) {
        this.o = dataFixer;
        this.H = modded;
        this.i = spawnX;
        this.j = spawnY;
        this.k = spawnZ;
        this.l = spawnAngle;
        this.m = time;
        this.n = timeOfDay;
        this.s = version;
        this.t = clearWeatherTime;
        this.v = rainTime;
        this.u = raining;
        this.x = thunderTime;
        this.w = thundering;
        this.y = initialized;
        this.z = difficultyLocked;
        this.A = worldBorder;
        this.D = wanderingTraderSpawnDelay;
        this.E = wanderingTraderSpawnChance;
        this.F = wanderingTraderId;
        this.G = serverBrands;
        this.r = playerData;
        this.p = dataVersion;
        this.I = scheduledEvents;
        this.C = customBossEvents;
        this.B = dragonFight;
        this.f = levelInfo;
        this.g = generatorOptions;
        this.h = lifecycle;
    }

    public WorldDataServer(WorldSettings levelInfo, GeneratorSettings generatorOptions, Lifecycle lifecycle) {
        this(null, SharedConstants.b().getWorldVersion(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.d, 0, 0, null, Sets.newLinkedHashSet(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, new NBTTagCompound(), levelInfo.h(), generatorOptions, lifecycle);
    }

    public static WorldDataServer a(Dynamic<NBTBase> dynamic, DataFixer dataFixer, int dataVersion, @Nullable NBTTagCompound playerData, WorldSettings levelInfo, LevelVersion saveVersionInfo, GeneratorSettings generatorOptions, Lifecycle lifecycle) {
        long j2 = dynamic.get("Time").asLong(0L);
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("DragonFight").result().map(Dynamic::getValue).orElseGet(() -> (NBTBase)dynamic.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap().getValue());
        return new WorldDataServer(dataFixer, dataVersion, playerData, dynamic.get("WasModded").asBoolean(false), dynamic.get("SpawnX").asInt(0), dynamic.get("SpawnY").asInt(0), dynamic.get("SpawnZ").asInt(0), dynamic.get("SpawnAngle").asFloat(0.0f), j2, dynamic.get("DayTime").asLong(j2), saveVersionInfo.a(), dynamic.get("clearWeatherTime").asInt(0), dynamic.get("rainTime").asInt(0), dynamic.get("raining").asBoolean(false), dynamic.get("thunderTime").asInt(0), dynamic.get("thundering").asBoolean(false), dynamic.get("initialized").asBoolean(true), dynamic.get("DifficultyLocked").asBoolean(false), WorldBorder.c.a(dynamic, WorldBorder.d), dynamic.get("WanderingTraderSpawnDelay").asInt(0), dynamic.get("WanderingTraderSpawnChance").asInt(0), dynamic.get("WanderingTraderId").read(MinecraftSerializableUUID.a).result().orElse(null), dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream()), (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue(), nbttagcompound1, levelInfo, generatorOptions, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registryManager, @Nullable NBTTagCompound playerNbt) {
        this.J();
        if (playerNbt == null) {
            playerNbt = this.r;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(registryManager, nbttagcompound1, playerNbt);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom registryManager, NBTTagCompound levelNbt, @Nullable NBTTagCompound playerNbt) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = this.G.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        levelNbt.a("ServerBrands", nbttaglist);
        levelNbt.a("WasModded", this.H);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().getName());
        nbttagcompound2.a("Id", SharedConstants.b().b().c());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().isStable());
        nbttagcompound2.a("Series", SharedConstants.b().b().b());
        levelNbt.a("Version", nbttagcompound2);
        levelNbt.a("DataVersion", SharedConstants.b().getWorldVersion());
        RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, registryManager);
        DataResult dataresult = GeneratorSettings.a.encodeStart(dynamicops, (Object)this.g);
        Logger logger = e;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> levelNbt.a(b, (NBTBase)nbtbase));
        levelNbt.a("GameType", this.f.b().a());
        levelNbt.a("SpawnX", this.i);
        levelNbt.a("SpawnY", this.j);
        levelNbt.a("SpawnZ", this.k);
        levelNbt.a("SpawnAngle", this.l);
        levelNbt.a("Time", this.m);
        levelNbt.a("DayTime", this.n);
        levelNbt.a("LastPlayed", SystemUtils.d());
        levelNbt.a("LevelName", this.f.a());
        levelNbt.a("version", 19133);
        levelNbt.a("clearWeatherTime", this.t);
        levelNbt.a("rainTime", this.v);
        levelNbt.a("raining", this.u);
        levelNbt.a("thunderTime", this.x);
        levelNbt.a("thundering", this.w);
        levelNbt.a("hardcore", this.f.c());
        levelNbt.a("allowCommands", this.f.e());
        levelNbt.a("initialized", this.y);
        this.A.a(levelNbt);
        levelNbt.a("Difficulty", (byte)this.f.d().a());
        levelNbt.a("DifficultyLocked", this.z);
        levelNbt.a("GameRules", this.f.f().a());
        levelNbt.a("DragonFight", this.B);
        if (playerNbt != null) {
            levelNbt.a(a, playerNbt);
        }
        DataPackConfiguration.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f.g()).result().ifPresent(nbtbase -> levelNbt.a("DataPacks", (NBTBase)nbtbase));
        if (this.C != null) {
            levelNbt.a("CustomBossEvents", this.C);
        }
        levelNbt.a("ScheduledEvents", this.I.b());
        levelNbt.a("WanderingTraderSpawnDelay", this.D);
        levelNbt.a("WanderingTraderSpawnChance", this.E);
        if (this.F != null) {
            levelNbt.a("WanderingTraderId", this.F);
        }
        levelNbt.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(levelNbt);
    }

    @Override
    public int a() {
        return this.i;
    }

    @Override
    public int b() {
        return this.j;
    }

    @Override
    public int c() {
        return this.k;
    }

    @Override
    public float d() {
        return this.l;
    }

    @Override
    public long e() {
        return this.m;
    }

    @Override
    public long f() {
        return this.n;
    }

    private void J() {
        if (!this.q && this.r != null) {
            if (this.p < SharedConstants.b().getWorldVersion()) {
                if (this.o == null) {
                    throw SystemUtils.c(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
                }
                this.r = GameProfileSerializer.a(this.o, DataFixTypes.b, this.r, this.p);
            }
            this.q = true;
        }
    }

    @Override
    public NBTTagCompound y() {
        this.J();
        return this.r;
    }

    @Override
    public void b(int spawnX) {
        this.i = spawnX;
    }

    @Override
    public void c(int spawnY) {
        this.j = spawnY;
    }

    @Override
    public void d(int spawnZ) {
        this.k = spawnZ;
    }

    @Override
    public void a(float spawnAngle) {
        this.l = spawnAngle;
    }

    @Override
    public void a(long time) {
        this.m = time;
    }

    @Override
    public void b(long timeOfDay) {
        this.n = timeOfDay;
    }

    @Override
    public void a(BlockPosition pos, float angle) {
        this.i = pos.u();
        this.j = pos.v();
        this.k = pos.w();
        this.l = angle;
    }

    @Override
    public String g() {
        return this.f.a();
    }

    @Override
    public int z() {
        return this.s;
    }

    @Override
    public int h() {
        return this.t;
    }

    @Override
    public void a(int clearWeatherTime) {
        this.t = clearWeatherTime;
    }

    @Override
    public boolean i() {
        return this.w;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.w == thundering) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.w = thundering;
    }

    @Override
    public int j() {
        return this.x;
    }

    @Override
    public void e(int thunderTime) {
        this.x = thunderTime;
    }

    @Override
    public boolean k() {
        return this.u;
    }

    @Override
    public void b(boolean raining) {
        this.setRaining(raining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean raining, WeatherChangeEvent.Cause cause) {
        if (this.u == raining) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, raining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.u = raining;
    }

    @Override
    public int l() {
        return this.v;
    }

    @Override
    public void f(int rainTime) {
        this.v = rainTime;
    }

    @Override
    public EnumGamemode m() {
        return this.f.b();
    }

    @Override
    public void a(EnumGamemode gameMode) {
        this.f = this.f.a(gameMode);
    }

    @Override
    public boolean n() {
        return this.f.c();
    }

    @Override
    public boolean o() {
        return this.f.e();
    }

    @Override
    public boolean p() {
        return this.y;
    }

    @Override
    public void c(boolean initialized) {
        this.y = initialized;
    }

    @Override
    public GameRules q() {
        return this.f.f();
    }

    @Override
    public WorldBorder.c r() {
        return this.A;
    }

    @Override
    public void a(WorldBorder.c worldBorder) {
        this.A = worldBorder;
    }

    @Override
    public EnumDifficulty s() {
        return this.f.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.f = this.f.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.s(), this.t());
        for (EntityPlayer player : this.world.y()) {
            player.b.a(packet);
        }
    }

    @Override
    public boolean t() {
        return this.z;
    }

    @Override
    public void d(boolean difficultyLocked) {
        this.z = difficultyLocked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> u() {
        return this.I;
    }

    @Override
    public void a(CrashReportSystemDetails reportSection, LevelHeightAccessor world) {
        IWorldDataServer.super.a(reportSection, world);
        SaveData.super.a(reportSection);
    }

    @Override
    public GeneratorSettings A() {
        return this.g;
    }

    @Override
    public Lifecycle B() {
        return this.h;
    }

    @Override
    public NBTTagCompound C() {
        return this.B;
    }

    @Override
    public void a(NBTTagCompound dragonFight) {
        this.B = dragonFight;
    }

    @Override
    public DataPackConfiguration D() {
        return this.f.g();
    }

    @Override
    public void a(DataPackConfiguration dataPackSettings) {
        this.f = this.f.a(dataPackSettings);
    }

    @Override
    @Nullable
    public NBTTagCompound E() {
        return this.C;
    }

    @Override
    public void b(@Nullable NBTTagCompound customBossEvents) {
        this.C = customBossEvents;
    }

    @Override
    public int v() {
        return this.D;
    }

    @Override
    public void g(int wanderingTraderSpawnDelay) {
        this.D = wanderingTraderSpawnDelay;
    }

    @Override
    public int w() {
        return this.E;
    }

    @Override
    public void h(int wanderingTraderSpawnChance) {
        this.E = wanderingTraderSpawnChance;
    }

    @Override
    @Nullable
    public UUID x() {
        return this.F;
    }

    @Override
    public void a(UUID wanderingTraderId) {
        this.F = wanderingTraderId;
    }

    @Override
    public void a(String brand, boolean modded) {
        this.G.add(brand);
        this.H |= modded;
    }

    @Override
    public boolean F() {
        return this.H;
    }

    @Override
    public Set<String> G() {
        return ImmutableSet.copyOf(this.G);
    }

    @Override
    public IWorldDataServer H() {
        return this;
    }

    @Override
    public WorldSettings I() {
        return this.f.h();
    }

    public void checkName(String name) {
        if (!this.f.a.equals(name)) {
            this.f.a = name;
        }
    }
}

