/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import com.destroystokyo.paper.PaperConfig;
import io.papermc.paper.util.PoiAccess;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class PortalTravelAgent {
    private static final int a = 3;
    private static final int b = 128;
    private static final int c = 16;
    private static final int d = 5;
    private static final int e = 4;
    private static final int f = 3;
    private static final int g = -1;
    private static final int h = 4;
    private static final int i = -1;
    private static final int j = 3;
    private static final int k = -1;
    private static final int l = 2;
    private static final int m = -1;
    private final WorldServer n;

    public PortalTravelAgent(WorldServer world) {
        this.n = world;
    }

    public Optional<BlockUtil.Rectangle> a(BlockPosition pos, boolean destIsNether, WorldBorder worldBorder) {
        return this.findPortalAround(pos, worldBorder, destIsNether ? this.n.paperConfig.portalCreateRadius : this.n.paperConfig.portalSearchRadius);
    }

    public Optional<BlockUtil.Rectangle> findPortalAround(BlockPosition blockposition, WorldBorder worldborder, int i2) {
        VillagePlace villageplace = this.n.z();
        ArrayList<VillagePlaceRecord> records = new ArrayList<VillagePlaceRecord>();
        PoiAccess.findClosestPoiDataRecords(villageplace, type -> type == VillagePlaceType.v, pos -> {
            IChunkAccess lowest = this.n.a(pos.u() >> 4, pos.w() >> 4, ChunkStatus.c);
            if (!(lowest.j().b(ChunkStatus.o) || lowest.x() != null && lowest.x().a().b(ChunkStatus.n))) {
                return false;
            }
            if (!worldborder.a((BlockPosition)pos)) {
                return false;
            }
            return lowest.a_((BlockPosition)pos).b(BlockProperties.F);
        }, blockposition, i2, Double.MAX_VALUE, VillagePlace.Occupancy.c, true, records);
        VillagePlaceRecord lowestYRecord = null;
        for (VillagePlaceRecord record : records) {
            if (lowestYRecord == null) {
                lowestYRecord = record;
                continue;
            }
            if (lowestYRecord.f().v() <= record.f().v()) continue;
            lowestYRecord = record;
        }
        Optional<Object> optional = Optional.ofNullable(lowestYRecord);
        return optional.map(villageplacerecord -> {
            BlockPosition blockposition1 = villageplacerecord.f();
            this.n.k().a(TicketType.f, new ChunkCoordIntPair(blockposition1), 3, blockposition1);
            IBlockData iblockdata = this.n.a_(blockposition1);
            return BlockUtil.a(blockposition1, iblockdata.c(BlockProperties.F), 21, EnumDirection.EnumAxis.b, 21, blockposition2 -> this.n.a_((BlockPosition)blockposition2) == iblockdata);
        });
    }

    public Optional<BlockUtil.Rectangle> a(BlockPosition pos, EnumDirection.EnumAxis axis) {
        return this.createPortal(pos, axis, null, 16);
    }

    public Optional<BlockUtil.Rectangle> createPortal(BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis, net.minecraft.world.entity.Entity entity, int createRadius) {
        int k1;
        int l2;
        int k2;
        int j2;
        EnumDirection enumdirection = EnumDirection.a(EnumDirection.EnumAxisDirection.a, enumdirection_enumaxis);
        double d0 = -1.0;
        BlockPosition blockposition1 = null;
        double d1 = -1.0;
        BlockPosition blockposition2 = null;
        WorldBorder worldborder = this.n.p_();
        int i2 = Math.min(this.n.ag(), this.n.u_() + this.n.j()) - 1;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.i();
        for (BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 : BlockPosition.a(blockposition, createRadius, EnumDirection.f, EnumDirection.d)) {
            j2 = Math.min(i2, this.n.a(HeightMap.Type.e, blockposition_mutableblockposition1.u(), blockposition_mutableblockposition1.w()));
            boolean flag = true;
            if (!worldborder.a(blockposition_mutableblockposition1) || !worldborder.a(blockposition_mutableblockposition1.c(enumdirection, 1))) continue;
            blockposition_mutableblockposition1.c(enumdirection.f(), 1);
            for (k2 = j2; k2 >= this.n.u_(); --k2) {
                int i1;
                blockposition_mutableblockposition1.q(k2);
                if (!this.n.w(blockposition_mutableblockposition1)) continue;
                l2 = k2;
                while (k2 > this.n.u_() && this.n.w(blockposition_mutableblockposition1.c(EnumDirection.a))) {
                    --k2;
                }
                if (k2 + 4 > i2 || (i1 = l2 - k2) > 0 && i1 < 3) continue;
                blockposition_mutableblockposition1.q(k2);
                if (!this.a(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 0)) continue;
                double d2 = blockposition.j(blockposition_mutableblockposition1);
                if (this.a(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, -1) && this.a(blockposition_mutableblockposition1, blockposition_mutableblockposition, enumdirection, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockposition1 = blockposition_mutableblockposition1.h();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockposition2 = blockposition_mutableblockposition1.h();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockposition1 = blockposition2;
            d0 = d1;
        }
        BlockStateListPopulator blockList = new BlockStateListPopulator(this.n);
        if (d0 == -1.0) {
            k1 = i2 - 9;
            int j1 = Math.max(this.n.u_() - -1, 70);
            if (k1 < j1) {
                return Optional.empty();
            }
            blockposition1 = new BlockPosition(blockposition.u(), MathHelper.a(blockposition.v(), j1, k1), blockposition.w()).h();
            EnumDirection enumdirection1 = enumdirection.g();
            if (!worldborder.a(blockposition1)) {
                return Optional.empty();
            }
            for (int l1 = -1; l1 < 2; ++l1) {
                for (k2 = 0; k2 < 2; ++k2) {
                    for (l2 = -1; l2 < 3; ++l2) {
                        IBlockData iblockdata = l2 < 0 ? Blocks.bQ.n() : Blocks.a.n();
                        blockposition_mutableblockposition.a(blockposition1, k2 * enumdirection.i() + l1 * enumdirection1.i(), l2, k2 * enumdirection.k() + l1 * enumdirection1.k());
                        blockList.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 3);
                    }
                }
            }
        }
        for (int j1 = -1; j1 < 3; ++j1) {
            for (k1 = -1; k1 < 4; ++k1) {
                if (j1 != -1 && j1 != 2 && k1 != -1 && k1 != 3) continue;
                blockposition_mutableblockposition.a(blockposition1, j1 * enumdirection.i(), k1, j1 * enumdirection.k());
                blockList.a((BlockPosition)blockposition_mutableblockposition, Blocks.bQ.n(), 3);
            }
        }
        IBlockData iblockdata1 = (IBlockData)Blocks.db.n().a(BlockPortal.a, enumdirection_enumaxis);
        for (k1 = 0; k1 < 2; ++k1) {
            for (j2 = 0; j2 < 3; ++j2) {
                blockposition_mutableblockposition.a(blockposition1, k1 * enumdirection.i(), j2, k1 * enumdirection.k());
                blockList.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
            }
        }
        CraftWorld bworld = this.n.getWorld();
        PortalCreateEvent event = new PortalCreateEvent(blockList.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.NETHER_PAIR);
        this.n.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return Optional.empty();
        }
        blockList.updateList();
        return Optional.of(new BlockUtil.Rectangle(blockposition1.h(), 2, 3));
    }

    private boolean a(BlockPosition pos, BlockPosition.MutableBlockPosition temp, EnumDirection portalDirection, int distanceOrthogonalToPortal) {
        EnumDirection enumdirection1 = portalDirection.g();
        for (int j2 = -1; j2 < 3; ++j2) {
            for (int k2 = -1; k2 < 4; ++k2) {
                temp.a(pos, portalDirection.i() * j2 + enumdirection1.i() * distanceOrthogonalToPortal, k2, portalDirection.k() * j2 + enumdirection1.k() * distanceOrthogonalToPortal);
                if (!PaperConfig.allowBlockPermanentBreakingExploits && !this.n.a_(temp).isDestroyable()) {
                    return false;
                }
                if (k2 < 0 && !this.n.a_(temp).c().b()) {
                    return false;
                }
                if (k2 < 0 || this.n.w(temp)) continue;
                return false;
            }
        }
        return true;
    }
}

