/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PathfinderNormal
extends PathfinderAbstract {
    public static final double j = 0.5;
    protected float k;
    private final Long2ObjectMap<PathType> l = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AxisAlignedBB> m = new Object2BooleanOpenHashMap();

    @Override
    public void a(ChunkCache cachedWorld, EntityInsentient entity) {
        super.a(cachedWorld, entity);
        this.k = entity.a(PathType.j);
    }

    @Override
    public void a() {
        this.b.a(PathType.j, this.k);
        this.l.clear();
        this.m.clear();
        super.a();
    }

    @Override
    public PathPoint b() {
        int i2;
        BlockPosition.MutableBlockPosition mutableBlockPos;
        block11: {
            mutableBlockPos = new BlockPosition.MutableBlockPosition();
            i2 = this.b.dd();
            IBlockData blockState = this.a.a_(mutableBlockPos.c(this.b.dc(), (double)i2, this.b.di()));
            if (!this.b.a(blockState.o())) {
                if (this.f() && this.b.aQ()) {
                    while (true) {
                        if (!blockState.a(Blocks.A) && blockState.o() != FluidTypes.c.a(false)) {
                            --i2;
                            break block11;
                        }
                        blockState = this.a.a_(mutableBlockPos.c(this.b.dc(), (double)(++i2), this.b.di()));
                    }
                }
                if (this.b.aw()) {
                    i2 = MathHelper.b(this.b.de() + 0.5);
                } else {
                    BlockPosition blockPos = this.b.cW();
                    while ((this.a.a_(blockPos).g() || this.a.a_(blockPos).a((IBlockAccess)this.a, blockPos, PathMode.a)) && blockPos.v() > this.b.s.u_()) {
                        blockPos = blockPos.c();
                    }
                    i2 = blockPos.b().v();
                }
            } else {
                while (this.b.a(blockState.o())) {
                    blockState = this.a.a_(mutableBlockPos.c(this.b.dc(), (double)(++i2), this.b.di()));
                }
                --i2;
            }
        }
        BlockPosition blockPos2 = this.b.cW();
        PathType blockPathTypes = this.a(this.b, blockPos2.u(), i2, blockPos2.w());
        if (this.b.a(blockPathTypes) < 0.0f) {
            AxisAlignedBB aABB = this.b.cw();
            if (this.c(mutableBlockPos.c(aABB.a, (double)i2, aABB.c)) || this.c(mutableBlockPos.c(aABB.a, (double)i2, aABB.f)) || this.c(mutableBlockPos.c(aABB.d, (double)i2, aABB.c)) || this.c(mutableBlockPos.c(aABB.d, (double)i2, aABB.f))) {
                PathPoint node = this.b(mutableBlockPos);
                node.l = this.a(this.b, node.a());
                node.k = this.b.a(node.l);
                return node;
            }
        }
        PathPoint node2 = this.a(blockPos2.u(), i2, blockPos2.w());
        node2.l = this.a(this.b, node2.a());
        node2.k = this.b.a(node2.l);
        return node2;
    }

    private boolean c(BlockPosition pos) {
        PathType blockPathTypes = this.a(this.b, pos);
        return this.b.a(blockPathTypes) >= 0.0f;
    }

    @Override
    public PathDestination a(double x2, double y2, double z2) {
        return new PathDestination(this.a(MathHelper.b(x2), MathHelper.b(y2), MathHelper.b(z2)));
    }

    @Override
    public int a(PathPoint[] successors, PathPoint node) {
        PathPoint node9;
        PathPoint node8;
        PathPoint node7;
        PathPoint node6;
        PathPoint node5;
        PathPoint node4;
        PathPoint node3;
        double d2;
        PathPoint node2;
        int i2 = 0;
        int j2 = 0;
        PathType blockPathTypes = this.a(this.b, node.a, node.b + 1, node.c);
        PathType blockPathTypes2 = this.a(this.b, node.a, node.b, node.c);
        if (this.b.a(blockPathTypes) >= 0.0f && blockPathTypes2 != PathType.y) {
            j2 = MathHelper.d(Math.max(1.0f, this.b.P));
        }
        if (this.a(node2 = this.a(node.a, node.b, node.c + 1, j2, d2 = this.a(new BlockPosition(node.a, node.b, node.c)), EnumDirection.d, blockPathTypes2), node)) {
            successors[i2++] = node2;
        }
        if (this.a(node3 = this.a(node.a - 1, node.b, node.c, j2, d2, EnumDirection.e, blockPathTypes2), node)) {
            successors[i2++] = node3;
        }
        if (this.a(node4 = this.a(node.a + 1, node.b, node.c, j2, d2, EnumDirection.f, blockPathTypes2), node)) {
            successors[i2++] = node4;
        }
        if (this.a(node5 = this.a(node.a, node.b, node.c - 1, j2, d2, EnumDirection.c, blockPathTypes2), node)) {
            successors[i2++] = node5;
        }
        if (this.a(node, node3, node5, node6 = this.a(node.a - 1, node.b, node.c - 1, j2, d2, EnumDirection.c, blockPathTypes2))) {
            successors[i2++] = node6;
        }
        if (this.a(node, node4, node5, node7 = this.a(node.a + 1, node.b, node.c - 1, j2, d2, EnumDirection.c, blockPathTypes2))) {
            successors[i2++] = node7;
        }
        if (this.a(node, node3, node2, node8 = this.a(node.a - 1, node.b, node.c + 1, j2, d2, EnumDirection.d, blockPathTypes2))) {
            successors[i2++] = node8;
        }
        if (this.a(node, node4, node2, node9 = this.a(node.a + 1, node.b, node.c + 1, j2, d2, EnumDirection.d, blockPathTypes2))) {
            successors[i2++] = node9;
        }
        return i2;
    }

    protected boolean a(@Nullable PathPoint node, PathPoint successor1) {
        return node != null && !node.i && (node.k >= 0.0f || successor1.k < 0.0f);
    }

    protected boolean a(PathPoint xNode, @Nullable PathPoint zNode, @Nullable PathPoint xDiagNode, @Nullable PathPoint zDiagNode) {
        if (zDiagNode != null && xDiagNode != null && zNode != null) {
            if (zDiagNode.i) {
                return false;
            }
            if (xDiagNode.b <= xNode.b && zNode.b <= xNode.b) {
                if (zNode.l != PathType.d && xDiagNode.l != PathType.d && zDiagNode.l != PathType.d) {
                    boolean bl = xDiagNode.l == PathType.h && zNode.l == PathType.h && (double)this.b.cT() < 0.5;
                    return zDiagNode.k >= 0.0f && (xDiagNode.b < xNode.b || xDiagNode.k >= 0.0f || bl) && (zNode.b < xNode.b || zNode.k >= 0.0f || bl);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean a(PathPoint node) {
        Vec3D vec3 = new Vec3D((double)node.a - this.b.dc(), (double)node.b - this.b.de(), (double)node.c - this.b.di());
        AxisAlignedBB aABB = this.b.cw();
        int i2 = MathHelper.e(vec3.f() / aABB.a());
        vec3 = vec3.a((double)(1.0f / (float)i2));
        for (int j2 = 1; j2 <= i2; ++j2) {
            if (!this.a(aABB = aABB.c(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double a(BlockPosition pos) {
        return PathfinderNormal.a((IBlockAccess)this.a, pos);
    }

    public static double a(IBlockAccess world, BlockPosition pos) {
        BlockPosition blockPos = pos.c();
        VoxelShape voxelShape = world.a_(blockPos).k(world, blockPos);
        return (double)blockPos.v() + (voxelShape.b() ? 0.0 : voxelShape.c(EnumDirection.EnumAxis.b));
    }

    protected boolean c() {
        return false;
    }

    @Nullable
    protected PathPoint a(int x2, int y2, int z2, int maxYStep, double prevFeetY, EnumDirection direction, PathType nodeType) {
        PathPoint node = null;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        double d2 = this.a(mutableBlockPos.d(x2, y2, z2));
        if (d2 - prevFeetY > 1.125) {
            return null;
        }
        PathType blockPathTypes = this.a(this.b, x2, y2, z2);
        float f2 = this.b.a(blockPathTypes);
        double e2 = (double)this.b.cT() / 2.0;
        if (f2 >= 0.0f) {
            node = this.a(x2, y2, z2);
            node.l = blockPathTypes;
            node.k = Math.max(node.k, f2);
        }
        if (nodeType == PathType.h && node != null && node.k >= 0.0f && !this.a(node)) {
            node = null;
        }
        if (!(blockPathTypes == PathType.c || this.c() && blockPathTypes == PathType.j)) {
            double h2;
            double g2;
            AxisAlignedBB aABB;
            if ((node == null || node.k < 0.0f) && maxYStep > 0 && blockPathTypes != PathType.h && blockPathTypes != PathType.m && blockPathTypes != PathType.e && blockPathTypes != PathType.f && (node = this.a(x2, y2 + 1, z2, maxYStep - 1, prevFeetY, direction, nodeType)) != null && (node.l == PathType.b || node.l == PathType.c) && this.b.cT() < 1.0f && this.a(aABB = new AxisAlignedBB((g2 = (double)(x2 - direction.i()) + 0.5) - e2, PathfinderNormal.a((IBlockAccess)this.a, (BlockPosition)mutableBlockPos.c(g2, (double)(y2 + 1), h2 = (double)(z2 - direction.k()) + 0.5)) + 0.001, h2 - e2, g2 + e2, (double)this.b.cU() + PathfinderNormal.a((IBlockAccess)this.a, (BlockPosition)mutableBlockPos.c((double)node.a, (double)node.b, (double)node.c)) - 0.002, h2 + e2))) {
                node = null;
            }
            if (!this.c() && blockPathTypes == PathType.j && !this.f()) {
                if (this.a(this.b, x2, y2 - 1, z2) != PathType.j) {
                    return node;
                }
                while (y2 > this.b.s.u_()) {
                    if ((blockPathTypes = this.a(this.b, x2, --y2, z2)) != PathType.j) {
                        return node;
                    }
                    node = this.a(x2, y2, z2);
                    node.l = blockPathTypes;
                    node.k = Math.max(node.k, this.b.a(blockPathTypes));
                }
            }
            if (blockPathTypes == PathType.b) {
                int i2 = 0;
                int j2 = y2;
                while (blockPathTypes == PathType.b) {
                    if (--y2 < this.b.s.u_()) {
                        PathPoint node2 = this.a(x2, j2, z2);
                        node2.l = PathType.a;
                        node2.k = -1.0f;
                        return node2;
                    }
                    if (i2++ >= this.b.cj()) {
                        PathPoint node3 = this.a(x2, y2, z2);
                        node3.l = PathType.a;
                        node3.k = -1.0f;
                        return node3;
                    }
                    blockPathTypes = this.a(this.b, x2, y2, z2);
                    f2 = this.b.a(blockPathTypes);
                    if (blockPathTypes != PathType.b && f2 >= 0.0f) {
                        node = this.a(x2, y2, z2);
                        node.l = blockPathTypes;
                        node.k = Math.max(node.k, f2);
                        break;
                    }
                    if (!(f2 < 0.0f)) continue;
                    PathPoint node4 = this.a(x2, y2, z2);
                    node4.l = PathType.a;
                    node4.k = -1.0f;
                    return node4;
                }
            }
            if (blockPathTypes == PathType.h) {
                node = this.a(x2, y2, z2);
                node.i = true;
                node.l = blockPathTypes;
                node.k = blockPathTypes.a();
            }
            return node;
        }
        return node;
    }

    private boolean a(AxisAlignedBB box) {
        return this.m.computeIfAbsent((Object)box, object -> !this.a.a((Entity)this.b, box));
    }

    @Override
    public PathType a(IBlockAccess world, int x2, int y2, int z2, EntityInsentient mob, int sizeX, int sizeY, int sizeZ, boolean canOpenDoors, boolean canEnterOpenDoors) {
        EnumSet<PathType> enumSet = EnumSet.noneOf(PathType.class);
        PathType blockPathTypes = PathType.a;
        BlockPosition blockPos = mob.cW();
        blockPathTypes = this.a(world, x2, y2, z2, sizeX, sizeY, sizeZ, canOpenDoors, canEnterOpenDoors, enumSet, blockPathTypes, blockPos);
        if (enumSet.contains((Object)PathType.h)) {
            return PathType.h;
        }
        if (enumSet.contains((Object)PathType.m)) {
            return PathType.m;
        }
        PathType blockPathTypes2 = PathType.a;
        for (PathType blockPathTypes3 : enumSet) {
            if (mob.a(blockPathTypes3) < 0.0f) {
                return blockPathTypes3;
            }
            if (!(mob.a(blockPathTypes3) >= mob.a(blockPathTypes2))) continue;
            blockPathTypes2 = blockPathTypes3;
        }
        return blockPathTypes == PathType.b && mob.a(blockPathTypes2) == 0.0f && sizeX <= 1 ? PathType.b : blockPathTypes2;
    }

    public PathType a(IBlockAccess world, int x2, int y2, int z2, int sizeX, int sizeY, int sizeZ, boolean canOpenDoors, boolean canEnterOpenDoors, EnumSet<PathType> nearbyTypes, PathType type, BlockPosition pos) {
        for (int i2 = 0; i2 < sizeX; ++i2) {
            for (int j2 = 0; j2 < sizeY; ++j2) {
                for (int k2 = 0; k2 < sizeZ; ++k2) {
                    int l2 = i2 + x2;
                    int m2 = j2 + y2;
                    int n2 = k2 + z2;
                    PathType blockPathTypes = this.a(world, l2, m2, n2);
                    blockPathTypes = this.a(world, canOpenDoors, canEnterOpenDoors, pos, blockPathTypes);
                    if (i2 == 0 && j2 == 0 && k2 == 0) {
                        type = blockPathTypes;
                    }
                    nearbyTypes.add(blockPathTypes);
                }
            }
        }
        return type;
    }

    protected PathType a(IBlockAccess world, boolean canOpenDoors, boolean canEnterOpenDoors, BlockPosition pos, PathType type) {
        if (type == PathType.u && canOpenDoors && canEnterOpenDoors) {
            type = PathType.d;
        }
        if (type == PathType.t && !canEnterOpenDoors) {
            type = PathType.a;
        }
        if (type == PathType.l && !(world.a_(pos).b() instanceof BlockMinecartTrackAbstract) && !(world.a_(pos.c()).b() instanceof BlockMinecartTrackAbstract)) {
            type = PathType.m;
        }
        if (type == PathType.x) {
            type = PathType.a;
        }
        return type;
    }

    private PathType a(EntityInsentient entity, BlockPosition pos) {
        return this.a(entity, pos.u(), pos.v(), pos.w());
    }

    protected PathType a(EntityInsentient entity, int x2, int y2, int z2) {
        return (PathType)((Object)this.l.computeIfAbsent(BlockPosition.a(x2, y2, z2), l2 -> this.a(this.a, x2, y2, z2, entity, this.d, this.e, this.f, this.e(), this.d())));
    }

    @Override
    public PathType a(IBlockAccess world, int x2, int y2, int z2) {
        return PathfinderNormal.a(world, new BlockPosition.MutableBlockPosition(x2, y2, z2));
    }

    public static PathType a(IBlockAccess world, BlockPosition.MutableBlockPosition pos) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        PathType blockPathTypes = PathfinderNormal.b(world, pos);
        if (blockPathTypes == PathType.b && j2 >= world.u_() + 1) {
            PathType blockPathTypes2 = PathfinderNormal.b(world, pos.d(i2, j2 - 1, k2));
            PathType pathType = blockPathTypes = blockPathTypes2 != PathType.c && blockPathTypes2 != PathType.b && blockPathTypes2 != PathType.j && blockPathTypes2 != PathType.i ? PathType.c : PathType.b;
            if (blockPathTypes2 == PathType.o) {
                blockPathTypes = PathType.o;
            }
            if (blockPathTypes2 == PathType.q) {
                blockPathTypes = PathType.q;
            }
            if (blockPathTypes2 == PathType.s) {
                blockPathTypes = PathType.s;
            }
            if (blockPathTypes2 == PathType.y) {
                blockPathTypes = PathType.y;
            }
            if (blockPathTypes2 == PathType.f) {
                blockPathTypes = PathType.g;
            }
        }
        if (blockPathTypes == PathType.c) {
            blockPathTypes = PathfinderNormal.a(world, pos.d(i2, j2, k2), blockPathTypes);
        }
        return blockPathTypes;
    }

    public static PathType a(IBlockAccess world, BlockPosition.MutableBlockPosition pos, PathType nodeType) {
        int i2 = pos.u();
        int j2 = pos.v();
        int k2 = pos.w();
        for (int l2 = -1; l2 <= 1; ++l2) {
            for (int m2 = -1; m2 <= 1; ++m2) {
                for (int n2 = -1; n2 <= 1; ++n2) {
                    if (l2 == 0 && n2 == 0) continue;
                    pos.d(i2 + l2, j2 + m2, k2 + n2);
                    IBlockData blockState = world.getBlockStateIfLoaded(pos);
                    if (blockState == null) {
                        return PathType.a;
                    }
                    if (blockState.a(Blocks.cN)) {
                        return PathType.p;
                    }
                    if (blockState.a(Blocks.mu)) {
                        return PathType.r;
                    }
                    if (PathfinderNormal.a(blockState)) {
                        return PathType.n;
                    }
                    if (!blockState.o().a(TagsFluid.a)) continue;
                    return PathType.k;
                }
            }
        }
        return nodeType;
    }

    protected static PathType b(IBlockAccess world, BlockPosition pos) {
        IBlockData blockState = world.getBlockStateIfLoaded(pos);
        if (blockState == null) {
            return PathType.a;
        }
        Block block = blockState.b();
        Material material = blockState.c();
        if (blockState.g()) {
            return PathType.b;
        }
        if (!(blockState.a(TagsBlock.I) || blockState.a(Blocks.ed) || blockState.a(Blocks.pI))) {
            if (blockState.a(Blocks.oO)) {
                return PathType.f;
            }
            if (blockState.a(Blocks.cN)) {
                return PathType.q;
            }
            if (blockState.a(Blocks.mu)) {
                return PathType.s;
            }
            if (blockState.a(Blocks.ns)) {
                return PathType.y;
            }
            if (blockState.a(Blocks.et)) {
                return PathType.z;
            }
            Fluid fluidState = blockState.o();
            if (fluidState.a(TagsFluid.b)) {
                return PathType.i;
            }
            if (PathfinderNormal.a(blockState)) {
                return PathType.o;
            }
            if (BlockDoor.n(blockState) && !blockState.c(BlockDoor.b).booleanValue()) {
                return PathType.u;
            }
            if (block instanceof BlockDoor && material == Material.K && !blockState.c(BlockDoor.b).booleanValue()) {
                return PathType.v;
            }
            if (block instanceof BlockDoor && blockState.c(BlockDoor.b).booleanValue()) {
                return PathType.t;
            }
            if (block instanceof BlockMinecartTrackAbstract) {
                return PathType.l;
            }
            if (block instanceof BlockLeaves) {
                return PathType.x;
            }
            if (!(blockState.a(TagsBlock.L) || blockState.a(TagsBlock.E) || block instanceof BlockFenceGate && !blockState.c(BlockFenceGate.a).booleanValue())) {
                if (!blockState.a(world, pos, PathMode.a)) {
                    return PathType.a;
                }
                return fluidState.a(TagsFluid.a) ? PathType.j : PathType.b;
            }
            return PathType.h;
        }
        return PathType.e;
    }

    public static boolean a(IBlockData state) {
        return state.a(TagsBlock.aw) || state.a(Blocks.B) || state.a(Blocks.iX) || BlockCampfire.g(state) || state.a(Blocks.em);
    }
}

