/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.material;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.material.FluidTypes;

public abstract class FluidTypeWater
extends FluidTypeFlowing {
    @Override
    public FluidType d() {
        return FluidTypes.b;
    }

    @Override
    public FluidType e() {
        return FluidTypes.c;
    }

    @Override
    public Item a() {
        return Items.nX;
    }

    @Override
    public void a(World world, BlockPosition pos, Fluid state, Random random) {
        if (!state.b() && !state.c(FluidTypeFlowing.a).booleanValue()) {
            if (random.nextInt(64) == 0) {
                world.a((double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, SoundEffects.uF, SoundCategory.e, random.nextFloat() * 0.25f + 0.75f, random.nextFloat() + 0.5f, false);
            }
        } else if (random.nextInt(10) == 0) {
            world.a(Particles.aa, (double)pos.u() + random.nextDouble(), (double)pos.v() + random.nextDouble(), (double)pos.w() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    @Nullable
    public ParticleParam i() {
        return Particles.m;
    }

    @Override
    protected boolean f() {
        return true;
    }

    @Override
    protected void beforeDestroyingBlock(GeneratorAccess world, BlockPosition pos, IBlockData state, BlockPosition source) {
        TileEntity tileentity = state.n() ? world.c_(pos) : null;
        Block.dropResources(state, world, pos, tileentity, source);
    }

    @Override
    protected void a(GeneratorAccess world, BlockPosition pos, IBlockData state) {
        TileEntity blockEntity = state.n() ? world.c_(pos) : null;
        Block.a(state, world, pos, blockEntity);
    }

    @Override
    public int b(IWorldReader world) {
        return 4;
    }

    @Override
    public IBlockData b(Fluid state) {
        return (IBlockData)Blocks.A.n().a(BlockFluids.a, FluidTypeWater.e(state));
    }

    @Override
    public boolean a(FluidType fluid) {
        return fluid == FluidTypes.c || fluid == FluidTypes.b;
    }

    @Override
    public int c(IWorldReader world) {
        return 1;
    }

    @Override
    public int a(IWorldReader world) {
        return 5;
    }

    @Override
    public boolean a(Fluid state, IBlockAccess world, BlockPosition pos, FluidType fluid, EnumDirection direction) {
        return direction == EnumDirection.a && !fluid.a(TagsFluid.a);
    }

    @Override
    protected float c() {
        return 100.0f;
    }

    @Override
    public Optional<SoundEffect> k() {
        return Optional.of(SoundEffects.bY);
    }

    public static class b
    extends FluidTypeWater {
        @Override
        public int d(Fluid state) {
            return 8;
        }

        @Override
        public boolean c(Fluid state) {
            return true;
        }
    }

    public static class a
    extends FluidTypeWater {
        @Override
        protected void a(BlockStateList.a<FluidType, Fluid> builder) {
            super.a(builder);
            builder.a(new IBlockState[]{FluidTypeFlowing.b});
        }

        @Override
        public int d(Fluid state) {
            return state.c(FluidTypeFlowing.b);
        }

        @Override
        public boolean c(Fluid state) {
            return false;
        }
    }
}

