/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineGraph;
import net.minecraft.world.level.lighting.LightEngineLayerEventListener;
import net.minecraft.world.level.lighting.LightEngineStorage;
import net.minecraft.world.level.lighting.LightEngineStorageArray;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class LightEngineLayer<M extends LightEngineStorageArray<M>, S extends LightEngineStorage<M>>
extends LightEngineGraph
implements LightEngineLayerEventListener {
    public static final long a = Long.MAX_VALUE;
    private static final EnumDirection[] f = EnumDirection.values();
    protected final ILightAccess b;
    protected final EnumSkyBlock c;
    protected final S d;
    private boolean g;
    protected final BlockPosition.MutableBlockPosition e = new BlockPosition.MutableBlockPosition();
    private static final int h = 2;
    private final long[] i = new long[2];
    private final IBlockAccess[] j = new IBlockAccess[2];

    public LightEngineLayer(ILightAccess chunkProvider, EnumSkyBlock type, S lightStorage) {
        super(16, 256, 8192);
        this.b = chunkProvider;
        this.c = type;
        this.d = lightStorage;
        this.d();
    }

    @Override
    @Override
    protected void f(long id) {
        ((LightEngineStorage)this.d).d();
        if (((LightEngineStorage)this.d).g(SectionPosition.e(id))) {
            super.f(id);
        }
    }

    @Nullable
    private IBlockAccess a(int chunkX, int chunkZ) {
        long l2 = ChunkCoordIntPair.a(chunkX, chunkZ);
        for (int i2 = 0; i2 < 2; ++i2) {
            if (l2 != this.i[i2]) continue;
            return this.j[i2];
        }
        IBlockAccess blockGetter = this.b.c(chunkX, chunkZ);
        for (int j2 = 1; j2 > 0; --j2) {
            this.i[j2] = this.i[j2 - 1];
            this.j[j2] = this.j[j2 - 1];
        }
        this.i[0] = l2;
        this.j[0] = blockGetter;
        return blockGetter;
    }

    private void d() {
        Arrays.fill(this.i, ChunkCoordIntPair.a);
        Arrays.fill(this.j, null);
    }

    protected IBlockData a(long pos, @Nullable MutableInt mutableInt) {
        boolean bl;
        int j2;
        if (pos == Long.MAX_VALUE) {
            if (mutableInt != null) {
                mutableInt.setValue(0);
            }
            return Blocks.a.n();
        }
        int i2 = SectionPosition.a(BlockPosition.a(pos));
        IBlockAccess blockGetter = this.a(i2, j2 = SectionPosition.a(BlockPosition.c(pos)));
        if (blockGetter == null) {
            if (mutableInt != null) {
                mutableInt.setValue(16);
            }
            return Blocks.z.n();
        }
        this.e.f(pos);
        IBlockData blockState = blockGetter.a_(this.e);
        boolean bl2 = bl = blockState.l() && blockState.e();
        if (mutableInt != null) {
            mutableInt.setValue(blockState.b(this.b.o(), (BlockPosition)this.e));
        }
        return bl ? blockState : Blocks.a.n();
    }

    protected VoxelShape a(IBlockData world, long pos, EnumDirection facing) {
        return world.l() ? world.a(this.b.o(), (BlockPosition)this.e.f(pos), facing) : VoxelShapes.a();
    }

    public static int a(IBlockAccess world, IBlockData state1, BlockPosition pos1, IBlockData state2, BlockPosition pos2, EnumDirection direction, int opacity2) {
        VoxelShape voxelShape2;
        boolean bl2;
        boolean bl = state1.l() && state1.e();
        boolean bl3 = bl2 = state2.l() && state2.e();
        if (!bl && !bl2) {
            return opacity2;
        }
        VoxelShape voxelShape = bl ? state1.c(world, pos1) : VoxelShapes.a();
        VoxelShape voxelShape3 = voxelShape2 = bl2 ? state2.c(world, pos2) : VoxelShapes.a();
        if (VoxelShapes.b(voxelShape, voxelShape2, direction)) {
            return 16;
        }
        return opacity2;
    }

    @Override
    @Override
    protected boolean a(long id) {
        return id == Long.MAX_VALUE;
    }

    @Override
    @Override
    protected int a(long id, long excludedId, int maxLevel) {
        return 0;
    }

    @Override
    @Override
    protected int c(long id) {
        if (id == Long.MAX_VALUE) {
            return 0;
        }
        return 15 - ((LightEngineStorage)this.d).i(id);
    }

    protected int a(NibbleArray section, long blockPos) {
        return 15 - section.a(SectionPosition.b(BlockPosition.a(blockPos)), SectionPosition.b(BlockPosition.b(blockPos)), SectionPosition.b(BlockPosition.c(blockPos)));
    }

    @Override
    @Override
    protected void a(long id, int level) {
        ((LightEngineStorage)this.d).b(id, Math.min(15, 15 - level));
    }

    @Override
    @Override
    protected int b(long sourceId, long targetId, int level) {
        return 0;
    }

    @Override
    @Override
    public boolean A_() {
        return this.b() || ((LightEngineGraph)this.d).b() || ((LightEngineStorage)this.d).a();
    }

    @Override
    @Override
    public int a(int i2, boolean doSkylight, boolean skipEdgeLightPropagation) {
        if (!this.g) {
            if (((LightEngineGraph)this.d).b() && (i2 = ((LightEngineGraph)this.d).b(i2)) == 0) {
                return i2;
            }
            ((LightEngineStorage)this.d).a(this, doSkylight, skipEdgeLightPropagation);
        }
        this.g = true;
        if (this.b()) {
            i2 = this.b(i2);
            this.d();
            if (i2 == 0) {
                return i2;
            }
        }
        this.g = false;
        ((LightEngineStorage)this.d).e();
        return i2;
    }

    protected void a(long sectionPos, @Nullable NibbleArray lightArray, boolean nonEdge) {
        ((LightEngineStorage)this.d).a(sectionPos, lightArray, nonEdge);
    }

    @Override
    @Nullable
    @Override
    public NibbleArray a(SectionPosition pos) {
        return ((LightEngineStorage)this.d).h(pos.s());
    }

    @Override
    @Override
    public int b(BlockPosition pos) {
        return ((LightEngineStorage)this.d).d(pos.a());
    }

    public String b(long sectionPos) {
        return "" + ((LightEngineStorage)this.d).c(sectionPos);
    }

    @Override
    @Override
    public void a(BlockPosition pos) {
        long l2 = pos.a();
        this.f(l2);
        for (EnumDirection direction : f) {
            this.f(BlockPosition.a(l2, direction));
        }
    }

    @Override
    @Override
    public void a(BlockPosition pos, int level) {
    }

    @Override
    @Override
    public void a(SectionPosition pos, boolean notReady) {
        ((LightEngineStorage)this.d).d(pos.s(), notReady);
    }

    @Override
    @Override
    public void a(ChunkCoordIntPair pos, boolean retainData) {
        long l2 = SectionPosition.f(SectionPosition.b(pos.c, 0, pos.d));
        ((LightEngineStorage)this.d).b(l2, retainData);
    }

    public void b(ChunkCoordIntPair pos, boolean retainData) {
        long l2 = SectionPosition.f(SectionPosition.b(pos.c, 0, pos.d));
        ((LightEngineStorage)this.d).c(l2, retainData);
    }
}

