/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Codec;
import java.util.stream.IntStream;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseSamplingSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements DensityFunction.c {
    public static final BlendedNoise a = new BlendedNoise(new XoroshiroRandomSource(0L), new NoiseSamplingSettings(1.0, 1.0, 80.0, 160.0), 4, 8);
    public static final Codec<BlendedNoise> e = Codec.unit((Object)a);
    private final NoiseGeneratorOctaves f;
    private final NoiseGeneratorOctaves g;
    private final NoiseGeneratorOctaves h;
    private final double i;
    private final double j;
    private final double k;
    private final double l;
    private final int m;
    private final int n;
    private final double o;

    private BlendedNoise(NoiseGeneratorOctaves lowerInterpolatedNoise, NoiseGeneratorOctaves upperInterpolatedNoise, NoiseGeneratorOctaves interpolationNoise, NoiseSamplingSettings config, int cellWidth, int cellHeight) {
        this.f = lowerInterpolatedNoise;
        this.g = upperInterpolatedNoise;
        this.h = interpolationNoise;
        this.i = 684.412 * config.a();
        this.j = 684.412 * config.b();
        this.k = this.i / config.c();
        this.l = this.j / config.d();
        this.m = cellWidth;
        this.n = cellHeight;
        this.o = lowerInterpolatedNoise.a(this.j);
    }

    public BlendedNoise(RandomSource random, NoiseSamplingSettings config, int cellWidth, int cellHeight) {
        this(NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-7, 0)), config, cellWidth, cellHeight);
    }

    @Override
    @Override
    public double a(DensityFunction.b pos) {
        int i2 = Math.floorDiv(pos.a(), this.m);
        int j2 = Math.floorDiv(pos.b(), this.n);
        int k2 = Math.floorDiv(pos.c(), this.m);
        double d2 = 0.0;
        double e2 = 0.0;
        double f2 = 0.0;
        boolean bl = true;
        double g2 = 1.0;
        for (int l2 = 0; l2 < 8; ++l2) {
            NoiseGeneratorPerlin improvedNoise = this.h.a(l2);
            if (improvedNoise != null) {
                f2 += improvedNoise.a(NoiseGeneratorOctaves.b((double)i2 * this.k * g2), NoiseGeneratorOctaves.b((double)j2 * this.l * g2), NoiseGeneratorOctaves.b((double)k2 * this.k * g2), this.l * g2, (double)j2 * this.l * g2) / g2;
            }
            g2 /= 2.0;
        }
        double h2 = (f2 / 10.0 + 1.0) / 2.0;
        boolean bl2 = h2 >= 1.0;
        boolean bl3 = h2 <= 0.0;
        g2 = 1.0;
        for (int m2 = 0; m2 < 16; ++m2) {
            NoiseGeneratorPerlin improvedNoise3;
            NoiseGeneratorPerlin improvedNoise2;
            double n2 = NoiseGeneratorOctaves.b((double)i2 * this.i * g2);
            double o2 = NoiseGeneratorOctaves.b((double)j2 * this.j * g2);
            double p2 = NoiseGeneratorOctaves.b((double)k2 * this.i * g2);
            double q2 = this.j * g2;
            if (!bl2 && (improvedNoise2 = this.f.a(m2)) != null) {
                d2 += improvedNoise2.a(n2, o2, p2, q2, (double)j2 * q2) / g2;
            }
            if (!bl3 && (improvedNoise3 = this.g.a(m2)) != null) {
                e2 += improvedNoise3.a(n2, o2, p2, q2, (double)j2 * q2) / g2;
            }
            g2 /= 2.0;
        }
        return MathHelper.b(d2 / 512.0, e2 / 512.0, h2) / 128.0;
    }

    @Override
    @Override
    public double a() {
        return -this.b();
    }

    @Override
    @Override
    public double b() {
        return this.o;
    }

    @VisibleForTesting
    public void a(StringBuilder info) {
        info.append("BlendedNoise{minLimitNoise=");
        this.f.a(info);
        info.append(", maxLimitNoise=");
        this.g.a(info);
        info.append(", mainNoise=");
        this.h.a(info);
        info.append(String.format(", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=%d, cellHeight=%d", this.i, this.j, this.k, this.l, this.m, this.n)).append('}');
    }

    @Override
    @Override
    public Codec<? extends DensityFunction> c() {
        return e;
    }
}

