/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import net.minecraft.FileUtils;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.slf4j.Logger;

public class DefinedStructureManager {
    private static final Logger a = LogUtils.getLogger();
    private static final String b = "structures";
    private static final String c = ".nbt";
    private static final String d = ".snbt";
    public final Map<MinecraftKey, Optional<DefinedStructure>> e = Maps.newConcurrentMap();
    private final DataFixer f;
    private IResourceManager g;
    private final Path h;

    public DefinedStructureManager(IResourceManager resourceManager, Convertable.ConversionSession session, DataFixer dataFixer) {
        this.g = resourceManager;
        this.f = dataFixer;
        this.h = session.a(SavedFile.f).normalize();
    }

    public DefinedStructure a(MinecraftKey id) {
        Optional<DefinedStructure> optional = this.b(id);
        if (optional.isPresent()) {
            return optional.get();
        }
        DefinedStructure structureTemplate = new DefinedStructure();
        this.e.put(id, Optional.of(structureTemplate));
        return structureTemplate;
    }

    public Optional<DefinedStructure> b(MinecraftKey id) {
        return this.e.computeIfAbsent(id, identifier -> {
            Optional<DefinedStructure> optional = this.f((MinecraftKey)identifier);
            return optional.isPresent() ? optional : this.e((MinecraftKey)identifier);
        });
    }

    public void a(IResourceManager resourceManager) {
        this.g = resourceManager;
        this.e.clear();
    }

    public Optional<DefinedStructure> e(MinecraftKey id) {
        Optional<DefinedStructure> optional;
        block9: {
            MinecraftKey resourceLocation = new MinecraftKey(id.b(), "structures/" + id.a() + c);
            IResource resource = this.g.getResource(resourceLocation);
            try {
                optional = Optional.of(this.a(resource.b()));
                if (resource == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return Optional.empty();
                }
                catch (Throwable throwable3) {
                    a.error("Couldn't load structure {}: {}", (Object)id, (Object)throwable3.toString());
                    return Optional.empty();
                }
            }
            resource.close();
        }
        return optional;
    }

    public Optional<DefinedStructure> f(MinecraftKey id) {
        Optional<DefinedStructure> optional;
        if (!this.h.toFile().isDirectory()) {
            return Optional.empty();
        }
        Path path = this.b(id, c);
        FileInputStream inputStream = new FileInputStream(path.toFile());
        try {
            optional = Optional.of(this.a(inputStream));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return Optional.empty();
            }
            catch (IOException iOException) {
                a.error("Couldn't load structure from {}", (Object)path, (Object)iOException);
                return Optional.empty();
            }
        }
        ((InputStream)inputStream).close();
        return optional;
    }

    public DefinedStructure a(InputStream structureInputStream) throws IOException {
        NBTTagCompound compoundTag = NBTCompressedStreamTools.a(structureInputStream);
        return this.a(compoundTag);
    }

    public DefinedStructure a(NBTTagCompound nbt) {
        if (!nbt.b("DataVersion", 99)) {
            nbt.a("DataVersion", 500);
        }
        DefinedStructure structureTemplate = new DefinedStructure();
        structureTemplate.b(GameProfileSerializer.a(this.f, DataFixTypes.f, nbt, nbt.h("DataVersion")));
        return structureTemplate;
    }

    public boolean c(MinecraftKey id) {
        Optional<DefinedStructure> optional = this.e.get(id);
        if (!optional.isPresent()) {
            return false;
        }
        DefinedStructure structureTemplate = optional.get();
        Path path = this.b(id, c);
        Path path2 = path.getParent();
        if (path2 == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(path2, new LinkOption[0]) ? path2.toRealPath(new LinkOption[0]) : path2, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            a.error("Failed to create parent directory: {}", (Object)path2);
            return false;
        }
        NBTTagCompound compoundTag = structureTemplate.a(new NBTTagCompound());
        try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
            NBTCompressedStreamTools.a(compoundTag, outputStream);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public Path a(MinecraftKey id, String extension) {
        try {
            Path path = this.h.resolve(id.b());
            Path path2 = path.resolve(b);
            return FileUtils.b(path2, id.a(), extension);
        }
        catch (InvalidPathException invalidPathException) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + id, invalidPathException);
        }
    }

    public Path b(MinecraftKey id, String extension) {
        if (id.a().contains("//")) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + id);
        }
        Path path = this.a(id, extension);
        if (!(path.startsWith(this.h) && FileUtils.a(path) && FileUtils.b(path))) {
            throw new ResourceKeyInvalidException("Invalid resource path: " + path);
        }
        return path;
    }

    public void d(MinecraftKey id) {
        this.e.remove(id);
    }
}

