/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorJigsawReplacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;

public class WorldGenFeatureDefinedStructurePoolSingle
extends WorldGenFeatureDefinedStructurePoolStructure {
    private static final Codec<Either<MinecraftKey, DefinedStructure>> a = Codec.of(WorldGenFeatureDefinedStructurePoolSingle::a, (Decoder)MinecraftKey.a.map(Either::left));
    public static final Codec<WorldGenFeatureDefinedStructurePoolSingle> b = RecordCodecBuilder.create(instance -> instance.group(WorldGenFeatureDefinedStructurePoolSingle.c(), WorldGenFeatureDefinedStructurePoolSingle.b(), WorldGenFeatureDefinedStructurePoolSingle.d()).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolSingle::new));
    protected final Either<MinecraftKey, DefinedStructure> c;
    protected final Holder<ProcessorList> d;

    private static <T> DataResult<T> a(Either<MinecraftKey, DefinedStructure> either, DynamicOps<T> dynamicOps, T object) {
        Optional<MinecraftKey> optional = either.left();
        if (!optional.isPresent()) {
            return DataResult.error((String)"Can not serialize a runtime pool element");
        }
        return MinecraftKey.a.encode((Object)optional.get(), dynamicOps, object);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Holder<ProcessorList>> b() {
        return DefinedStructureStructureProcessorType.n.fieldOf("processors").forGetter(singlePoolElement -> singlePoolElement.d);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Either<MinecraftKey, DefinedStructure>> c() {
        return a.fieldOf("location").forGetter(singlePoolElement -> singlePoolElement.c);
    }

    protected WorldGenFeatureDefinedStructurePoolSingle(Either<MinecraftKey, DefinedStructure> location, Holder<ProcessorList> holder, WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super(projection);
        this.c = location;
        this.d = holder;
    }

    public WorldGenFeatureDefinedStructurePoolSingle(DefinedStructure structure) {
        this(Either.right(structure), ProcessorLists.a, WorldGenFeatureDefinedStructurePoolTemplate.Matching.b);
    }

    @Override
    @Override
    public BaseBlockPosition a(DefinedStructureManager structureManager, EnumBlockRotation rotation) {
        DefinedStructure structureTemplate = this.a(structureManager);
        return structureTemplate.a(rotation);
    }

    private DefinedStructure a(DefinedStructureManager structureManager) {
        return this.c.map(structureManager::a, Function.identity());
    }

    public List<DefinedStructure.BlockInfo> a(DefinedStructureManager structureManager, BlockPosition pos, EnumBlockRotation rotation, boolean mirroredAndRotated) {
        DefinedStructure structureTemplate = this.a(structureManager);
        List<DefinedStructure.BlockInfo> list = structureTemplate.a(pos, new DefinedStructureInfo().a(rotation), Blocks.nm, mirroredAndRotated);
        ArrayList list2 = Lists.newArrayList();
        for (DefinedStructure.BlockInfo structureBlockInfo : list) {
            BlockPropertyStructureMode structureMode;
            if (structureBlockInfo.c == null || (structureMode = BlockPropertyStructureMode.valueOf(structureBlockInfo.c.l("mode"))) != BlockPropertyStructureMode.d) continue;
            list2.add(structureBlockInfo);
        }
        return list2;
    }

    @Override
    @Override
    public List<DefinedStructure.BlockInfo> a(DefinedStructureManager structureManager, BlockPosition pos, EnumBlockRotation rotation, Random random) {
        DefinedStructure structureTemplate = this.a(structureManager);
        List<DefinedStructure.BlockInfo> list = structureTemplate.a(pos, new DefinedStructureInfo().a(rotation), Blocks.nn, true);
        Collections.shuffle(list, random);
        return list;
    }

    @Override
    @Override
    public StructureBoundingBox a(DefinedStructureManager structureManager, BlockPosition pos, EnumBlockRotation rotation) {
        DefinedStructure structureTemplate = this.a(structureManager);
        return structureTemplate.b(new DefinedStructureInfo().a(rotation), pos);
    }

    @Override
    @Override
    public boolean a(DefinedStructureManager structureManager, GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, BlockPosition pos, BlockPosition blockPos, EnumBlockRotation rotation, StructureBoundingBox box, Random random, boolean keepJigsaws) {
        DefinedStructureInfo structurePlaceSettings;
        DefinedStructure structureTemplate = this.a(structureManager);
        if (structureTemplate.a(world, pos, blockPos, structurePlaceSettings = this.a(rotation, box, keepJigsaws), random, 18)) {
            List<DefinedStructure.BlockInfo> list = DefinedStructure.a(world, pos, blockPos, structurePlaceSettings, this.a(structureManager, pos, rotation, false));
            for (DefinedStructure.BlockInfo structureBlockInfo : list) {
                this.a(world, structureBlockInfo, pos, rotation, random, box);
            }
            return true;
        }
        return false;
    }

    protected DefinedStructureInfo a(EnumBlockRotation rotation, StructureBoundingBox box, boolean keepJigsaws) {
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo();
        structurePlaceSettings.a(box);
        structurePlaceSettings.a(rotation);
        structurePlaceSettings.c(true);
        structurePlaceSettings.a(false);
        structurePlaceSettings.a(DefinedStructureProcessorBlockIgnore.b);
        structurePlaceSettings.d(true);
        if (!keepJigsaws) {
            structurePlaceSettings.a(DefinedStructureProcessorJigsawReplacement.b);
        }
        this.d.a().a().forEach(structurePlaceSettings::a);
        this.e().b().forEach(structurePlaceSettings::a);
        return structurePlaceSettings;
    }

    @Override
    @Override
    public WorldGenFeatureDefinedStructurePools<?> a() {
        return WorldGenFeatureDefinedStructurePools.a;
    }

    @Override
    public String toString() {
        return "Single[" + this.c + "]";
    }
}

