/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

public class WorldGenFeatureDefinedStructurePoolList
extends WorldGenFeatureDefinedStructurePoolStructure {
    public static final Codec<WorldGenFeatureDefinedStructurePoolList> a = RecordCodecBuilder.create(instance -> instance.group((App)WorldGenFeatureDefinedStructurePoolStructure.e.listOf().fieldOf("elements").forGetter(listPoolElement -> listPoolElement.b), WorldGenFeatureDefinedStructurePoolList.d()).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolList::new));
    private final List<WorldGenFeatureDefinedStructurePoolStructure> b;

    public WorldGenFeatureDefinedStructurePoolList(List<WorldGenFeatureDefinedStructurePoolStructure> elements, WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super(projection);
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("Elements are empty");
        }
        this.b = elements;
        this.b(projection);
    }

    @Override
    @Override
    public BaseBlockPosition a(DefinedStructureManager structureManager, EnumBlockRotation rotation) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        for (WorldGenFeatureDefinedStructurePoolStructure structurePoolElement : this.b) {
            BaseBlockPosition vec3i = structurePoolElement.a(structureManager, rotation);
            i2 = Math.max(i2, vec3i.u());
            j2 = Math.max(j2, vec3i.v());
            k2 = Math.max(k2, vec3i.w());
        }
        return new BaseBlockPosition(i2, j2, k2);
    }

    @Override
    @Override
    public List<DefinedStructure.BlockInfo> a(DefinedStructureManager structureManager, BlockPosition pos, EnumBlockRotation rotation, Random random) {
        return this.b.get(0).a(structureManager, pos, rotation, random);
    }

    @Override
    @Override
    public StructureBoundingBox a(DefinedStructureManager structureManager, BlockPosition pos, EnumBlockRotation rotation) {
        Stream<StructureBoundingBox> stream = this.b.stream().filter(element -> element != WorldGenFeatureDefinedStructurePoolEmpty.b).map(element -> element.a(structureManager, pos, rotation));
        return StructureBoundingBox.b(stream::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox for ListPoolElement"));
    }

    @Override
    @Override
    public boolean a(DefinedStructureManager structureManager, GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, BlockPosition pos, BlockPosition blockPos, EnumBlockRotation rotation, StructureBoundingBox box, Random random, boolean keepJigsaws) {
        for (WorldGenFeatureDefinedStructurePoolStructure structurePoolElement : this.b) {
            if (structurePoolElement.a(structureManager, world, structureAccessor, chunkGenerator, pos, blockPos, rotation, box, random, keepJigsaws)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Override
    public WorldGenFeatureDefinedStructurePools<?> a() {
        return WorldGenFeatureDefinedStructurePools.b;
    }

    @Override
    @Override
    public WorldGenFeatureDefinedStructurePoolStructure a(WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        super.a(projection);
        this.b(projection);
        return this;
    }

    @Override
    public String toString() {
        return "List[" + this.b.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private void b(WorldGenFeatureDefinedStructurePoolTemplate.Matching projection) {
        this.b.forEach(element -> element.a(projection));
    }
}

