/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.StructureGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureVillageConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger a = LogUtils.getLogger();

    public static Optional<PieceGenerator<WorldGenFeatureVillageConfiguration>> a(PieceGeneratorSupplier.a<WorldGenFeatureVillageConfiguration> context2, a pieceFactory, BlockPosition pos, boolean bl, boolean bl2) {
        int l2;
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.c(context2.c(), context2.d().c, context2.d().d);
        IRegistryCustom registryAccess = context2.i();
        WorldGenFeatureVillageConfiguration jigsawConfiguration = context2.e();
        ChunkGenerator chunkGenerator = context2.a();
        DefinedStructureManager structureManager = context2.h();
        LevelHeightAccessor levelHeightAccessor = context2.f();
        Predicate<Holder<BiomeBase>> predicate = context2.g();
        StructureGenerator.b();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry = registryAccess.d(IRegistry.aO);
        EnumBlockRotation rotation = EnumBlockRotation.a(worldgenRandom);
        WorldGenFeatureDefinedStructurePoolTemplate structureTemplatePool = jigsawConfiguration.b().a();
        WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = structureTemplatePool.a(worldgenRandom);
        if (structurePoolElement == WorldGenFeatureDefinedStructurePoolEmpty.b) {
            return Optional.empty();
        }
        WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = pieceFactory.create(structureManager, structurePoolElement, pos, structurePoolElement.f(), rotation, structurePoolElement.a(structureManager, pos, rotation));
        StructureBoundingBox boundingBox = poolElementStructurePiece.f();
        int i2 = (boundingBox.j() + boundingBox.g()) / 2;
        int j2 = (boundingBox.l() + boundingBox.i()) / 2;
        if (bl2) {
            int k2 = pos.v() + chunkGenerator.b(i2, j2, HeightMap.Type.a, levelHeightAccessor);
        } else {
            l2 = pos.v();
        }
        if (!predicate.test(chunkGenerator.getNoiseBiome(QuartPos.a(i2), QuartPos.a(l2), QuartPos.a(j2)))) {
            return Optional.empty();
        }
        int m2 = boundingBox.h() + poolElementStructurePiece.d();
        poolElementStructurePiece.a(0, l2 - m2, 0);
        return Optional.of((structurePiecesBuilder, context) -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolElementStructurePiece);
            if (jigsawConfiguration.a() <= 0) {
                return;
            }
            int l2 = 80;
            AxisAlignedBB aABB = new AxisAlignedBB(i2 - 80, l2 - 80, j2 - 80, i2 + 80 + 1, l2 + 80 + 1, j2 + 80 + 1);
            c placer = new c(registry, jigsawConfiguration.a(), pieceFactory, chunkGenerator, structureManager, list, worldgenRandom);
            placer.h.addLast(new b(poolElementStructurePiece, (MutableObject<VoxelShape>)new MutableObject((Object)VoxelShapes.a(VoxelShapes.a(aABB), VoxelShapes.a(AxisAlignedBB.a(boundingBox)), OperatorBoolean.e)), 0));
            while (!placer.h.isEmpty()) {
                b pieceState = placer.h.removeFirst();
                placer.a(pieceState.a, pieceState.b, pieceState.c, bl, levelHeightAccessor);
            }
            list.forEach(structurePiecesBuilder::a);
        });
    }

    public static void a(IRegistryCustom registryManager, WorldGenFeaturePillagerOutpostPoolPiece piece, int maxDepth, a pieceFactory, ChunkGenerator chunkGenerator, DefinedStructureManager structureManager, List<? super WorldGenFeaturePillagerOutpostPoolPiece> results, Random random, LevelHeightAccessor world) {
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry = registryManager.d(IRegistry.aO);
        c placer = new c(registry, maxDepth, pieceFactory, chunkGenerator, structureManager, results, random);
        placer.h.addLast(new b(piece, (MutableObject<VoxelShape>)new MutableObject((Object)VoxelShapes.c), 0));
        while (!placer.h.isEmpty()) {
            b pieceState = placer.h.removeFirst();
            placer.a(pieceState.a, pieceState.b, pieceState.c, false, world);
        }
    }

    public static interface a {
        public WorldGenFeaturePillagerOutpostPoolPiece create(DefinedStructureManager var1, WorldGenFeatureDefinedStructurePoolStructure var2, BlockPosition var3, int var4, EnumBlockRotation var5, StructureBoundingBox var6);
    }

    static final class c {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> a;
        private final int b;
        private final a c;
        private final ChunkGenerator d;
        private final DefinedStructureManager e;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> f;
        private final Random g;
        final Deque<b> h = Queues.newArrayDeque();

        c(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> registry, int maxSize, a pieceFactory, ChunkGenerator chunkGenerator, DefinedStructureManager structureManager, List<? super WorldGenFeaturePillagerOutpostPoolPiece> children, Random random) {
            this.a = registry;
            this.b = maxSize;
            this.c = pieceFactory;
            this.d = chunkGenerator;
            this.e = structureManager;
            this.f = children;
            this.g = random;
        }

        void a(WorldGenFeaturePillagerOutpostPoolPiece piece, MutableObject<VoxelShape> pieceShape, int minY, boolean modifyBoundingBox, LevelHeightAccessor world) {
            WorldGenFeatureDefinedStructurePoolStructure structurePoolElement = piece.b();
            BlockPosition blockPos = piece.c();
            EnumBlockRotation rotation = piece.ad_();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection = structurePoolElement.e();
            boolean bl = projection == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
            MutableObject mutableObject = new MutableObject();
            StructureBoundingBox boundingBox = piece.f();
            int i2 = boundingBox.h();
            block0: for (DefinedStructure.BlockInfo structureBlockInfo2 : structurePoolElement.a(this.e, blockPos, rotation, this.g)) {
                WorldGenFeatureDefinedStructurePoolStructure structurePoolElement2;
                MutableObject<VoxelShape> mutableObject3;
                EnumDirection direction = BlockJigsaw.h(structureBlockInfo2.b);
                BlockPosition blockPos2 = structureBlockInfo2.a;
                BlockPosition blockPos3 = blockPos2.a(direction);
                int j2 = blockPos2.v() - i2;
                int k2 = -1;
                MinecraftKey resourceLocation = new MinecraftKey(structureBlockInfo2.c.l("pool"));
                Optional<WorldGenFeatureDefinedStructurePoolTemplate> optional = this.a.b(resourceLocation);
                if (!optional.isPresent() || optional.get().c() == 0 && !Objects.equals(resourceLocation, WorldGenFeaturePieces.a.a())) {
                    a.warn("Empty or non-existent pool: {}", (Object)resourceLocation);
                    continue;
                }
                MinecraftKey resourceLocation2 = optional.get().a();
                Optional<WorldGenFeatureDefinedStructurePoolTemplate> optional2 = this.a.b(resourceLocation2);
                if (!optional2.isPresent() || optional2.get().c() == 0 && !Objects.equals(resourceLocation2, WorldGenFeaturePieces.a.a())) {
                    a.warn("Empty or non-existent fallback pool: {}", (Object)resourceLocation2);
                    continue;
                }
                boolean bl2 = boundingBox.b(blockPos3);
                if (bl2) {
                    MutableObject mutableObject2 = mutableObject;
                    if (mutableObject.getValue() == null) {
                        mutableObject.setValue((Object)VoxelShapes.a(AxisAlignedBB.a(boundingBox)));
                    }
                } else {
                    mutableObject3 = pieceShape;
                }
                ArrayList list = Lists.newArrayList();
                if (minY != this.b) {
                    list.addAll(optional.get().b(this.g));
                }
                list.addAll(optional2.get().b(this.g));
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && (structurePoolElement2 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.b) {
                    for (EnumBlockRotation rotation2 : EnumBlockRotation.b(this.g)) {
                        int m2;
                        List<DefinedStructure.BlockInfo> list2 = structurePoolElement2.a(this.e, BlockPosition.b, rotation2, this.g);
                        StructureBoundingBox boundingBox2 = structurePoolElement2.a(this.e, BlockPosition.b, rotation2);
                        if (!modifyBoundingBox || boundingBox2.d() > 16) {
                            boolean l2 = false;
                        } else {
                            m2 = list2.stream().mapToInt(structureBlockInfo -> {
                                if (!boundingBox2.b(structureBlockInfo.a.a(BlockJigsaw.h(structureBlockInfo.b)))) {
                                    return 0;
                                }
                                MinecraftKey resourceLocation = new MinecraftKey(structureBlockInfo.c.l("pool"));
                                Optional<WorldGenFeatureDefinedStructurePoolTemplate> optional = this.a.b(resourceLocation);
                                Optional<Integer> optional2 = optional.flatMap(pool -> this.a.b(pool.a()));
                                int i2 = optional.map(pool -> pool.a(this.e)).orElse(0);
                                int j2 = optional2.map(pool -> pool.a(this.e)).orElse(0);
                                return Math.max(i2, j2);
                            }).max().orElse(0);
                        }
                        for (DefinedStructure.BlockInfo structureBlockInfo22 : list2) {
                            int z2;
                            int w2;
                            int r2;
                            if (!BlockJigsaw.a(structureBlockInfo2, structureBlockInfo22)) continue;
                            BlockPosition blockPos4 = structureBlockInfo22.a;
                            BlockPosition blockPos5 = blockPos3.b(blockPos4);
                            StructureBoundingBox boundingBox3 = structurePoolElement2.a(this.e, blockPos5, rotation2);
                            int n2 = boundingBox3.h();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching projection2 = structurePoolElement2.e();
                            boolean bl3 = projection2 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b;
                            int o2 = blockPos4.v();
                            int p2 = j2 - o2 + BlockJigsaw.h(structureBlockInfo2.b).j();
                            if (bl && bl3) {
                                int q2 = i2 + p2;
                            } else {
                                if (k2 == -1) {
                                    k2 = this.d.b(blockPos2.u(), blockPos2.w(), HeightMap.Type.a, world);
                                }
                                r2 = k2 - o2;
                            }
                            int s2 = r2 - n2;
                            StructureBoundingBox boundingBox4 = boundingBox3.b(0, s2, 0);
                            BlockPosition blockPos6 = blockPos5.b(0, s2, 0);
                            if (m2 > 0) {
                                int t2 = Math.max(m2 + 1, boundingBox4.k() - boundingBox4.h());
                                boundingBox4.a(new BlockPosition(boundingBox4.g(), boundingBox4.h() + t2, boundingBox4.i()));
                            }
                            if (VoxelShapes.c((VoxelShape)mutableObject3.getValue(), VoxelShapes.a(AxisAlignedBB.a(boundingBox4).h(0.25)), OperatorBoolean.c)) continue;
                            mutableObject3.setValue((Object)VoxelShapes.b((VoxelShape)mutableObject3.getValue(), VoxelShapes.a(AxisAlignedBB.a(boundingBox4)), OperatorBoolean.e));
                            int u2 = piece.d();
                            if (bl3) {
                                int v2 = u2 - p2;
                            } else {
                                w2 = structurePoolElement2.f();
                            }
                            WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = this.c.create(this.e, structurePoolElement2, blockPos6, w2, rotation2, boundingBox4);
                            if (bl) {
                                int x2 = i2 + j2;
                            } else if (bl3) {
                                int y2 = r2 + o2;
                            } else {
                                if (k2 == -1) {
                                    k2 = this.d.b(blockPos2.u(), blockPos2.w(), HeightMap.Type.a, world);
                                }
                                z2 = k2 + p2 / 2;
                            }
                            piece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos3.u(), (int)(z2 - j2 + u2), blockPos3.w(), p2, projection2));
                            poolElementStructurePiece.a(new WorldGenFeatureDefinedStructureJigsawJunction(blockPos2.u(), z2 - o2 + w2, blockPos2.w(), -p2, projection));
                            this.f.add(poolElementStructurePiece);
                            if (minY + 1 > this.b) continue block0;
                            this.h.addLast(new b(poolElementStructurePiece, mutableObject3, minY + 1));
                            continue block0;
                        }
                    }
                }
            }
        }
    }

    static final class b {
        final WorldGenFeaturePillagerOutpostPoolPiece a;
        final MutableObject<VoxelShape> b;
        final int c;

        b(WorldGenFeaturePillagerOutpostPoolPiece piece, MutableObject<VoxelShape> pieceShape, int currentSize) {
            this.a = piece;
            this.b = pieceShape;
            this.c = currentSize;
        }
    }
}

