/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public final class RandomSpreadStructurePlacement
extends Record
implements StructurePlacement {
    private final int c;
    private final int d;
    private final RandomSpreadType e;
    private final int f;
    private final BaseBlockPosition g;
    public static final Codec<RandomSpreadStructurePlacement> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::b), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::c), (App)RandomSpreadType.c.optionalFieldOf("spread_type", (Object)RandomSpreadType.a).forGetter(RandomSpreadStructurePlacement::d), (App)ExtraCodecs.a.fieldOf("salt").forGetter(RandomSpreadStructurePlacement::e), (App)BaseBlockPosition.v(16).optionalFieldOf("locate_offset", (Object)BaseBlockPosition.g).forGetter(RandomSpreadStructurePlacement::f)).apply((Applicative)instance, RandomSpreadStructurePlacement::new)).flatXmap(placement -> {
        if (placement.c <= placement.d) {
            return DataResult.error((String)"Spacing has to be larger than separation");
        }
        return DataResult.success((Object)placement);
    }, DataResult::success).codec();

    public RandomSpreadStructurePlacement(int spacing, int separation, RandomSpreadType spreadType, int salt) {
        this(spacing, separation, spreadType, salt, BaseBlockPosition.g);
    }

    public RandomSpreadStructurePlacement(int i2, int j2, RandomSpreadType randomSpreadType, int k2, BaseBlockPosition vec3i) {
        this.c = i2;
        this.d = j2;
        this.e = randomSpreadType;
        this.f = k2;
        this.g = vec3i;
    }

    public ChunkCoordIntPair a(long seed, int x2, int z2) {
        int i2 = this.b();
        int j2 = this.c();
        int k2 = Math.floorDiv(x2, i2);
        int l2 = Math.floorDiv(z2, i2);
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.a(seed, k2, l2, this.e());
        int m2 = i2 - j2;
        int n2 = this.d().a(worldgenRandom, m2);
        int o2 = this.d().a(worldgenRandom, m2);
        return new ChunkCoordIntPair(k2 * i2 + n2, l2 * i2 + o2);
    }

    @Override
    @Override
    public boolean a(ChunkGenerator chunkGenerator, long l2, int i2, int j2) {
        ChunkCoordIntPair chunkPos = this.a(l2, i2, j2);
        return chunkPos.c == i2 && chunkPos.d == j2;
    }

    @Override
    @Override
    public StructurePlacementType<?> a() {
        return StructurePlacementType.a;
    }

    @Override
    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{RandomSpreadStructurePlacement.class, "spacing;separation;spreadType;salt;locateOffset", "c", "d", "e", "f", "g"}, this);
    }

    @Override
    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{RandomSpreadStructurePlacement.class, "spacing;separation;spreadType;salt;locateOffset", "c", "d", "e", "f", "g"}, this);
    }

    @Override
    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{RandomSpreadStructurePlacement.class, "spacing;separation;spreadType;salt;locateOffset", "c", "d", "e", "f", "g"}, this, object);
    }

    public int b() {
        return this.c;
    }

    public int c() {
        return this.d;
    }

    public RandomSpreadType d() {
        return this.e;
    }

    public int e() {
        return this.f;
    }

    public BaseBlockPosition f() {
        return this.g;
    }
}

