/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pieces;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureManager;

@FunctionalInterface
public interface PieceGeneratorSupplier<C extends WorldGenFeatureConfiguration> {
    public Optional<PieceGenerator<C>> createGenerator(a<C> var1);

    public static <C extends WorldGenFeatureConfiguration> PieceGeneratorSupplier<C> simple(Predicate<a<C>> predicate, PieceGenerator<C> generator) {
        Optional optional = Optional.of(generator);
        return context -> predicate.test(context) ? optional : Optional.empty();
    }

    public static <C extends WorldGenFeatureConfiguration> Predicate<a<C>> checkForBiomeOnTop(HeightMap.Type heightmapType) {
        return context -> context.a(heightmapType);
    }

    public record a<C extends WorldGenFeatureConfiguration>(ChunkGenerator a, WorldChunkManager b, long c, ChunkCoordIntPair d, C e, LevelHeightAccessor f, Predicate<Holder<BiomeBase>> g, DefinedStructureManager h, IRegistryCustom i) {
        public boolean a(HeightMap.Type heightmapType) {
            int i2 = this.d.b();
            int j2 = this.d.c();
            int k2 = this.a.c(i2, j2, heightmapType, this.f);
            Holder<BiomeBase> holder = this.a.getNoiseBiome(QuartPos.a(i2), QuartPos.a(k2), QuartPos.a(j2));
            return this.g.test(holder);
        }

        public int[] a(int x2, int width, int z2, int height) {
            return new int[]{this.a.c(x2, z2, HeightMap.Type.a, this.f), this.a.c(x2, z2 + height, HeightMap.Type.a, this.f), this.a.c(x2 + width, z2, HeightMap.Type.a, this.f), this.a.c(x2 + width, z2 + height, HeightMap.Type.a, this.f)};
        }

        public int a(int width, int height) {
            int i2 = this.d.d();
            int j2 = this.d.e();
            int[] is = this.a(i2, width, j2, height);
            return Math.min(Math.min(is[0], is[1]), Math.min(is[2], is[3]));
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunkGenerator;biomeSource;seed;chunkPos;config;heightAccessor;validBiome;structureManager;registryAccess", "a", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunkGenerator;biomeSource;seed;chunkPos;config;heightAccessor;validBiome;structureManager;registryAccess", "a", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunkGenerator;biomeSource;seed;chunkPos;config;heightAccessor;validBiome;structureManager;registryAccess", "a", "b", "c", "d", "e", "f", "g", "h", "i"}, this, object);
        }
    }
}

