/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockEnderPortalFrame;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockLadder;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.storage.loot.LootTables;

public class WorldGenStrongholdPieces {
    private static final int b = 3;
    private static final int c = 3;
    private static final int d = 50;
    private static final int e = 10;
    private static final boolean f = true;
    public static final int a = 64;
    private static final WorldGenStrongholdPieceWeight[] g = new WorldGenStrongholdPieceWeight[]{new WorldGenStrongholdPieceWeight(WorldGenStrongholdStairs.class, 40, 0), new WorldGenStrongholdPieceWeight(WorldGenStrongholdPrison.class, 5, 5), new WorldGenStrongholdPieceWeight(WorldGenStrongholdLeftTurn.class, 20, 0), new WorldGenStrongholdPieceWeight(WorldGenStrongholdRightTurn.class, 20, 0), new WorldGenStrongholdPieceWeight(WorldGenStrongholdRoomCrossing.class, 10, 6), new WorldGenStrongholdPieceWeight(WorldGenStrongholdStairsStraight.class, 5, 5), new WorldGenStrongholdPieceWeight(WorldGenStrongholdStairs2.class, 5, 5), new WorldGenStrongholdPieceWeight(WorldGenStrongholdCrossing.class, 5, 4), new WorldGenStrongholdPieceWeight(WorldGenStrongholdChestCorridor.class, 5, 4), new WorldGenStrongholdPieceWeight(WorldGenStrongholdLibrary.class, 10, 2){

        @Override
        @Override
        public boolean a(int chainLength) {
            return super.a(chainLength) && chainLength > 4;
        }
    }, new WorldGenStrongholdPieceWeight(WorldGenStrongholdPortalRoom.class, 20, 1){

        @Override
        @Override
        public boolean a(int chainLength) {
            return super.a(chainLength) && chainLength > 5;
        }
    }};
    private static List<WorldGenStrongholdPieceWeight> h;
    static Class<? extends WorldGenStrongholdPiece> i;
    private static int j;
    static final WorldGenStrongholdStones k;

    public static void a() {
        h = Lists.newArrayList();
        for (WorldGenStrongholdPieceWeight pieceWeight : g) {
            pieceWeight.c = 0;
            h.add(pieceWeight);
        }
        i = null;
    }

    private static boolean b() {
        boolean bl = false;
        j = 0;
        for (WorldGenStrongholdPieceWeight pieceWeight : h) {
            if (pieceWeight.d > 0 && pieceWeight.c < pieceWeight.d) {
                bl = true;
            }
            j += pieceWeight.b;
        }
        return bl;
    }

    private static WorldGenStrongholdPiece a(Class<? extends WorldGenStrongholdPiece> pieceType, StructurePieceAccessor holder, Random random, int x2, int y2, int z2, @Nullable EnumDirection orientation, int chainLength) {
        WorldGenStrongholdPiece strongholdPiece = null;
        if (pieceType == WorldGenStrongholdStairs.class) {
            strongholdPiece = WorldGenStrongholdStairs.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdPrison.class) {
            strongholdPiece = WorldGenStrongholdPrison.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdLeftTurn.class) {
            strongholdPiece = WorldGenStrongholdLeftTurn.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdRightTurn.class) {
            strongholdPiece = WorldGenStrongholdRightTurn.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdRoomCrossing.class) {
            strongholdPiece = WorldGenStrongholdRoomCrossing.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdStairsStraight.class) {
            strongholdPiece = WorldGenStrongholdStairsStraight.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdStairs2.class) {
            strongholdPiece = WorldGenStrongholdStairs2.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdCrossing.class) {
            strongholdPiece = WorldGenStrongholdCrossing.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdChestCorridor.class) {
            strongholdPiece = WorldGenStrongholdChestCorridor.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdLibrary.class) {
            strongholdPiece = WorldGenStrongholdLibrary.a(holder, random, x2, y2, z2, orientation, chainLength);
        } else if (pieceType == WorldGenStrongholdPortalRoom.class) {
            strongholdPiece = WorldGenStrongholdPortalRoom.a(holder, x2, y2, z2, orientation, chainLength);
        }
        return strongholdPiece;
    }

    private static WorldGenStrongholdPiece a(WorldGenStrongholdStart start, StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
        if (!WorldGenStrongholdPieces.b()) {
            return null;
        }
        if (i != null) {
            WorldGenStrongholdPiece strongholdPiece = WorldGenStrongholdPieces.a(i, holder, random, x2, y2, z2, orientation, chainLength);
            i = null;
            if (strongholdPiece != null) {
                return strongholdPiece;
            }
        }
        int i2 = 0;
        block0: while (i2 < 5) {
            ++i2;
            int j2 = random.nextInt(j);
            for (WorldGenStrongholdPieceWeight pieceWeight : h) {
                if ((j2 -= pieceWeight.b) >= 0) continue;
                if (!pieceWeight.a(chainLength) || pieceWeight == start.a) continue block0;
                WorldGenStrongholdPiece strongholdPiece2 = WorldGenStrongholdPieces.a(pieceWeight.a, holder, random, x2, y2, z2, orientation, chainLength);
                if (strongholdPiece2 == null) continue;
                ++pieceWeight.c;
                start.a = pieceWeight;
                if (!pieceWeight.a()) {
                    h.remove(pieceWeight);
                }
                return strongholdPiece2;
            }
        }
        StructureBoundingBox boundingBox = WorldGenStrongholdCorridor.a(holder, random, x2, y2, z2, orientation);
        if (boundingBox != null && boundingBox.h() > 1) {
            return new WorldGenStrongholdCorridor(chainLength, boundingBox, orientation);
        }
        return null;
    }

    static StructurePiece b(WorldGenStrongholdStart start, StructurePieceAccessor holder, Random random, int x2, int y2, int z2, @Nullable EnumDirection orientation, int chainLength) {
        if (chainLength > 50) {
            return null;
        }
        if (Math.abs(x2 - start.f().g()) > 112 || Math.abs(z2 - start.f().i()) > 112) {
            return null;
        }
        WorldGenStrongholdPiece structurePiece = WorldGenStrongholdPieces.a(start, holder, random, x2, y2, z2, orientation, chainLength + 1);
        if (structurePiece != null) {
            holder.a(structurePiece);
            start.c.add(structurePiece);
        }
        return structurePiece;
    }

    static {
        k = new WorldGenStrongholdStones();
    }

    static class WorldGenStrongholdPieceWeight {
        public final Class<? extends WorldGenStrongholdPiece> a;
        public final int b;
        public int c;
        public final int d;

        public WorldGenStrongholdPieceWeight(Class<? extends WorldGenStrongholdPiece> pieceType, int weight, int limit) {
            this.a = pieceType;
            this.b = weight;
            this.d = limit;
        }

        public boolean a(int chainLength) {
            return this.d == 0 || this.c < this.d;
        }

        public boolean a() {
            return this.d == 0 || this.c < this.d;
        }
    }

    public static class WorldGenStrongholdStairs
    extends WorldGenStrongholdPiece {
        private static final int a = 5;
        private static final int b = 5;
        private static final int c = 7;
        private final boolean d;
        private final boolean f;

        public WorldGenStrongholdStairs(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.E, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
            this.d = random.nextInt(2) == 0;
            this.f = random.nextInt(2) == 0;
        }

        public WorldGenStrongholdStairs(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.E, nbt);
            this.d = nbt.q("Left");
            this.f = nbt.q("Right");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Left", this.d);
            nbt.a("Right", this.f);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenStrongholdStart)start, holder, random, 1, 1);
            if (this.d) {
                this.b((WorldGenStrongholdStart)start, holder, random, 1, 2);
            }
            if (this.f) {
                this.c((WorldGenStrongholdStart)start, holder, random, 1, 2);
            }
        }

        public static WorldGenStrongholdStairs a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, 7, orientation);
            if (!WorldGenStrongholdStairs.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdStairs(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 4, 6, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 1, 0);
            this.a(world, random, chunkBox, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.a, 1, 1, 6);
            IBlockData blockState = (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.f);
            IBlockData blockState2 = (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.e);
            this.a(world, chunkBox, random, 0.1f, 1, 2, 1, blockState);
            this.a(world, chunkBox, random, 0.1f, 3, 2, 1, blockState2);
            this.a(world, chunkBox, random, 0.1f, 1, 2, 5, blockState);
            this.a(world, chunkBox, random, 0.1f, 3, 2, 5, blockState2);
            if (this.d) {
                this.a(world, chunkBox, 0, 1, 2, 0, 3, 4, StructurePiece.z, StructurePiece.z, false);
            }
            if (this.f) {
                this.a(world, chunkBox, 4, 1, 2, 4, 3, 4, StructurePiece.z, StructurePiece.z, false);
            }
        }
    }

    public static class WorldGenStrongholdPrison
    extends WorldGenStrongholdPiece {
        protected static final int a = 9;
        protected static final int b = 5;
        protected static final int c = 11;

        public WorldGenStrongholdPrison(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.z, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
        }

        public WorldGenStrongholdPrison(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.z, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenStrongholdStart)start, holder, random, 1, 1);
        }

        public static WorldGenStrongholdPrison a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 9, 5, 11, orientation);
            if (!WorldGenStrongholdPrison.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdPrison(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 8, 4, 10, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 1, 0);
            this.a(world, chunkBox, 1, 1, 10, 3, 3, 10, StructurePiece.z, StructurePiece.z, false);
            this.a(world, chunkBox, 4, 1, 1, 4, 3, 1, false, random, k);
            this.a(world, chunkBox, 4, 1, 3, 4, 3, 3, false, random, k);
            this.a(world, chunkBox, 4, 1, 7, 4, 3, 7, false, random, k);
            this.a(world, chunkBox, 4, 1, 9, 4, 3, 9, false, random, k);
            for (int i2 = 1; i2 <= 3; ++i2) {
                this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.a, true)).a(BlockTall.c, true), 4, i2, 4, chunkBox);
                this.c(world, (IBlockData)((IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.a, true)).a(BlockTall.c, true)).a(BlockTall.b, true), 4, i2, 5, chunkBox);
                this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.a, true)).a(BlockTall.c, true), 4, i2, 6, chunkBox);
                this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.d, true)).a(BlockTall.b, true), 5, i2, 5, chunkBox);
                this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.d, true)).a(BlockTall.b, true), 6, i2, 5, chunkBox);
                this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.d, true)).a(BlockTall.b, true), 7, i2, 5, chunkBox);
            }
            this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.a, true)).a(BlockTall.c, true), 4, 3, 2, chunkBox);
            this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.a, true)).a(BlockTall.c, true), 4, 3, 8, chunkBox);
            IBlockData blockState = (IBlockData)Blocks.cy.n().a(BlockDoor.a, EnumDirection.e);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.cy.n().a(BlockDoor.a, EnumDirection.e)).a(BlockDoor.e, BlockPropertyDoubleBlockHalf.a);
            this.c(world, blockState, 4, 1, 2, chunkBox);
            this.c(world, blockState2, 4, 2, 2, chunkBox);
            this.c(world, blockState, 4, 1, 8, chunkBox);
            this.c(world, blockState2, 4, 2, 8, chunkBox);
        }
    }

    public static class WorldGenStrongholdLeftTurn
    extends q {
        public WorldGenStrongholdLeftTurn(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.w, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
        }

        public WorldGenStrongholdLeftTurn(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.w, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            EnumDirection direction = this.h();
            if (direction == EnumDirection.c || direction == EnumDirection.f) {
                this.b((WorldGenStrongholdStart)start, holder, random, 1, 1);
            } else {
                this.c((WorldGenStrongholdStart)start, holder, random, 1, 1);
            }
        }

        public static WorldGenStrongholdLeftTurn a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, 5, orientation);
            if (!WorldGenStrongholdLeftTurn.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdLeftTurn(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 4, 4, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 1, 0);
            EnumDirection direction = this.h();
            if (direction == EnumDirection.c || direction == EnumDirection.f) {
                this.a(world, chunkBox, 0, 1, 1, 0, 3, 3, StructurePiece.z, StructurePiece.z, false);
            } else {
                this.a(world, chunkBox, 4, 1, 1, 4, 3, 3, StructurePiece.z, StructurePiece.z, false);
            }
        }
    }

    public static class WorldGenStrongholdRightTurn
    extends q {
        public WorldGenStrongholdRightTurn(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.A, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
        }

        public WorldGenStrongholdRightTurn(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.A, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            EnumDirection direction = this.h();
            if (direction == EnumDirection.c || direction == EnumDirection.f) {
                this.c((WorldGenStrongholdStart)start, holder, random, 1, 1);
            } else {
                this.b((WorldGenStrongholdStart)start, holder, random, 1, 1);
            }
        }

        public static WorldGenStrongholdRightTurn a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, 5, orientation);
            if (!WorldGenStrongholdRightTurn.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdRightTurn(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 4, 4, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 1, 0);
            EnumDirection direction = this.h();
            if (direction == EnumDirection.c || direction == EnumDirection.f) {
                this.a(world, chunkBox, 4, 1, 1, 4, 3, 3, StructurePiece.z, StructurePiece.z, false);
            } else {
                this.a(world, chunkBox, 0, 1, 1, 0, 3, 3, StructurePiece.z, StructurePiece.z, false);
            }
        }
    }

    public static class WorldGenStrongholdRoomCrossing
    extends WorldGenStrongholdPiece {
        protected static final int a = 11;
        protected static final int b = 7;
        protected static final int c = 11;
        protected final int d;

        public WorldGenStrongholdRoomCrossing(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.B, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
            this.d = random.nextInt(5);
        }

        public WorldGenStrongholdRoomCrossing(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.B, nbt);
            this.d = nbt.h("Type");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Type", this.d);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenStrongholdStart)start, holder, random, 4, 1);
            this.b((WorldGenStrongholdStart)start, holder, random, 1, 4);
            this.c((WorldGenStrongholdStart)start, holder, random, 1, 4);
        }

        public static WorldGenStrongholdRoomCrossing a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -4, -1, 0, 11, 7, 11, orientation);
            if (!WorldGenStrongholdRoomCrossing.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdRoomCrossing(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 10, 6, 10, true, random, k);
            this.a(world, random, chunkBox, this.e, 4, 1, 0);
            this.a(world, chunkBox, 4, 1, 10, 6, 3, 10, StructurePiece.z, StructurePiece.z, false);
            this.a(world, chunkBox, 0, 1, 4, 0, 3, 6, StructurePiece.z, StructurePiece.z, false);
            this.a(world, chunkBox, 10, 1, 4, 10, 3, 6, StructurePiece.z, StructurePiece.z, false);
            switch (this.d) {
                default: {
                    break;
                }
                case 0: {
                    this.c(world, Blocks.dC.n(), 5, 1, 5, chunkBox);
                    this.c(world, Blocks.dC.n(), 5, 2, 5, chunkBox);
                    this.c(world, Blocks.dC.n(), 5, 3, 5, chunkBox);
                    this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.e), 4, 3, 5, chunkBox);
                    this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.f), 6, 3, 5, chunkBox);
                    this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.d), 5, 3, 4, chunkBox);
                    this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.c), 5, 3, 6, chunkBox);
                    this.c(world, Blocks.if.n(), 4, 1, 4, chunkBox);
                    this.c(world, Blocks.if.n(), 4, 1, 5, chunkBox);
                    this.c(world, Blocks.if.n(), 4, 1, 6, chunkBox);
                    this.c(world, Blocks.if.n(), 6, 1, 4, chunkBox);
                    this.c(world, Blocks.if.n(), 6, 1, 5, chunkBox);
                    this.c(world, Blocks.if.n(), 6, 1, 6, chunkBox);
                    this.c(world, Blocks.if.n(), 5, 1, 4, chunkBox);
                    this.c(world, Blocks.if.n(), 5, 1, 6, chunkBox);
                    break;
                }
                case 1: {
                    for (int i2 = 0; i2 < 5; ++i2) {
                        this.c(world, Blocks.dC.n(), 3, 1, 3 + i2, chunkBox);
                        this.c(world, Blocks.dC.n(), 7, 1, 3 + i2, chunkBox);
                        this.c(world, Blocks.dC.n(), 3 + i2, 1, 3, chunkBox);
                        this.c(world, Blocks.dC.n(), 3 + i2, 1, 7, chunkBox);
                    }
                    this.c(world, Blocks.dC.n(), 5, 1, 5, chunkBox);
                    this.c(world, Blocks.dC.n(), 5, 2, 5, chunkBox);
                    this.c(world, Blocks.dC.n(), 5, 3, 5, chunkBox);
                    this.c(world, Blocks.A.n(), 5, 4, 5, chunkBox);
                    break;
                }
                case 2: {
                    for (int j2 = 1; j2 <= 9; ++j2) {
                        this.c(world, Blocks.m.n(), 1, 3, j2, chunkBox);
                        this.c(world, Blocks.m.n(), 9, 3, j2, chunkBox);
                    }
                    for (int k2 = 1; k2 <= 9; ++k2) {
                        this.c(world, Blocks.m.n(), k2, 3, 1, chunkBox);
                        this.c(world, Blocks.m.n(), k2, 3, 9, chunkBox);
                    }
                    this.c(world, Blocks.m.n(), 5, 1, 4, chunkBox);
                    this.c(world, Blocks.m.n(), 5, 1, 6, chunkBox);
                    this.c(world, Blocks.m.n(), 5, 3, 4, chunkBox);
                    this.c(world, Blocks.m.n(), 5, 3, 6, chunkBox);
                    this.c(world, Blocks.m.n(), 4, 1, 5, chunkBox);
                    this.c(world, Blocks.m.n(), 6, 1, 5, chunkBox);
                    this.c(world, Blocks.m.n(), 4, 3, 5, chunkBox);
                    this.c(world, Blocks.m.n(), 6, 3, 5, chunkBox);
                    for (int l2 = 1; l2 <= 3; ++l2) {
                        this.c(world, Blocks.m.n(), 4, l2, 4, chunkBox);
                        this.c(world, Blocks.m.n(), 6, l2, 4, chunkBox);
                        this.c(world, Blocks.m.n(), 4, l2, 6, chunkBox);
                        this.c(world, Blocks.m.n(), 6, l2, 6, chunkBox);
                    }
                    this.c(world, Blocks.bR.n(), 5, 3, 5, chunkBox);
                    for (int m2 = 2; m2 <= 8; ++m2) {
                        this.c(world, Blocks.n.n(), 2, 3, m2, chunkBox);
                        this.c(world, Blocks.n.n(), 3, 3, m2, chunkBox);
                        if (m2 <= 3 || m2 >= 7) {
                            this.c(world, Blocks.n.n(), 4, 3, m2, chunkBox);
                            this.c(world, Blocks.n.n(), 5, 3, m2, chunkBox);
                            this.c(world, Blocks.n.n(), 6, 3, m2, chunkBox);
                        }
                        this.c(world, Blocks.n.n(), 7, 3, m2, chunkBox);
                        this.c(world, Blocks.n.n(), 8, 3, m2, chunkBox);
                    }
                    IBlockData blockState = (IBlockData)Blocks.cn.n().a(BlockLadder.a, EnumDirection.e);
                    this.c(world, blockState, 9, 1, 3, chunkBox);
                    this.c(world, blockState, 9, 2, 3, chunkBox);
                    this.c(world, blockState, 9, 3, 3, chunkBox);
                    this.a(world, chunkBox, random, 3, 4, 8, LootTables.x);
                }
            }
        }
    }

    public static class WorldGenStrongholdStairsStraight
    extends WorldGenStrongholdPiece {
        private static final int a = 5;
        private static final int b = 11;
        private static final int c = 8;

        public WorldGenStrongholdStairsStraight(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.F, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
        }

        public WorldGenStrongholdStairsStraight(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.F, nbt);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenStrongholdStart)start, holder, random, 1, 1);
        }

        public static WorldGenStrongholdStairsStraight a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -7, 0, 5, 11, 8, orientation);
            if (!WorldGenStrongholdStairsStraight.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdStairsStraight(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 10, 7, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 7, 0);
            this.a(world, random, chunkBox, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.a, 1, 1, 7);
            IBlockData blockState = (IBlockData)Blocks.cp.n().a(BlockStairs.a, EnumDirection.d);
            for (int i2 = 0; i2 < 6; ++i2) {
                this.c(world, blockState, 1, 6 - i2, 1 + i2, chunkBox);
                this.c(world, blockState, 2, 6 - i2, 1 + i2, chunkBox);
                this.c(world, blockState, 3, 6 - i2, 1 + i2, chunkBox);
                if (i2 >= 5) continue;
                this.c(world, Blocks.dC.n(), 1, 5 - i2, 1 + i2, chunkBox);
                this.c(world, Blocks.dC.n(), 2, 5 - i2, 1 + i2, chunkBox);
                this.c(world, Blocks.dC.n(), 3, 5 - i2, 1 + i2, chunkBox);
            }
        }
    }

    public static class WorldGenStrongholdStairs2
    extends WorldGenStrongholdPiece {
        private static final int a = 5;
        private static final int b = 11;
        private static final int c = 5;
        private final boolean d;

        public WorldGenStrongholdStairs2(WorldGenFeatureStructurePieceType structurePieceType, int chainLength, int x2, int z2, EnumDirection orientation) {
            super(structurePieceType, chainLength, WorldGenStrongholdStairs2.a(x2, 64, z2, orientation, 5, 11, 5));
            this.d = true;
            this.a(orientation);
            this.e = WorldGenStrongholdPiece.WorldGenStrongholdDoorType.a;
        }

        public WorldGenStrongholdStairs2(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.C, chainLength, boundingBox);
            this.d = false;
            this.a(orientation);
            this.e = this.a(random);
        }

        public WorldGenStrongholdStairs2(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
            this.d = nbt.q("Source");
        }

        public WorldGenStrongholdStairs2(NBTTagCompound nbt) {
            this(WorldGenFeatureStructurePieceType.C, nbt);
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Source", this.d);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            if (this.d) {
                i = WorldGenStrongholdCrossing.class;
            }
            this.a((WorldGenStrongholdStart)start, holder, random, 1, 1);
        }

        public static WorldGenStrongholdStairs2 a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -7, 0, 5, 11, 5, orientation);
            if (!WorldGenStrongholdStairs2.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdStairs2(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 10, 4, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 7, 0);
            this.a(world, random, chunkBox, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.a, 1, 1, 4);
            this.c(world, Blocks.dC.n(), 2, 6, 1, chunkBox);
            this.c(world, Blocks.dC.n(), 1, 5, 1, chunkBox);
            this.c(world, Blocks.if.n(), 1, 6, 1, chunkBox);
            this.c(world, Blocks.dC.n(), 1, 5, 2, chunkBox);
            this.c(world, Blocks.dC.n(), 1, 4, 3, chunkBox);
            this.c(world, Blocks.if.n(), 1, 5, 3, chunkBox);
            this.c(world, Blocks.dC.n(), 2, 4, 3, chunkBox);
            this.c(world, Blocks.dC.n(), 3, 3, 3, chunkBox);
            this.c(world, Blocks.if.n(), 3, 4, 3, chunkBox);
            this.c(world, Blocks.dC.n(), 3, 3, 2, chunkBox);
            this.c(world, Blocks.dC.n(), 3, 2, 1, chunkBox);
            this.c(world, Blocks.if.n(), 3, 3, 1, chunkBox);
            this.c(world, Blocks.dC.n(), 2, 2, 1, chunkBox);
            this.c(world, Blocks.dC.n(), 1, 1, 1, chunkBox);
            this.c(world, Blocks.if.n(), 1, 2, 1, chunkBox);
            this.c(world, Blocks.dC.n(), 1, 1, 2, chunkBox);
            this.c(world, Blocks.if.n(), 1, 1, 3, chunkBox);
        }
    }

    public static class WorldGenStrongholdCrossing
    extends WorldGenStrongholdPiece {
        protected static final int a = 10;
        protected static final int b = 9;
        protected static final int c = 11;
        private final boolean d;
        private final boolean f;
        private final boolean g;
        private final boolean h;

        public WorldGenStrongholdCrossing(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.v, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
            this.d = random.nextBoolean();
            this.f = random.nextBoolean();
            this.g = random.nextBoolean();
            this.h = random.nextInt(3) > 0;
        }

        public WorldGenStrongholdCrossing(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.v, nbt);
            this.d = nbt.q("leftLow");
            this.f = nbt.q("leftHigh");
            this.g = nbt.q("rightLow");
            this.h = nbt.q("rightHigh");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("leftLow", this.d);
            nbt.a("leftHigh", this.f);
            nbt.a("rightLow", this.g);
            nbt.a("rightHigh", this.h);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            int i2 = 3;
            int j2 = 5;
            EnumDirection direction = this.h();
            if (direction == EnumDirection.e || direction == EnumDirection.c) {
                i2 = 8 - i2;
                j2 = 8 - j2;
            }
            this.a((WorldGenStrongholdStart)start, holder, random, 5, 1);
            if (this.d) {
                this.b((WorldGenStrongholdStart)start, holder, random, i2, 1);
            }
            if (this.f) {
                this.b((WorldGenStrongholdStart)start, holder, random, j2, 7);
            }
            if (this.g) {
                this.c((WorldGenStrongholdStart)start, holder, random, i2, 1);
            }
            if (this.h) {
                this.c((WorldGenStrongholdStart)start, holder, random, j2, 7);
            }
        }

        public static WorldGenStrongholdCrossing a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -4, -3, 0, 10, 9, 11, orientation);
            if (!WorldGenStrongholdCrossing.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdCrossing(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 9, 8, 10, true, random, k);
            this.a(world, random, chunkBox, this.e, 4, 3, 0);
            if (this.d) {
                this.a(world, chunkBox, 0, 3, 1, 0, 5, 3, StructurePiece.z, StructurePiece.z, false);
            }
            if (this.g) {
                this.a(world, chunkBox, 9, 3, 1, 9, 5, 3, StructurePiece.z, StructurePiece.z, false);
            }
            if (this.f) {
                this.a(world, chunkBox, 0, 5, 7, 0, 7, 9, StructurePiece.z, StructurePiece.z, false);
            }
            if (this.h) {
                this.a(world, chunkBox, 9, 5, 7, 9, 7, 9, StructurePiece.z, StructurePiece.z, false);
            }
            this.a(world, chunkBox, 5, 1, 10, 7, 3, 10, StructurePiece.z, StructurePiece.z, false);
            this.a(world, chunkBox, 1, 2, 1, 8, 2, 6, false, random, k);
            this.a(world, chunkBox, 4, 1, 5, 4, 4, 9, false, random, k);
            this.a(world, chunkBox, 8, 1, 5, 8, 4, 9, false, random, k);
            this.a(world, chunkBox, 1, 4, 7, 3, 4, 9, false, random, k);
            this.a(world, chunkBox, 1, 3, 5, 3, 3, 6, false, random, k);
            this.a(world, chunkBox, 1, 3, 4, 3, 3, 4, Blocks.if.n(), Blocks.if.n(), false);
            this.a(world, chunkBox, 1, 4, 6, 3, 4, 6, Blocks.if.n(), Blocks.if.n(), false);
            this.a(world, chunkBox, 5, 1, 7, 7, 1, 8, false, random, k);
            this.a(world, chunkBox, 5, 1, 9, 7, 1, 9, Blocks.if.n(), Blocks.if.n(), false);
            this.a(world, chunkBox, 5, 2, 7, 7, 2, 7, Blocks.if.n(), Blocks.if.n(), false);
            this.a(world, chunkBox, 4, 5, 7, 4, 5, 9, Blocks.if.n(), Blocks.if.n(), false);
            this.a(world, chunkBox, 8, 5, 7, 8, 5, 9, Blocks.if.n(), Blocks.if.n(), false);
            this.a(world, chunkBox, 5, 5, 7, 7, 5, 9, (IBlockData)Blocks.if.n().a(BlockStepAbstract.a, BlockPropertySlabType.c), (IBlockData)Blocks.if.n().a(BlockStepAbstract.a, BlockPropertySlabType.c), false);
            this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.d), 6, 5, 6, chunkBox);
        }
    }

    public static class WorldGenStrongholdChestCorridor
    extends WorldGenStrongholdPiece {
        private static final int a = 5;
        private static final int b = 5;
        private static final int c = 7;
        private boolean d;

        public WorldGenStrongholdChestCorridor(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.t, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
        }

        public WorldGenStrongholdChestCorridor(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.t, nbt);
            this.d = nbt.q("Chest");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Chest", this.d);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            this.a((WorldGenStrongholdStart)start, holder, random, 1, 1);
        }

        public static WorldGenStrongholdChestCorridor a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainlength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, 7, orientation);
            if (!WorldGenStrongholdChestCorridor.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdChestCorridor(chainlength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            this.a(world, chunkBox, 0, 0, 0, 4, 4, 6, true, random, k);
            this.a(world, random, chunkBox, this.e, 1, 1, 0);
            this.a(world, random, chunkBox, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.a, 1, 1, 6);
            this.a(world, chunkBox, 3, 1, 2, 3, 1, 4, Blocks.dC.n(), Blocks.dC.n(), false);
            this.c(world, Blocks.il.n(), 3, 1, 1, chunkBox);
            this.c(world, Blocks.il.n(), 3, 1, 5, chunkBox);
            this.c(world, Blocks.il.n(), 3, 2, 2, chunkBox);
            this.c(world, Blocks.il.n(), 3, 2, 4, chunkBox);
            for (int i2 = 2; i2 <= 4; ++i2) {
                this.c(world, Blocks.il.n(), 2, 1, i2, chunkBox);
            }
            if (!this.d && chunkBox.b(this.c(3, 2, 3))) {
                this.d = true;
                this.a(world, chunkBox, random, 3, 2, 3, LootTables.y);
            }
        }
    }

    public static class WorldGenStrongholdLibrary
    extends WorldGenStrongholdPiece {
        protected static final int a = 14;
        protected static final int b = 6;
        protected static final int c = 11;
        protected static final int d = 15;
        private final boolean f;

        public WorldGenStrongholdLibrary(int chainLength, Random random, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.x, chainLength, boundingBox);
            this.a(orientation);
            this.e = this.a(random);
            this.f = boundingBox.d() > 6;
        }

        public WorldGenStrongholdLibrary(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.x, nbt);
            this.f = nbt.q("Tall");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Tall", this.f);
        }

        public static WorldGenStrongholdLibrary a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -4, -1, 0, 14, 11, 15, orientation);
            if (!(WorldGenStrongholdLibrary.a(boundingBox) && holder.a(boundingBox) == null || WorldGenStrongholdLibrary.a(boundingBox = StructureBoundingBox.a(x2, y2, z2, -4, -1, 0, 14, 6, 15, orientation)) && holder.a(boundingBox) == null)) {
                return null;
            }
            return new WorldGenStrongholdLibrary(chainLength, random, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            int i2 = 11;
            if (!this.f) {
                i2 = 6;
            }
            this.a(world, chunkBox, 0, 0, 0, 13, i2 - 1, 14, true, random, k);
            this.a(world, random, chunkBox, this.e, 4, 1, 0);
            this.a(world, chunkBox, random, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.aW.n(), Blocks.aW.n(), false, false);
            boolean j2 = true;
            int k2 = 12;
            for (int l2 = 1; l2 <= 13; ++l2) {
                if ((l2 - 1) % 4 == 0) {
                    this.a(world, chunkBox, 1, 1, l2, 1, 4, l2, Blocks.n.n(), Blocks.n.n(), false);
                    this.a(world, chunkBox, 12, 1, l2, 12, 4, l2, Blocks.n.n(), Blocks.n.n(), false);
                    this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.f), 2, 3, l2, chunkBox);
                    this.c(world, (IBlockData)Blocks.bS.n().a(BlockTorchWall.a, EnumDirection.e), 11, 3, l2, chunkBox);
                    if (!this.f) continue;
                    this.a(world, chunkBox, 1, 6, l2, 1, 9, l2, Blocks.n.n(), Blocks.n.n(), false);
                    this.a(world, chunkBox, 12, 6, l2, 12, 9, l2, Blocks.n.n(), Blocks.n.n(), false);
                    continue;
                }
                this.a(world, chunkBox, 1, 1, l2, 1, 4, l2, Blocks.bO.n(), Blocks.bO.n(), false);
                this.a(world, chunkBox, 12, 1, l2, 12, 4, l2, Blocks.bO.n(), Blocks.bO.n(), false);
                if (!this.f) continue;
                this.a(world, chunkBox, 1, 6, l2, 1, 9, l2, Blocks.bO.n(), Blocks.bO.n(), false);
                this.a(world, chunkBox, 12, 6, l2, 12, 9, l2, Blocks.bO.n(), Blocks.bO.n(), false);
            }
            for (int m2 = 3; m2 < 12; m2 += 2) {
                this.a(world, chunkBox, 3, 1, m2, 4, 3, m2, Blocks.bO.n(), Blocks.bO.n(), false);
                this.a(world, chunkBox, 6, 1, m2, 7, 3, m2, Blocks.bO.n(), Blocks.bO.n(), false);
                this.a(world, chunkBox, 9, 1, m2, 10, 3, m2, Blocks.bO.n(), Blocks.bO.n(), false);
            }
            if (this.f) {
                this.a(world, chunkBox, 1, 5, 1, 3, 5, 13, Blocks.n.n(), Blocks.n.n(), false);
                this.a(world, chunkBox, 10, 5, 1, 12, 5, 13, Blocks.n.n(), Blocks.n.n(), false);
                this.a(world, chunkBox, 4, 5, 1, 9, 5, 2, Blocks.n.n(), Blocks.n.n(), false);
                this.a(world, chunkBox, 4, 5, 12, 9, 5, 13, Blocks.n.n(), Blocks.n.n(), false);
                this.c(world, Blocks.n.n(), 9, 5, 11, chunkBox);
                this.c(world, Blocks.n.n(), 8, 5, 11, chunkBox);
                this.c(world, Blocks.n.n(), 9, 5, 10, chunkBox);
                IBlockData blockState = (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.d, true)).a(BlockTall.b, true);
                IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.a, true)).a(BlockTall.c, true);
                this.a(world, chunkBox, 3, 6, 3, 3, 6, 11, blockState2, blockState2, false);
                this.a(world, chunkBox, 10, 6, 3, 10, 6, 9, blockState2, blockState2, false);
                this.a(world, chunkBox, 4, 6, 2, 9, 6, 2, blockState, blockState, false);
                this.a(world, chunkBox, 4, 6, 12, 7, 6, 12, blockState, blockState, false);
                this.c(world, (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.a, true)).a(BlockTall.b, true), 3, 6, 2, chunkBox);
                this.c(world, (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.c, true)).a(BlockTall.b, true), 3, 6, 12, chunkBox);
                this.c(world, (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.a, true)).a(BlockTall.d, true), 10, 6, 2, chunkBox);
                for (int n2 = 0; n2 <= 2; ++n2) {
                    this.c(world, (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.c, true)).a(BlockTall.d, true), 8 + n2, 6, 12 - n2, chunkBox);
                    if (n2 == 2) continue;
                    this.c(world, (IBlockData)((IBlockData)Blocks.cR.n().a(BlockTall.a, true)).a(BlockTall.b, true), 8 + n2, 6, 11 - n2, chunkBox);
                }
                IBlockData blockState3 = (IBlockData)Blocks.cn.n().a(BlockLadder.a, EnumDirection.d);
                this.c(world, blockState3, 10, 1, 13, chunkBox);
                this.c(world, blockState3, 10, 2, 13, chunkBox);
                this.c(world, blockState3, 10, 3, 13, chunkBox);
                this.c(world, blockState3, 10, 4, 13, chunkBox);
                this.c(world, blockState3, 10, 5, 13, chunkBox);
                this.c(world, blockState3, 10, 6, 13, chunkBox);
                this.c(world, blockState3, 10, 7, 13, chunkBox);
                int o2 = 7;
                int p2 = 7;
                IBlockData blockState4 = (IBlockData)Blocks.cR.n().a(BlockTall.b, true);
                this.c(world, blockState4, 6, 9, 7, chunkBox);
                IBlockData blockState5 = (IBlockData)Blocks.cR.n().a(BlockTall.d, true);
                this.c(world, blockState5, 7, 9, 7, chunkBox);
                this.c(world, blockState4, 6, 8, 7, chunkBox);
                this.c(world, blockState5, 7, 8, 7, chunkBox);
                IBlockData blockState6 = (IBlockData)((IBlockData)blockState2.a(BlockTall.d, true)).a(BlockTall.b, true);
                this.c(world, blockState6, 6, 7, 7, chunkBox);
                this.c(world, blockState6, 7, 7, 7, chunkBox);
                this.c(world, blockState4, 5, 7, 7, chunkBox);
                this.c(world, blockState5, 8, 7, 7, chunkBox);
                this.c(world, (IBlockData)blockState4.a(BlockTall.a, true), 6, 7, 6, chunkBox);
                this.c(world, (IBlockData)blockState4.a(BlockTall.c, true), 6, 7, 8, chunkBox);
                this.c(world, (IBlockData)blockState5.a(BlockTall.a, true), 7, 7, 6, chunkBox);
                this.c(world, (IBlockData)blockState5.a(BlockTall.c, true), 7, 7, 8, chunkBox);
                IBlockData blockState7 = Blocks.bR.n();
                this.c(world, blockState7, 5, 8, 7, chunkBox);
                this.c(world, blockState7, 8, 8, 7, chunkBox);
                this.c(world, blockState7, 6, 8, 6, chunkBox);
                this.c(world, blockState7, 6, 8, 8, chunkBox);
                this.c(world, blockState7, 7, 8, 6, chunkBox);
                this.c(world, blockState7, 7, 8, 8, chunkBox);
            }
            this.a(world, chunkBox, random, 3, 3, 5, LootTables.w);
            if (this.f) {
                this.c(world, StructurePiece.z, 12, 9, 1, chunkBox);
                this.a(world, chunkBox, random, 12, 8, 1, LootTables.w);
            }
        }
    }

    public static class WorldGenStrongholdPortalRoom
    extends WorldGenStrongholdPiece {
        protected static final int a = 11;
        protected static final int b = 8;
        protected static final int c = 16;
        private boolean d;

        public WorldGenStrongholdPortalRoom(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.y, chainLength, boundingBox);
            this.a(orientation);
        }

        public WorldGenStrongholdPortalRoom(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.y, nbt);
            this.d = nbt.q("Mob");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Mob", this.d);
        }

        @Override
        @Override
        public void a(StructurePiece start, StructurePieceAccessor holder, Random random) {
            if (start != null) {
                ((WorldGenStrongholdStart)start).b = this;
            }
        }

        public static WorldGenStrongholdPortalRoom a(StructurePieceAccessor holder, int x2, int y2, int z2, EnumDirection orientation, int chainLength) {
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -4, -1, 0, 11, 8, 16, orientation);
            if (!WorldGenStrongholdPortalRoom.a(boundingBox) || holder.a(boundingBox) != null) {
                return null;
            }
            return new WorldGenStrongholdPortalRoom(chainLength, boundingBox, orientation);
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            BlockPosition.MutableBlockPosition blockPos;
            this.a(world, chunkBox, 0, 0, 0, 10, 7, 15, false, random, k);
            this.a(world, random, chunkBox, WorldGenStrongholdPiece.WorldGenStrongholdDoorType.c, 4, 1, 0);
            int i2 = 6;
            this.a(world, chunkBox, 1, i2, 1, 1, i2, 14, false, random, k);
            this.a(world, chunkBox, 9, i2, 1, 9, i2, 14, false, random, k);
            this.a(world, chunkBox, 2, i2, 1, 8, i2, 2, false, random, k);
            this.a(world, chunkBox, 2, i2, 14, 8, i2, 14, false, random, k);
            this.a(world, chunkBox, 1, 1, 1, 2, 1, 4, false, random, k);
            this.a(world, chunkBox, 8, 1, 1, 9, 1, 4, false, random, k);
            this.a(world, chunkBox, 1, 1, 1, 1, 1, 3, Blocks.B.n(), Blocks.B.n(), false);
            this.a(world, chunkBox, 9, 1, 1, 9, 1, 3, Blocks.B.n(), Blocks.B.n(), false);
            this.a(world, chunkBox, 3, 1, 8, 7, 1, 12, false, random, k);
            this.a(world, chunkBox, 4, 1, 9, 6, 1, 11, Blocks.B.n(), Blocks.B.n(), false);
            IBlockData blockState = (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.a, true)).a(BlockTall.c, true);
            IBlockData blockState2 = (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.d, true)).a(BlockTall.b, true);
            for (int j2 = 3; j2 < 14; j2 += 2) {
                this.a(world, chunkBox, 0, 3, j2, 0, 4, j2, blockState, blockState, false);
                this.a(world, chunkBox, 10, 3, j2, 10, 4, j2, blockState, blockState, false);
            }
            for (int k2 = 2; k2 < 9; k2 += 2) {
                this.a(world, chunkBox, k2, 3, 15, k2, 4, 15, blockState2, blockState2, false);
            }
            IBlockData blockState3 = (IBlockData)Blocks.eb.n().a(BlockStairs.a, EnumDirection.c);
            this.a(world, chunkBox, 4, 1, 5, 6, 1, 7, false, random, k);
            this.a(world, chunkBox, 4, 2, 6, 6, 2, 7, false, random, k);
            this.a(world, chunkBox, 4, 3, 7, 6, 3, 7, false, random, k);
            for (int l2 = 4; l2 <= 6; ++l2) {
                this.c(world, blockState3, l2, 1, 4, chunkBox);
                this.c(world, blockState3, l2, 2, 5, chunkBox);
                this.c(world, blockState3, l2, 3, 6, chunkBox);
            }
            IBlockData blockState4 = (IBlockData)Blocks.ep.n().a(BlockEnderPortalFrame.a, EnumDirection.c);
            IBlockData blockState5 = (IBlockData)Blocks.ep.n().a(BlockEnderPortalFrame.a, EnumDirection.d);
            IBlockData blockState6 = (IBlockData)Blocks.ep.n().a(BlockEnderPortalFrame.a, EnumDirection.f);
            IBlockData blockState7 = (IBlockData)Blocks.ep.n().a(BlockEnderPortalFrame.a, EnumDirection.e);
            boolean bl = true;
            boolean[] bls = new boolean[12];
            for (int m2 = 0; m2 < bls.length; ++m2) {
                bls[m2] = random.nextFloat() > 0.9f;
                bl &= bls[m2];
            }
            this.c(world, (IBlockData)blockState4.a(BlockEnderPortalFrame.b, bls[0]), 4, 3, 8, chunkBox);
            this.c(world, (IBlockData)blockState4.a(BlockEnderPortalFrame.b, bls[1]), 5, 3, 8, chunkBox);
            this.c(world, (IBlockData)blockState4.a(BlockEnderPortalFrame.b, bls[2]), 6, 3, 8, chunkBox);
            this.c(world, (IBlockData)blockState5.a(BlockEnderPortalFrame.b, bls[3]), 4, 3, 12, chunkBox);
            this.c(world, (IBlockData)blockState5.a(BlockEnderPortalFrame.b, bls[4]), 5, 3, 12, chunkBox);
            this.c(world, (IBlockData)blockState5.a(BlockEnderPortalFrame.b, bls[5]), 6, 3, 12, chunkBox);
            this.c(world, (IBlockData)blockState6.a(BlockEnderPortalFrame.b, bls[6]), 3, 3, 9, chunkBox);
            this.c(world, (IBlockData)blockState6.a(BlockEnderPortalFrame.b, bls[7]), 3, 3, 10, chunkBox);
            this.c(world, (IBlockData)blockState6.a(BlockEnderPortalFrame.b, bls[8]), 3, 3, 11, chunkBox);
            this.c(world, (IBlockData)blockState7.a(BlockEnderPortalFrame.b, bls[9]), 7, 3, 9, chunkBox);
            this.c(world, (IBlockData)blockState7.a(BlockEnderPortalFrame.b, bls[10]), 7, 3, 10, chunkBox);
            this.c(world, (IBlockData)blockState7.a(BlockEnderPortalFrame.b, bls[11]), 7, 3, 11, chunkBox);
            if (bl) {
                IBlockData blockState8 = Blocks.eo.n();
                this.c(world, blockState8, 4, 3, 9, chunkBox);
                this.c(world, blockState8, 5, 3, 9, chunkBox);
                this.c(world, blockState8, 6, 3, 9, chunkBox);
                this.c(world, blockState8, 4, 3, 10, chunkBox);
                this.c(world, blockState8, 5, 3, 10, chunkBox);
                this.c(world, blockState8, 6, 3, 10, chunkBox);
                this.c(world, blockState8, 4, 3, 11, chunkBox);
                this.c(world, blockState8, 5, 3, 11, chunkBox);
                this.c(world, blockState8, 6, 3, 11, chunkBox);
            }
            if (!this.d && chunkBox.b(blockPos = this.c(5, 3, 6))) {
                this.d = true;
                world.a((BlockPosition)blockPos, Blocks.bV.n(), 2);
                TileEntity blockEntity = world.c_(blockPos);
                if (blockEntity instanceof TileEntityMobSpawner) {
                    ((TileEntityMobSpawner)blockEntity).d().a(EntityTypes.aA);
                }
            }
        }
    }

    static abstract class WorldGenStrongholdPiece
    extends StructurePiece {
        protected WorldGenStrongholdDoorType e = WorldGenStrongholdDoorType.a;

        protected WorldGenStrongholdPiece(WorldGenFeatureStructurePieceType type, int length, StructureBoundingBox boundingBox) {
            super(type, length, boundingBox);
        }

        public WorldGenStrongholdPiece(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
            this.e = WorldGenStrongholdDoorType.valueOf(nbt.l("EntryDoor"));
        }

        @Override
        @Override
        public NoiseEffect ae_() {
            return NoiseEffect.b;
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            nbt.a("EntryDoor", this.e.name());
        }

        protected void a(GeneratorAccessSeed world, Random random, StructureBoundingBox boundingBox, WorldGenStrongholdDoorType type, int x2, int y2, int z2) {
            switch (type) {
                case a: {
                    this.a(world, boundingBox, x2, y2, z2, x2 + 3 - 1, y2 + 3 - 1, z2, StructurePiece.z, StructurePiece.z, false);
                    break;
                }
                case b: {
                    this.c(world, Blocks.dC.n(), x2, y2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2, y2 + 1, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2, y2 + 2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 1, y2 + 2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 2, y2 + 2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 2, y2 + 1, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 2, y2, z2, boundingBox);
                    this.c(world, Blocks.cm.n(), x2 + 1, y2, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.cm.n().a(BlockDoor.e, BlockPropertyDoubleBlockHalf.a), x2 + 1, y2 + 1, z2, boundingBox);
                    break;
                }
                case c: {
                    this.c(world, Blocks.lp.n(), x2 + 1, y2, z2, boundingBox);
                    this.c(world, Blocks.lp.n(), x2 + 1, y2 + 1, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.dP.n().a(BlockTall.d, true), x2, y2, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.dP.n().a(BlockTall.d, true), x2, y2 + 1, z2, boundingBox);
                    this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.b, true)).a(BlockTall.d, true), x2, y2 + 2, z2, boundingBox);
                    this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.b, true)).a(BlockTall.d, true), x2 + 1, y2 + 2, z2, boundingBox);
                    this.c(world, (IBlockData)((IBlockData)Blocks.dP.n().a(BlockTall.b, true)).a(BlockTall.d, true), x2 + 2, y2 + 2, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.dP.n().a(BlockTall.b, true), x2 + 2, y2 + 1, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.dP.n().a(BlockTall.b, true), x2 + 2, y2, z2, boundingBox);
                    break;
                }
                case d: {
                    this.c(world, Blocks.dC.n(), x2, y2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2, y2 + 1, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2, y2 + 2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 1, y2 + 2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 2, y2 + 2, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 2, y2 + 1, z2, boundingBox);
                    this.c(world, Blocks.dC.n(), x2 + 2, y2, z2, boundingBox);
                    this.c(world, Blocks.cy.n(), x2 + 1, y2, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.cy.n().a(BlockDoor.e, BlockPropertyDoubleBlockHalf.a), x2 + 1, y2 + 1, z2, boundingBox);
                    this.c(world, (IBlockData)Blocks.cJ.n().a(BlockFacingHorizontal.aD, EnumDirection.c), x2 + 2, y2 + 1, z2 + 1, boundingBox);
                    this.c(world, (IBlockData)Blocks.cJ.n().a(BlockFacingHorizontal.aD, EnumDirection.d), x2 + 2, y2 + 1, z2 - 1, boundingBox);
                }
            }
        }

        protected WorldGenStrongholdDoorType a(Random random) {
            int i2 = random.nextInt(5);
            switch (i2) {
                default: {
                    return WorldGenStrongholdDoorType.a;
                }
                case 2: {
                    return WorldGenStrongholdDoorType.b;
                }
                case 3: {
                    return WorldGenStrongholdDoorType.c;
                }
                case 4: 
            }
            return WorldGenStrongholdDoorType.d;
        }

        @Nullable
        protected StructurePiece a(WorldGenStrongholdStart start, StructurePieceAccessor holder, Random random, int leftRightOffset, int heightOffset) {
            EnumDirection direction = this.h();
            if (direction != null) {
                switch (direction) {
                    case c: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.i() - 1, direction, this.g());
                    }
                    case d: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.l() + 1, direction, this.g());
                    }
                    case e: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() - 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, direction, this.g());
                    }
                    case f: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.j() + 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, direction, this.g());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece b(WorldGenStrongholdStart start, StructurePieceAccessor holder, Random random, int heightOffset, int leftRightOffset) {
            EnumDirection direction = this.h();
            if (direction != null) {
                switch (direction) {
                    case c: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() - 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.e, this.g());
                    }
                    case d: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() - 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.e, this.g());
                    }
                    case e: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.i() - 1, EnumDirection.c, this.g());
                    }
                    case f: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.i() - 1, EnumDirection.c, this.g());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece c(WorldGenStrongholdStart start, StructurePieceAccessor holder, Random random, int heightOffset, int leftRightOffset) {
            EnumDirection direction = this.h();
            if (direction != null) {
                switch (direction) {
                    case c: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.j() + 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.f, this.g());
                    }
                    case d: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.j() + 1, this.A.h() + heightOffset, this.A.i() + leftRightOffset, EnumDirection.f, this.g());
                    }
                    case e: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.l() + 1, EnumDirection.d, this.g());
                    }
                    case f: {
                        return WorldGenStrongholdPieces.b(start, holder, random, this.A.g() + leftRightOffset, this.A.h() + heightOffset, this.A.l() + 1, EnumDirection.d, this.g());
                    }
                }
            }
            return null;
        }

        protected static boolean a(StructureBoundingBox boundingBox) {
            return boundingBox != null && boundingBox.h() > 10;
        }

        protected static final class WorldGenStrongholdDoorType
        extends Enum<WorldGenStrongholdDoorType> {
            public static final /* enum */ WorldGenStrongholdDoorType a = new WorldGenStrongholdDoorType();
            public static final /* enum */ WorldGenStrongholdDoorType b = new WorldGenStrongholdDoorType();
            public static final /* enum */ WorldGenStrongholdDoorType c = new WorldGenStrongholdDoorType();
            public static final /* enum */ WorldGenStrongholdDoorType d = new WorldGenStrongholdDoorType();
            private static final /* synthetic */ WorldGenStrongholdDoorType[] e;

            public static WorldGenStrongholdDoorType[] values() {
                return (WorldGenStrongholdDoorType[])e.clone();
            }

            public static WorldGenStrongholdDoorType valueOf(String string) {
                return Enum.valueOf(WorldGenStrongholdDoorType.class, string);
            }

            private static /* synthetic */ WorldGenStrongholdDoorType[] a() {
                return new WorldGenStrongholdDoorType[]{a, b, c, d};
            }

            static {
                e = WorldGenStrongholdDoorType.a();
            }
        }
    }

    public static class WorldGenStrongholdStart
    extends WorldGenStrongholdStairs2 {
        public WorldGenStrongholdPieceWeight a;
        @Nullable
        public WorldGenStrongholdPortalRoom b;
        public final List<StructurePiece> c = Lists.newArrayList();

        public WorldGenStrongholdStart(Random random, int i2, int j2) {
            super(WorldGenFeatureStructurePieceType.D, 0, i2, j2, WorldGenStrongholdStart.b(random));
        }

        public WorldGenStrongholdStart(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.D, nbt);
        }

        @Override
        @Override
        public BlockPosition af_() {
            if (this.b != null) {
                return this.b.af_();
            }
            return super.af_();
        }
    }

    public static class WorldGenStrongholdCorridor
    extends WorldGenStrongholdPiece {
        private final int a;

        public WorldGenStrongholdCorridor(int chainLength, StructureBoundingBox boundingBox, EnumDirection orientation) {
            super(WorldGenFeatureStructurePieceType.u, chainLength, boundingBox);
            this.a(orientation);
            this.a = orientation == EnumDirection.c || orientation == EnumDirection.d ? boundingBox.e() : boundingBox.c();
        }

        public WorldGenStrongholdCorridor(NBTTagCompound nbt) {
            super(WorldGenFeatureStructurePieceType.u, nbt);
            this.a = nbt.h("Steps");
        }

        @Override
        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound nbt) {
            super.a(context, nbt);
            nbt.a("Steps", this.a);
        }

        public static StructureBoundingBox a(StructurePieceAccessor holder, Random random, int x2, int y2, int z2, EnumDirection orientation) {
            int i2 = 3;
            StructureBoundingBox boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, 4, orientation);
            StructurePiece structurePiece = holder.a(boundingBox);
            if (structurePiece == null) {
                return null;
            }
            if (structurePiece.f().h() == boundingBox.h()) {
                for (int j2 = 2; j2 >= 1; --j2) {
                    boundingBox = StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, j2, orientation);
                    if (structurePiece.f().a(boundingBox)) continue;
                    return StructureBoundingBox.a(x2, y2, z2, -1, -1, 0, 5, 5, j2 + 1, orientation);
                }
            }
            return null;
        }

        @Override
        @Override
        public void a(GeneratorAccessSeed world, StructureManager structureAccessor, ChunkGenerator chunkGenerator, Random random, StructureBoundingBox chunkBox, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            for (int i2 = 0; i2 < this.a; ++i2) {
                this.c(world, Blocks.dC.n(), 0, 0, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 1, 0, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 2, 0, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 3, 0, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 4, 0, i2, chunkBox);
                for (int j2 = 1; j2 <= 3; ++j2) {
                    this.c(world, Blocks.dC.n(), 0, j2, i2, chunkBox);
                    this.c(world, Blocks.lp.n(), 1, j2, i2, chunkBox);
                    this.c(world, Blocks.lp.n(), 2, j2, i2, chunkBox);
                    this.c(world, Blocks.lp.n(), 3, j2, i2, chunkBox);
                    this.c(world, Blocks.dC.n(), 4, j2, i2, chunkBox);
                }
                this.c(world, Blocks.dC.n(), 0, 4, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 1, 4, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 2, 4, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 3, 4, i2, chunkBox);
                this.c(world, Blocks.dC.n(), 4, 4, i2, chunkBox);
            }
        }
    }

    static class WorldGenStrongholdStones
    extends StructurePiece.StructurePieceBlockSelector {
        WorldGenStrongholdStones() {
        }

        @Override
        @Override
        public void a(Random random, int x2, int y2, int z2, boolean placeBlock) {
            float f2;
            this.a = placeBlock ? ((f2 = random.nextFloat()) < 0.2f ? Blocks.dE.n() : (f2 < 0.5f ? Blocks.dD.n() : (f2 < 0.55f ? Blocks.dI.n() : Blocks.dC.n()))) : Blocks.lp.n();
        }
    }

    public static abstract class q
    extends WorldGenStrongholdPiece {
        protected static final int a = 5;
        protected static final int b = 5;
        protected static final int c = 5;

        protected q(WorldGenFeatureStructurePieceType type, int length, StructureBoundingBox boundingBox) {
            super(type, length, boundingBox);
        }

        public q(WorldGenFeatureStructurePieceType type, NBTTagCompound nbt) {
            super(type, nbt);
        }
    }
}

